/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Printable;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ScrollPaneLayout;
import javax.swing.ToolTipManager;
import javax.swing.ViewportLayout;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.DefaultRightTreeCellRenderer;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperContext;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MapperPanel;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.RightTreeCellRenderer;
import org.netbeans.modules.soa.mappercore.RightTreeEventHandler;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.graphics.VerticalGradient;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.utils.ScrollPaneWrapper;
import org.openide.util.NbBundle;

public class RightTree
extends MapperPanel
implements FocusListener,
Autoscroll {
    private RightTreeEventHandler eventHandler;
    private JScrollPane scrollPane;
    private ScrollPaneWrapper scrollPaneWrapper;
    private CellRendererPane cellRendererPane;
    private JLabel childrenLabel;
    private RightTreeCellRenderer treeCellRenderer = new DefaultRightTreeCellRenderer();
    private ActionListener actionEscape;
    private boolean printMode = false;

    RightTree(Mapper mapper) {
        super(mapper);
        this.putClientProperty(Printable.class, "");
        this.putClientProperty(Integer.class, new Integer(2));
        this.setBackground(Color.WHITE);
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setLayout(new RightScrollPaneLayout());
        this.scrollPane.getViewport().setLayout(new RightViewportLayout());
        this.scrollPane.setViewportView(this);
        this.scrollPane.setRowHeaderView(new RowHeader());
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", new BottomLeftCorner());
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.scrollPaneWrapper = new ScrollPaneWrapper(this.scrollPane);
        this.cellRendererPane = new CellRendererPane();
        this.childrenLabel = new ChildrenLabel();
        this.cellRendererPane.add(this.childrenLabel);
        this.add(this.cellRendererPane);
        this.addFocusListener(this);
        this.eventHandler = new RightTreeEventHandler(this);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "press-moveSelectionDown");
        actionMap.put("press-moveSelectionDown", new MoveSelectionDown());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.actionEscape = this.getActionForKeyStroke(KeyStroke.getKeyStroke(27, 0));
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "press-moveSelectionUp");
        actionMap.put("press-moveSelectionUp", new MoveSelectionUp());
        inputMap.put(KeyStroke.getKeyStroke(40, 128), "press-moveSelectionDown+Control");
        actionMap.put("press-moveSelectionDown+Control", new MoveSelectionDown());
        inputMap.put(KeyStroke.getKeyStroke(38, 128), "press-moveSelectionUp+Control");
        actionMap.put("press-moveSelectionUp+Control", new MoveSelectionUp());
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "press-left-expand");
        actionMap.put("press-left-expand", new PressLeftExpand());
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "press-right-collapse");
        actionMap.put("press-right-collapse", new PressRightCollapse());
        inputMap.put(KeyStroke.getKeyStroke(37, 128), "press-left-expandGraph");
        actionMap.put("press-left-expandGraph", new PressLeftExpandGraph());
        inputMap.put(KeyStroke.getKeyStroke(39, 128), "press-right-collapseGraph");
        actionMap.put("press-right-collapseGraph", new PressRightCollapseGraph());
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "auto-scroll-down");
        actionMap.put("auto-scroll-down", new AutoScrollDown());
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "auto-scroll-up");
        actionMap.put("auto-scroll-up", new AutoScrollUp());
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "auto-scroll-left");
        actionMap.put("auto-scroll-left", new AutoScrollLeft());
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "auto-scroll-right");
        actionMap.put("auto-scroll-right", new AutoScrollRight());
        inputMap.put(KeyStroke.getKeyStroke(121, 64), "show-popupMenu");
        inputMap.put(KeyStroke.getKeyStroke(525, 0), "show-popupMenu");
        actionMap.put("show-popupMenu", new ShowPopupMenuAction());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RightTree.class, (String)"ACSN_RightTree"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RightTree.class, (String)"ACSD_RightTree"));
    }

    public void registrAction(MapperKeyboardAction mapperKeyboardAction) {
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        String string = mapperKeyboardAction.getActionKey();
        actionMap.put(string, mapperKeyboardAction);
        KeyStroke[] keyStrokeArray = mapperKeyboardAction.getShortcuts();
        if (keyStrokeArray != null) {
            for (KeyStroke keyStroke : keyStrokeArray) {
                inputMap.put(keyStroke, string);
            }
        }
    }

    public ActionListener getActionEscape() {
        return this.actionEscape;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        MapperModel mapperModel = this.getMapper().getModel();
        MapperContext mapperContext = this.getMapper().getContext();
        if (mapperModel == null || mapperContext == null) {
            return null;
        }
        MapperNode mapperNode = this.getNodeAt(mouseEvent.getY());
        if (mapperNode == null) {
            return null;
        }
        TreePath treePath = mapperNode.getTreePath();
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (object == null) {
            return null;
        }
        return mapperContext.getRightToolTipText(mapperModel, object);
    }

    JLabel getChildrenLabel() {
        return this.childrenLabel;
    }

    Component getCellRendererComponent(MapperNode mapperNode) {
        Mapper mapper = this.getMapper();
        RightTreeCellRenderer rightTreeCellRenderer = mapper.getRightTreeCellRenderer();
        Component component = rightTreeCellRenderer.getTreeCellRendererComponent(mapper, mapperNode.getValue(), false, mapperNode.isExpanded(), mapperNode.isLeaf(), 0, false);
        this.cellRendererPane.add(component);
        return component;
    }

    CellRendererPane getCellRendererPane() {
        return this.cellRendererPane;
    }

    RightTreeCellRenderer getTreeCellRenderer() {
        return this.treeCellRenderer;
    }

    JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    JComponent getView() {
        return this.scrollPaneWrapper;
    }

    MapperContext getContext() {
        return this.getMapper().getContext();
    }

    public Dimension getPreferredSize() {
        Mapper mapper = this.getMapper();
        Dimension dimension = mapper.getPreferredTreeSize();
        if (dimension != null) {
            dimension.width += mapper.getStepSize() * 3 / 2 + 1;
            return dimension;
        }
        return new Dimension(10, 10);
    }

    public void doLayout() {
        Mapper mapper = this.getMapper();
        mapper.validateNodes();
        this.cellRendererPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.clearCellRendererPane();
    }

    public void print(Graphics graphics) {
        this.printMode = true;
        super.print(graphics);
        this.printMode = false;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Mapper mapper = this.getMapper();
        mapper.resetRepaintSceduled();
        MapperNode mapperNode = this.getRoot();
        int n = mapper.getStepSize();
        if (mapperNode != null) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            int n2 = this.getWidth();
            this.paintNode(mapperNode, graphics2D, 0, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(MapperStyle.LINK_COLOR_SELECTED_NODE);
            this.paintNodeEdges(mapperNode, graphics2D, 0, n2, n);
            graphics2D.dispose();
        }
        this.clearCellRendererPane();
        this.getLinkTool().paintRightTree(this, graphics);
    }

    private void clearCellRendererPane() {
        for (int i = this.cellRendererPane.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.cellRendererPane.getComponent(i);
            if (component == this.childrenLabel) continue;
            this.cellRendererPane.remove(i);
        }
    }

    private void paintNode(MapperNode mapperNode, Graphics2D graphics2D, int n, int n2) {
        Object object;
        Mapper mapper = this.getMapper();
        int n3 = mapperNode.getIndent();
        int n4 = mapperNode.getHeight();
        int n5 = mapperNode.getContentHeight();
        int n6 = n + mapperNode.getContentCenterY();
        int n7 = mapperNode.getLabelWidth();
        int n8 = mapperNode.getLabelHeight();
        int n9 = n2 - n3 - n7;
        int n10 = n + (n5 - 1 - n8) / 2;
        boolean bl = mapperNode.isLeaf();
        boolean bl2 = mapperNode.isExpanded();
        if (mapperNode.isSelected() && !this.printMode) {
            Object object2 = object = this.hasFocus() ? Mapper.SELECTED_BACKGROUND_IN_FOCUS : Mapper.SELECTED_BACKGROUND_NOT_IN_FOCUS;
            ((VerticalGradient)object).paintGradient(this, graphics2D, 0, n, n2, (bl ? n4 : (bl2 ? n5 : n4)) - 1);
        }
        if (bl) {
            if (mapperNode.mustDrawLine()) {
                int n11 = n + n4 - 1;
                graphics2D.setColor(Mapper.ROW_SEPARATOR_COLOR);
                graphics2D.drawLine(0, n11, n2 - 1, n11);
            }
        } else if (bl2) {
            int n12;
            if (mapperNode.mustDrawLine()) {
                int n13 = n + n5 - 1;
                graphics2D.setColor(Mapper.ROW_SEPARATOR_COLOR);
                graphics2D.drawLine(0, n13, n2 - 1, n13);
            }
            if ((n12 = mapperNode.getChildCount()) > 0) {
                MapperNode mapperNode2;
                int n14;
                int n15;
                for (n15 = 0; n15 < n12; ++n15) {
                    MapperNode mapperNode3 = mapperNode.getChild(n15);
                    this.paintNode(mapperNode3, graphics2D, n + mapperNode3.getY(), n2);
                }
                n15 = n2 - n3 - mapper.getRightIndent();
                int n16 = n15 - mapper.getLeftIndent();
                if (mapperNode.getParent() != null) {
                    n14 = n + (n5 - 1 - n8) / 2 + n8;
                } else {
                    mapperNode2 = mapperNode.getChild(0);
                    n14 = n + mapperNode2.getContentCenterY() + mapperNode2.getY();
                }
                mapperNode2 = mapperNode.getChild(n12 - 1);
                int n17 = n + mapperNode2.getContentCenterY() + mapperNode2.getY();
                graphics2D.setColor(mapper.getTreeLineColor());
                graphics2D.drawLine(n15, n14, n15, n17);
                for (int i = 0; i < n12; ++i) {
                    MapperNode mapperNode4 = mapperNode.getChild(i);
                    int n18 = n + mapperNode4.getY() + mapperNode4.getContentCenterY();
                    graphics2D.drawLine(n16, n18, n15, n18);
                    if (mapperNode4.isLeaf()) continue;
                    Icon icon = mapperNode4.isCollapsed() ? mapper.getCollapsedIcon() : mapper.getExpandedIcon();
                    icon.paintIcon(mapper.getRightTree(), graphics2D, n15 - icon.getIconWidth() / 2, n18 - icon.getIconHeight() / 2);
                }
            }
        } else {
            int n19 = n + n5 - 1;
            int n20 = n + n4 - 1;
            if (n19 != n20) {
                Object object3;
                if (mapperNode.mustDrawDottedLine()) {
                    object3 = graphics2D.getStroke();
                    graphics2D.setColor(Mapper.ROW_SEPARATOR_COLOR);
                    graphics2D.setStroke(Mapper.DASHED_ROW_SEPARATOR_STROKE);
                    graphics2D.drawLine(0, n19, n2 - 1, n19);
                    graphics2D.setStroke((Stroke)object3);
                }
                object3 = this.getChildrenLabel();
                Dimension dimension = ((JComponent)object3).getPreferredSize();
                ((Component)object3).setBounds(0, 0, dimension.width, dimension.height);
                int n21 = n2 - n3 - dimension.width - mapper.getTotalIndent();
                int n22 = n + n5 + (n4 - n5 - 1 - dimension.height) / 2;
                int n23 = n + (n5 - 1 - n8) / 2 + n8;
                int n24 = n + n5 + (n4 - n5 - 1) / 2;
                int n25 = n2 - n3 - mapper.getRightIndent();
                int n26 = n2 - n3 - mapper.getTotalIndent();
                graphics2D.setColor(mapper.getTreeLineColor());
                graphics2D.drawLine(n25, n23, n25, n24);
                graphics2D.drawLine(n26, n24, n25, n24);
                graphics2D.translate(n21, n22);
                ((JComponent)object3).paint(graphics2D);
                graphics2D.translate(-n21, -n22);
            }
            if (mapperNode.mustDrawLine()) {
                graphics2D.setColor(Mapper.ROW_SEPARATOR_COLOR);
                graphics2D.drawLine(0, n20, n2 - 1, n20);
            }
        }
        object = this.getCellRendererComponent(mapperNode);
        ((Component)object).setBounds(0, 0, n7, n8);
        graphics2D.translate(n9, n10);
        ((Component)object).paint(graphics2D);
        graphics2D.translate(-n9, -n10);
    }

    private void paintNodeEdges(MapperNode mapperNode, Graphics2D graphics2D, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        Mapper mapper = this.getMapper();
        int n7 = mapperNode.getContentHeight();
        int n8 = mapperNode.getHeight();
        boolean bl = mapperNode.isLeaf();
        boolean bl2 = mapperNode.isExpanded();
        Graph graph = mapperNode.getGraph();
        boolean bl3 = graph != null && graph.hasOutgoingLinks();
        Link link = null;
        for (n6 = graph.getLinkCount() - 1; n6 >= 0; --n6) {
            if (!(graph.getLink(n6).getTarget() instanceof Graph)) continue;
            link = graph.getLink(n6);
        }
        if (link != null) {
            bl3 = this.getCanvas().getRendererContext().paintLink(mapperNode.getTreePath(), link);
        }
        n6 = 0;
        if (!bl) {
            if (bl2) {
                n5 = mapperNode.getChildCount();
                for (n4 = 0; n4 < n5; ++n4) {
                    MapperNode mapperNode2 = mapperNode.getChild(n4);
                    this.paintNodeEdges(mapperNode2, graphics2D, n + mapperNode2.getY(), n2, n3);
                }
            } else {
                Set<Graph> set = mapperNode.getChildGraphs();
                if (set != null) {
                    for (Graph graph2 : set) {
                        if (!graph2.hasOutgoingLinks()) continue;
                        n6 = 1;
                        break;
                    }
                }
            }
        }
        if (n7 < n8) {
            if (bl3) {
                n5 = n + (n7 - 1) / 2;
                n4 = n2 - mapperNode.getIndent() - mapperNode.getLabelWidth();
                this.paintEdge(graphics2D, n5, n4, n3, false);
            }
            if (n6 != 0) {
                n5 = n + n7 + (n8 - n7 - 1) / 2;
                n4 = n2 - mapperNode.getIndent() - this.childrenLabel.getPreferredSize().width - mapper.getTotalIndent();
                this.paintEdge(graphics2D, n5, n4, n3, true);
            }
        } else if (bl3 || n6 != 0) {
            n5 = n + (n7 - 1) / 2;
            n4 = n2 - mapperNode.getIndent() - mapperNode.getLabelWidth() - 1;
            this.paintEdge(graphics2D, n5, n4, n3, n6 != 0 && !bl3);
        }
    }

    private void paintEdge(Graphics2D graphics2D, int n, int n2, int n3, boolean bl) {
        int n4 = n2 - n3 / 2;
        if (bl) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(Mapper.DASHED_STROKE);
            graphics2D.drawLine(n4, n, 0, n);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.drawLine(0, n, n4, n);
        }
        Link.paintTargetDecoration(graphics2D, new Point(n2, n), null, n3);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        return new Insets(rectangle.y + 16, rectangle.x + 16, this.getHeight() - rectangle.y - rectangle.height + 16, this.getWidth() - rectangle.x - rectangle.width + 16);
    }

    public void autoscroll(Point point) {
        if (this.scrollPane.getViewport() == null) {
            return;
        }
        Insets insets = this.getAutoscrollInsets();
        Rectangle rectangle = new Rectangle(point.x, point.y, 1, 1);
        if (point.y > this.getHeight() - insets.bottom) {
            rectangle.y = this.getHeight() - insets.bottom + 16 + this.scrollPane.getVerticalScrollBar().getUnitIncrement();
        }
        if (point.y < insets.top) {
            rectangle.y = insets.top - 16 - this.scrollPane.getVerticalScrollBar().getUnitIncrement();
        }
        if (point.x > this.getWidth() - insets.right) {
            rectangle.x = this.getWidth() - insets.right + 16 + this.scrollPane.getHorizontalScrollBar().getUnitIncrement();
        }
        if (point.x < insets.left) {
            rectangle.x = insets.left - 16 - this.scrollPane.getHorizontalScrollBar().getUnitIncrement();
        }
        this.scrollRectToVisible(rectangle);
    }

    private class ShowPopupMenuAction
    extends AbstractAction {
        private ShowPopupMenuAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RightTree rightTree = RightTree.this;
            MapperContext mapperContext = rightTree.getContext();
            MapperModel mapperModel = rightTree.getMapper().getModel();
            if (mapperContext == null || mapperModel == null) {
                return;
            }
            TreePath treePath = rightTree.getSelectionModel().getSelectedPath();
            if (treePath == null) {
                return;
            }
            MapperNode mapperNode = rightTree.getMapper().getNode(treePath, true);
            if (mapperNode == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object == null) {
                return;
            }
            JPopupMenu jPopupMenu = mapperContext.getRightPopupMenu(mapperModel, object);
            if (jPopupMenu != null) {
                jPopupMenu.show(rightTree, 0, mapperNode.yToView(mapperNode.getContentCenterY() - mapperNode.getContentHeight() / 2));
            }
        }
    }

    private static class RightViewportLayout
    extends ViewportLayout {
        private RightViewportLayout() {
        }

        public void layoutContainer(Container container) {
            JViewport jViewport = (JViewport)container;
            Dimension dimension = jViewport.getViewSize();
            Dimension dimension2 = jViewport.getExtentSize();
            Point point = jViewport.getViewPosition();
            int n = Math.max(0, dimension.width - (point.x + dimension2.width));
            super.layoutContainer(container);
            dimension = jViewport.getViewSize();
            dimension2 = jViewport.getExtentSize();
            point = jViewport.getViewPosition();
            point.x = Math.max(0, dimension.width - dimension2.width - n);
            jViewport.setViewPosition(point);
        }
    }

    private static class RightScrollPaneLayout
    extends ScrollPaneLayout {
        private RightScrollPaneLayout() {
        }

        public void layoutContainer(Container container) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            Dimension dimension = jViewport.getViewSize();
            Dimension dimension2 = jViewport.getExtentSize();
            Point point = jViewport.getViewPosition();
            int n = Math.max(0, dimension.width - (point.x + dimension2.width));
            super.layoutContainer(container);
            dimension = jViewport.getViewSize();
            dimension2 = jViewport.getExtentSize();
            point = jViewport.getViewPosition();
            point.x = Math.max(0, dimension.width - dimension2.width - n);
            jViewport.setViewPosition(point);
        }
    }

    private class AutoScrollRight
    extends AbstractAction {
        private AutoScrollRight() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RightTree.this.scrollPane.getViewport() == null) {
                return;
            }
            Insets insets = RightTree.this.getAutoscrollInsets();
            int n = RightTree.this.getScrollPane().getViewport().getViewRect().y;
            Rectangle rectangle = new Rectangle(0, n, 1, 1);
            rectangle.x = RightTree.this.getWidth() - insets.right + 16 + RightTree.this.scrollPane.getHorizontalScrollBar().getUnitIncrement();
            RightTree.this.scrollRectToVisible(rectangle);
        }
    }

    private class AutoScrollLeft
    extends AbstractAction {
        private AutoScrollLeft() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RightTree.this.scrollPane.getViewport() == null) {
                return;
            }
            Insets insets = RightTree.this.getAutoscrollInsets();
            int n = RightTree.this.getScrollPane().getViewport().getViewRect().y;
            Rectangle rectangle = new Rectangle(0, n, 1, 1);
            rectangle.x = insets.left - 16 - RightTree.this.scrollPane.getHorizontalScrollBar().getUnitIncrement();
            RightTree.this.scrollRectToVisible(rectangle);
        }
    }

    private class AutoScrollUp
    extends AbstractAction {
        private AutoScrollUp() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RightTree.this.scrollPane.getViewport() == null) {
                return;
            }
            Insets insets = RightTree.this.getAutoscrollInsets();
            int n = RightTree.this.getScrollPane().getViewport().getViewRect().x;
            Rectangle rectangle = new Rectangle(n, 0, 1, 1);
            rectangle.y = insets.top - 16 - RightTree.this.scrollPane.getVerticalScrollBar().getUnitIncrement();
            RightTree.this.scrollRectToVisible(rectangle);
        }
    }

    private class AutoScrollDown
    extends AbstractAction {
        private AutoScrollDown() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (RightTree.this.scrollPane.getViewport() == null) {
                return;
            }
            Insets insets = RightTree.this.getAutoscrollInsets();
            int n = RightTree.this.getScrollPane().getViewport().getViewRect().x;
            Rectangle rectangle = new Rectangle(n, 0, 1, 1);
            rectangle.y = RightTree.this.getHeight() - insets.bottom + 16 + RightTree.this.scrollPane.getVerticalScrollBar().getUnitIncrement();
            RightTree.this.scrollRectToVisible(rectangle);
        }
    }

    private class PressRightCollapseGraph
    extends AbstractAction {
        private PressRightCollapseGraph() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MapperNode mapperNode;
            Graph graph;
            Mapper mapper = RightTree.this.getMapper();
            TreePath treePath = RightTree.this.getSelectionModel().getSelectedPath();
            if (treePath != null && (graph = (mapperNode = mapper.getNode(treePath, true)).getGraph()) != null && !graph.isEmptyOrOneLink() && mapperNode.isGraphExpanded()) {
                mapper.setExpandedGraphState(treePath, false);
                RightTree.this.getLinkTool().done();
            }
        }
    }

    private class PressLeftExpandGraph
    extends AbstractAction {
        private PressLeftExpandGraph() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = RightTree.this.getSelectionModel().getSelectedPath();
            if (treePath == null) {
                return;
            }
            Mapper mapper = RightTree.this.getMapper();
            MapperNode mapperNode = mapper.getNode(treePath, true);
            if (mapperNode.getGraph() == null) {
                return;
            }
            if (mapperNode.isGraphCollapsed()) {
                mapper.setExpandedGraphState(mapperNode.getTreePath(), true);
            } else {
                RightTree.this.getCanvas().requestFocusInWindow();
                Graph graph = mapperNode.getGraph();
                if (graph.hasOutgoingLinks()) {
                    List<Link> list = graph.getLinks();
                    for (Link link : list) {
                        if (!(link.getTarget() instanceof Graph)) continue;
                        mapper.getSelectionModel().setSelected(treePath, link);
                        break;
                    }
                    return;
                }
                List<Vertex> list = mapperNode.getGraph().getVerteces();
                if (list == null || list.size() <= 0) {
                    return;
                }
                Vertex vertex = mapperNode.getGraph().getPrevVertex(null);
                mapper.getSelectionModel().setSelected(treePath, vertex);
            }
        }
    }

    private class PressRightCollapse
    extends AbstractAction {
        private PressRightCollapse() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Mapper mapper = RightTree.this.getMapper();
            SelectionModel selectionModel = RightTree.this.getSelectionModel();
            TreePath treePath = selectionModel.getSelectedPath();
            MapperNode mapperNode = mapper.getNode(treePath, true);
            if (treePath != null && treePath != mapper.getRoot().getTreePath()) {
                if (mapperNode.isExpanded() && !mapperNode.isLeaf()) {
                    mapper.collapseNode(mapperNode);
                } else if (mapperNode.getParent() != mapper.getRoot()) {
                    mapper.setSelectedNode(mapperNode.getParent());
                }
            } else if (mapper.getRoot() != null && mapper.getRoot().getChildCount() > 0) {
                mapper.setSelectedNode(mapper.getRoot().getChild(0));
            }
        }
    }

    private class PressLeftExpand
    extends AbstractAction {
        private PressLeftExpand() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Mapper mapper = RightTree.this.getMapper();
            SelectionModel selectionModel = RightTree.this.getSelectionModel();
            TreePath treePath = selectionModel.getSelectedPath();
            if (treePath != null) {
                MapperNode mapperNode = mapper.getNode(treePath, true);
                if (mapperNode.isLeaf()) {
                    if (mapperNode.getNextVisibleNode() != null) {
                        mapper.setSelectedNode(mapperNode.getNextVisibleNode());
                    }
                } else if (mapperNode.isCollapsed()) {
                    mapper.expandNode(mapperNode);
                } else if (mapperNode.getChildCount() > 0) {
                    mapper.setSelectedNode(mapperNode.getChild(0));
                }
            } else if (mapper.getRoot() != null && mapper.getRoot().getChildCount() > 0) {
                mapper.setSelectedNode(mapper.getRoot().getChild(0));
            }
        }
    }

    private class MoveSelectionDown
    extends AbstractAction {
        private MoveSelectionDown() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Mapper mapper = RightTree.this.getMapper();
            SelectionModel selectionModel = RightTree.this.getSelectionModel();
            TreePath treePath = selectionModel.getSelectedPath();
            if (treePath != null) {
                MapperNode mapperNode = mapper.getNode(treePath, true);
                MapperNode mapperNode2 = mapperNode.getNextVisibleNode();
                if (mapperNode2 != null) {
                    selectionModel.setSelected(mapperNode2.getTreePath());
                }
            } else if (mapper.getRoot() != null && mapper.getRoot().getChildCount() > 0) {
                mapper.setSelectedNode(mapper.getRoot().getChild(0));
            }
        }
    }

    private class MoveSelectionUp
    extends AbstractAction {
        private MoveSelectionUp() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Mapper mapper = RightTree.this.getMapper();
            SelectionModel selectionModel = RightTree.this.getSelectionModel();
            TreePath treePath = selectionModel.getSelectedPath();
            if (treePath != null && treePath != mapper.getRoot().getTreePath()) {
                MapperNode mapperNode = mapper.getNode(treePath, true);
                MapperNode mapperNode2 = mapperNode.getPrevVisibleNode();
                if (mapperNode2 != null && mapperNode2 != mapper.getRoot()) {
                    selectionModel.setSelected(mapperNode2.getTreePath());
                }
            } else if (mapper.getRoot() != null && mapper.getRoot().getChildCount() > 0) {
                mapper.setSelectedNode(mapper.getRoot().getChild(0));
            }
        }
    }

    private class ChildrenLabelBorder
    implements Border {
        private ChildrenLabelBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(RightTree.this.getMapper().getTreeLineColor());
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class ChildrenLabel
    extends JLabel {
        public ChildrenLabel() {
            super("  ...  ");
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setBorder(new ChildrenLabelBorder());
        }
    }

    private class BottomLeftCorner
    extends JPanel {
        private BottomLeftCorner() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(1, 1);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(Color.GRAY);
            graphics.drawLine(0, 0, n - 1, 0);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
        }
    }

    private class RowHeader
    extends JPanel
    implements MouseListener {
        public RowHeader() {
            this.setOpaque(true);
            this.addMouseListener(this);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = RightTree.this.getMapper().getPreferredTreeSize();
            if (dimension != null) {
                dimension.width = 16;
                return dimension;
            }
            return new Dimension(16, 10);
        }

        public void doLayout() {
            RightTree.this.getMapper().validateNodes();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            RightTree.this.getMapper().resetRepaintSceduled();
            int n = this.getWidth();
            int n2 = this.getHeight();
            MapperNode mapperNode = RightTree.this.getRoot();
            if (mapperNode != null) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                this.paintNode(mapperNode, graphics2D, 0, n - 1);
                graphics2D.dispose();
            }
            graphics.setColor(Color.GRAY);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
        }

        private void paintNode(MapperNode mapperNode, Graphics2D graphics2D, int n, int n2) {
            Graph graph;
            Object object;
            int n3;
            int n4;
            int n5 = mapperNode.getContentHeight();
            int n6 = mapperNode.getHeight();
            boolean bl = mapperNode.isLeaf();
            boolean bl2 = mapperNode.isExpanded();
            graphics2D.setColor(Mapper.RIGHT_TREE_HEADER_COLOR);
            if (bl) {
                if (mapperNode.mustDrawLine()) {
                    n4 = n + n6 - 1;
                    graphics2D.drawLine(0, n4, n2 - 1, n4);
                }
            } else if (bl2) {
                if (mapperNode.mustDrawLine()) {
                    n4 = n + n5 - 1;
                    graphics2D.drawLine(0, n4, n2 - 1, n4);
                }
                n4 = mapperNode.getChildCount();
                for (n3 = 0; n3 < n4; ++n3) {
                    object = mapperNode.getChild(n3);
                    this.paintNode((MapperNode)object, graphics2D, n + ((MapperNode)object).getY(), n2);
                }
            } else if (mapperNode.mustDrawLine()) {
                n4 = n + n5 - 1;
                n3 = n + n6 - 1;
                if (mapperNode.mustDrawDottedLine()) {
                    object = graphics2D.getStroke();
                    graphics2D.setStroke(Mapper.DASHED_ROW_SEPARATOR_STROKE);
                    graphics2D.drawLine(0, n4, n2, n4);
                    graphics2D.setStroke((Stroke)object);
                }
                graphics2D.drawLine(0, n3, n2 - 1, n3);
            }
            if ((graph = mapperNode.getGraph()) != null && !graph.isEmptyOrOneLink()) {
                n3 = n + mapperNode.getContentCenterY();
                int n7 = n2 / 2;
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(n7 - 3, n3 - 3, 7, 7);
                graphics2D.setColor(Mapper.RIGHT_TREE_HEADER_COLOR);
                graphics2D.drawRect(n7 - 4, n3 - 4, 8, 8);
                graphics2D.drawLine(n7 - 2, n3, n7 + 2, n3);
                if (mapperNode.isGraphCollapsed()) {
                    graphics2D.drawLine(n7, n3 - 2, n7, n3 + 2);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!RightTree.this.hasFocus()) {
                RightTree.this.requestFocusInWindow();
            }
            if (mouseEvent.isPopupTrigger()) {
                return;
            }
            int n = mouseEvent.getY();
            int n2 = mouseEvent.getX();
            MapperNode mapperNode = RightTree.this.getNodeAt(n);
            if (mapperNode != null) {
                Graph graph;
                n = mapperNode.yToNode(n);
                int n3 = mapperNode.getContentCenterY();
                boolean bl = true;
                if (Math.abs(n3 - n) <= 8 && (graph = mapperNode.getGraph()) != null && !graph.isEmptyOrOneLink()) {
                    RightTree.this.getMapper().setExpandedGraphState(mapperNode.getTreePath(), !mapperNode.isGraphExpanded());
                    RightTree.this.getLinkTool().done();
                    bl = false;
                }
                if (bl) {
                    RightTree.this.getMapper().setSelectedNode(mapperNode);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

