/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import javax.swing.JLabel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public class DefaultCanvasRendererPrintContext
implements CanvasRendererContext {
    private Mapper mapper;
    private Canvas canvas;
    private LeftTree leftTree;
    private RightTree rightTree;
    private int step;
    private int canvasVisibleMinX;
    private int canvasVisibleMaxX;
    private int graphX;

    public DefaultCanvasRendererPrintContext(Mapper mapper) {
        this.mapper = mapper;
        this.canvas = mapper.getCanvas();
        this.leftTree = mapper.getLeftTree();
        this.rightTree = mapper.getRightTree();
        this.step = this.canvas.getStep();
        this.graphX = this.canvas.toCanvas(0);
        this.canvasVisibleMinX = 0;
        this.canvasVisibleMaxX = this.canvas.getWidth();
    }

    public int getStep() {
        return this.step;
    }

    public JLabel getTextRenderer() {
        return this.canvas.getTextRenderer();
    }

    public boolean isSelected(TreePath treePath) {
        return false;
    }

    public boolean isSelected(TreePath treePath, GraphItem graphItem) {
        return false;
    }

    public boolean paintVertex(TreePath treePath, Vertex vertex) {
        return true;
    }

    public boolean paintLink(TreePath treePath, Link link) {
        return true;
    }

    public boolean paintVertexItemPin(TreePath treePath, VertexItem vertexItem) {
        return vertexItem.getIngoingLink() == null;
    }

    public boolean paintVertexPin(TreePath treePath, Vertex vertex) {
        return vertex.getOutgoingLink() == null;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public LeftTree getLeftTree() {
        return this.leftTree;
    }

    public RightTree getRightTree() {
        return this.rightTree;
    }

    public int getCanvasVisibleMinX() {
        return this.canvasVisibleMinX;
    }

    public int getCanvasVisibleMaxX() {
        return this.canvasVisibleMaxX;
    }

    public int getGraphX() {
        return this.graphX;
    }

    public int getCanvasVisibleCenterX() {
        return (this.canvasVisibleMinX + this.canvasVisibleMaxX) / 2;
    }
}

