/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.CanvasSearchResult;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.MapperPropertyAccess;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.dnd.DnDConstants;
import org.netbeans.modules.soa.mappercore.dnd.DnDHandler;
import org.netbeans.modules.soa.mappercore.dnd.DnDSupport;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.utils.Utils;

public abstract class AbstractMapperEventHandler
extends MapperPropertyAccess
implements MouseMotionListener,
MouseListener,
DnDHandler,
DnDConstants {
    private JComponent component;
    private DnDSupport dndSupport;
    private Timer timer;
    private Point oldPoint;
    private static final int DELAY_TIME_FOR_EXPAND = 600;

    public AbstractMapperEventHandler(Mapper mapper, JComponent jComponent) {
        super(mapper);
        this.component = jComponent;
        this.dndSupport = new DnDSupport(jComponent, this);
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public abstract void mousePressed(MouseEvent var1);

    public abstract void mouseReleased(MouseEvent var1);

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public abstract void mouseDragged(MouseEvent var1);

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void drag(JComponent jComponent, DropTargetDragEvent dropTargetDragEvent) {
        this.autoExpand(jComponent, dropTargetDragEvent);
        this.setSelected(jComponent, dropTargetDragEvent);
        this.setMoveOnTop(jComponent, dropTargetDragEvent);
        boolean bl = false;
        if (!bl) {
            bl = this.getLinkTool().drag(jComponent, dropTargetDragEvent);
        }
        if (!bl) {
            bl = this.getMoveTool().drag(jComponent, dropTargetDragEvent);
        }
        if (!bl) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void drop(JComponent jComponent, DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        if (!bl) {
            bl = this.getLinkTool().drop(jComponent, dropTargetDropEvent);
        }
        if (!bl) {
            bl = this.getMoveTool().drop(jComponent, dropTargetDropEvent);
        }
        this.getMapper().setSelectedDndPath(null);
        this.removeTimer();
    }

    public void dragDone(JComponent jComponent, DragSourceDropEvent dragSourceDropEvent) {
        this.getLinkTool().done();
        this.getMoveTool().dragDone();
        this.getMapper().setSelectedDndPath(null);
        this.removeTimer();
    }

    protected void startDrag(MouseEvent mouseEvent, Transferable transferable, int n) {
        this.dndSupport.startDrag(mouseEvent, transferable, n);
    }

    public void dragExit(JComponent jComponent) {
        this.removeTimer();
        Canvas canvas = this.getCanvas();
        RightTree rightTree = this.getRightTree();
        if (jComponent == canvas || jComponent == rightTree) {
            canvas.getMapper().setSelectedDndPath(null);
            canvas.getMapper().repaint();
        }
    }

    private void autoExpand(JComponent jComponent, DropTargetDragEvent dropTargetDragEvent) {
        Object object;
        Serializable serializable;
        Object object2;
        TreePath treePath;
        LeftTree leftTree = this.getLeftTree();
        RightTree rightTree = this.getRightTree();
        Canvas canvas = this.getCanvas();
        Point point = dropTargetDragEvent.getLocation();
        if (jComponent == leftTree) {
            treePath = leftTree.getPathForLocation(point.x, point.y);
            if (!Utils.equal(point, this.oldPoint)) {
                this.removeTimer();
            }
            if (!(this.timer != null && this.timer.isRunning() || treePath == null || leftTree.isExpanded(treePath))) {
                object2 = treePath;
                serializable = leftTree;
                this.removeTimer();
                this.timer = new Timer(600, new ActionListener((JTree)serializable, (TreePath)object2){
                    final /* synthetic */ JTree val$fTree;
                    final /* synthetic */ TreePath val$fTreePath;
                    {
                        this.val$fTree = jTree;
                        this.val$fTreePath = treePath;
                    }

                    public final void actionPerformed(ActionEvent actionEvent) {
                        this.val$fTree.expandPath(this.val$fTreePath);
                    }
                });
                this.timer.setRepeats(false);
                this.timer.start();
            }
            this.oldPoint = point;
        }
        if (jComponent == rightTree) {
            treePath = rightTree.getTreePath(point.y);
            object2 = rightTree.getNodeAt(point.y);
            if (!Utils.equal(point, this.oldPoint)) {
                this.removeTimer();
            }
            if (!(this.timer != null && this.timer.isRunning() || treePath == null || ((MapperNode)object2).isLeaf() || ((MapperNode)object2).isExpanded())) {
                serializable = treePath;
                object = object2;
                this.removeTimer();
                this.timer = new Timer(600, new ActionListener((TreePath)serializable){
                    final /* synthetic */ TreePath val$fTreePath;
                    {
                        this.val$fTreePath = treePath;
                    }

                    public final void actionPerformed(ActionEvent actionEvent) {
                        AbstractMapperEventHandler.this.getMapper().setExpandedState(this.val$fTreePath, true);
                    }
                });
                this.timer.setRepeats(false);
                this.timer.start();
            }
            this.oldPoint = point;
        }
        if (jComponent == canvas) {
            treePath = rightTree.getTreePath(point.y);
            object2 = rightTree.getNodeAt(point.y);
            if (!Utils.equal(point, this.oldPoint)) {
                this.removeTimer();
            }
            if (!(this.timer != null && this.timer.isRunning() || treePath == null || ((MapperNode)object2).isGraphExpanded())) {
                serializable = treePath;
                object = rightTree.getMapper();
                this.removeTimer();
                this.timer = new Timer(600, new ActionListener((Mapper)object, (TreePath)serializable){
                    final /* synthetic */ Mapper val$maper;
                    final /* synthetic */ TreePath val$fTreePath;
                    {
                        this.val$maper = mapper;
                        this.val$fTreePath = treePath;
                    }

                    public final void actionPerformed(ActionEvent actionEvent) {
                        this.val$maper.setExpandedGraphState(this.val$fTreePath, true);
                    }
                });
                this.timer.setRepeats(false);
                this.timer.start();
            }
            this.oldPoint = point;
        }
    }

    private void removeTimer() {
        if (this.timer != null) {
            ActionListener[] actionListenerArray = (ActionListener[])this.timer.getListeners(ActionListener.class);
            for (int i = 0; i < actionListenerArray.length; ++i) {
                this.timer.removeActionListener(actionListenerArray[i]);
            }
            this.timer.stop();
            this.timer = null;
        }
    }

    private void setMoveOnTop(JComponent jComponent, DropTargetDragEvent dropTargetDragEvent) {
        Canvas canvas = this.getCanvas();
        if (jComponent == canvas) {
            Point point = dropTargetDragEvent.getLocation();
            CanvasSearchResult canvasSearchResult = this.getCanvas().find(point.x, point.y);
            if (canvasSearchResult == null) {
                return;
            }
            GraphItem graphItem = canvasSearchResult.getGraphItem();
            if (graphItem == null) {
                return;
            }
            graphItem.moveOnTop();
        }
    }

    private void setSelected(JComponent jComponent, DropTargetDragEvent dropTargetDragEvent) {
        Canvas canvas = this.getCanvas();
        RightTree rightTree = this.getRightTree();
        if (jComponent == canvas || jComponent == rightTree) {
            Point point = dropTargetDragEvent.getLocation();
            TreePath treePath = rightTree.getTreePath(point.y);
            canvas.getMapper().setSelectedDndPath(treePath);
            canvas.getMapper().repaint();
        }
    }
}

