/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;

public class DiffLivenessResultsPanel
extends SnapshotLivenessResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM = messages.getString("SnapshotLivenessResultsPanel_GoSourcePopupItem");
    private JMenuItem popupShowSource;
    private JPopupMenu popup;
    private LivenessMemoryResultsDiff diff;

    public DiffLivenessResultsPanel(LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot, MemoryResUserActionsHandler memoryResUserActionsHandler, int n) {
        super(livenessMemoryResultsSnapshot, memoryResUserActionsHandler, n);
        this.diff = (LivenessMemoryResultsDiff)livenessMemoryResultsSnapshot;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.popupShowSource) {
            this.performDefaultAction(-1);
        }
    }

    protected CustomBarCellRenderer getBarCellRenderer() {
        return new DiffBarCellRenderer(this.diff.getMinTrackedLiveObjectsSizeDiff(), this.diff.getMaxTrackedLiveObjectsSizeDiff());
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            Font font = this.popup.getFont().deriveFont(1);
            this.popupShowSource = new JMenuItem();
            this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM);
            this.popupShowSource.setFont(font);
            this.popup.add(this.popupShowSource);
            this.popupShowSource.addActionListener(this);
        }
        return this.popup;
    }

    protected Object computeValueAt(int n, int n2) {
        int n3 = (Integer)this.filteredToFullIndexes.get(n);
        switch (n2) {
            case 0: {
                return this.sortedClassNames[n3];
            }
            case 1: {
                return new Long(this.trackedLiveObjectsSize[n3]);
            }
            case 2: {
                return (this.trackedLiveObjectsSize[n3] > 0L ? "+" : "") + this.intFormat.format(this.trackedLiveObjectsSize[n3]) + " B";
            }
            case 3: {
                return (this.nTrackedLiveObjects[n3] > 0 ? "+" : "") + this.intFormat.format(this.nTrackedLiveObjects[n3]);
            }
            case 4: {
                return (this.nTrackedAllocObjects[n3] > 0L ? "+" : "") + this.intFormat.format(this.nTrackedAllocObjects[n3]);
            }
            case 5: {
                return (this.avgObjectAge[n3] > 0.0f ? "+" : "-") + StringUtils.floatPerCentToString((float)Math.abs(this.avgObjectAge[n3]));
            }
            case 6: {
                return (this.maxSurvGen[n3] > 0 ? "+" : "") + this.intFormat.format(this.maxSurvGen[n3]);
            }
            case 7: {
                return (this.nTotalAllocObjects[n3] > 0 ? "+" : "") + this.intFormat.format(this.nTotalAllocObjects[n3]);
            }
        }
        return null;
    }

    protected void initColumnsData() {
        super.initColumnsData();
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer};
    }

    protected void initDataUponResultsFetch() {
        super.initDataUponResultsFetch();
        if (this.barRenderer != null) {
            this.barRenderer.setMinimum(this.diff.getMinTrackedLiveObjectsSizeDiff());
            this.barRenderer.setMaximum(this.diff.getMaxTrackedLiveObjectsSizeDiff());
        }
    }

    protected boolean passesValueFilter(int n) {
        return true;
    }

    protected void performDefaultAction(int n) {
        String string = null;
        int n2 = this.resTable.getSelectedRow();
        if (n2 != -1) {
            string = this.resTable.getValueAt(n2, 0).toString().replaceAll("\\[\\]", "");
        }
        if (string != null) {
            this.actionsHandler.showSourceForMethod(string, null, null);
        }
    }

    protected boolean truncateZeroItems() {
        return false;
    }
}

