/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.treetable;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;

public class TreeTableModelAdapter
extends AbstractTableModel {
    protected AbstractTreeTableModel treeTableModel;
    protected JTree tree;
    protected JTreeTable treeTable;

    public TreeTableModelAdapter(AbstractTreeTableModel abstractTreeTableModel, JTreeTable jTreeTable) {
        this.treeTable = jTreeTable;
        this.tree = jTreeTable.getTree();
        this.treeTableModel = abstractTreeTableModel;
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
            }
        });
        abstractTreeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    public boolean isCellEditable(int n, int n2) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(n), n2);
    }

    public Class getColumnClass(int n) {
        return this.treeTableModel.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treeTableModel.getColumnName(n);
    }

    public Vector getExpandedPaths() {
        Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(this.getRootPath());
        Vector<TreePath> vector = new Vector<TreePath>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector;
    }

    public TreePath getRootPath() {
        return new TreePath(this.treeTableModel.getPathToRoot((CCTNode)this.treeTableModel.getRoot()));
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public void setValueAt(Object object, int n, int n2) {
        this.treeTableModel.setValueAt(object, this.nodeForRow(n), n2);
    }

    public Object getValueAt(int n, int n2) {
        Object object = this.treeTableModel.getValueAt(this.nodeForRow(n), n2);
        return object;
    }

    public void expandRoot() {
        this.tree.expandPath(this.getRootPath());
    }

    public void restoreExpandedPaths(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TreePath treePath = (TreePath)enumeration.nextElement();
            this.tree.expandPath(treePath);
        }
    }

    public void updateTreeTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Vector vector = TreeTableModelAdapter.this.getExpandedPaths();
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.treeTableModel.fireTreeStructureChanged(this, TreeTableModelAdapter.this.treeTableModel.getPathToRoot((CCTNode)TreeTableModelAdapter.this.treeTableModel.getRoot()), null, null);
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
                TreeTableModelAdapter.this.restoreExpandedPaths(vector);
                TreeTableModelAdapter.this.treeTable.getTableHeader().repaint();
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreePath[] treePathArray = TreeTableModelAdapter.this.tree.getSelectionPaths();
                TreeTableModelAdapter.this.fireTableDataChanged();
                TreeTableModelAdapter.this.tree.setSelectionPaths(treePathArray);
            }
        });
    }

    protected Object nodeForRow(int n) {
        TreePath treePath = this.tree.getPathForRow(n);
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }
}

