/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class EnhancedTreeCellRenderer
extends JPanel
implements TreeCellRendererPersistent {
    protected Color backgroundNonSelectionColor;
    protected Color backgroundSelectionColor = UIConstants.TABLE_SELECTION_BACKGROUND_COLOR;
    protected Color borderSelectionColor;
    protected Color textNonSelectionColor;
    protected Color textSelectionColor = UIConstants.TABLE_SELECTION_FOREGROUND_COLOR;
    protected boolean hasFocus;
    protected boolean selected;
    private transient Icon closedIcon = UIManager.getIcon("Tree.closedIcon");
    private transient Icon leafIcon = UIManager.getIcon("Tree.leafIcon");
    private transient Icon openIcon = UIManager.getIcon("Tree.openIcon");
    private BorderLayout borderLayout;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JTree tree;

    public EnhancedTreeCellRenderer() {
        this.setOpaque(false);
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.label2.setFont(this.label1.getFont().deriveFont(1));
        this.borderLayout = new BorderLayout();
        this.setLayout(this.borderLayout);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        this.add((Component)this.label1, "West");
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)this.label2, "West");
        jPanel.add((Component)this.label3, "Center");
        this.label1.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.tree = jTree;
        this.hasFocus = bl4;
        String string2 = this.getLabel1Text(object, string);
        this.label1.setText(string2);
        if ("".equals(string2)) {
            this.borderLayout.setHgap(this.label1.getIconTextGap());
        } else {
            this.borderLayout.setHgap(0);
        }
        this.label2.setText(this.getLabel2Text(object, string));
        this.label3.setText(this.getLabel3Text(object, string));
        if (bl) {
            this.label1.setForeground(this.getTextSelectionColor());
            this.label2.setForeground(this.getTextSelectionColor());
            Color color = this.getTextSelectionColor();
            this.label3.setForeground(color.equals(Color.BLACK) ? Color.GRAY : color.brighter());
        } else {
            this.label1.setForeground(this.getTextNonSelectionColor());
            this.label2.setForeground(this.getTextNonSelectionColor());
            Color color = this.getTextNonSelectionColor();
            this.label3.setForeground(color.equals(Color.BLACK) ? Color.GRAY : color.brighter());
        }
        if (!jTree.isEnabled()) {
            this.label1.setEnabled(false);
            this.label2.setEnabled(false);
            this.label3.setEnabled(false);
            if (bl3) {
                this.label1.setDisabledIcon(this.getLeafIcon(object));
            } else if (bl2) {
                this.label1.setDisabledIcon(this.getOpenIcon(object));
            } else {
                this.label1.setDisabledIcon(this.getClosedIcon(object));
            }
        } else {
            this.label1.setEnabled(true);
            this.label2.setEnabled(true);
            this.label3.setEnabled(true);
            if (bl3) {
                this.label1.setIcon(this.getLeafIcon(object));
            } else if (bl2) {
                this.label1.setIcon(this.getOpenIcon(object));
            } else {
                this.label1.setIcon(this.getClosedIcon(object));
            }
        }
        this.label1.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }

    public Component getTreeCellRendererComponentPersistent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        EnhancedTreeCellRenderer enhancedTreeCellRenderer = new EnhancedTreeCellRenderer();
        enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        enhancedTreeCellRenderer.setClosedIcon(this.closedIcon);
        enhancedTreeCellRenderer.setOpenIcon(this.openIcon);
        return enhancedTreeCellRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public void paint(Graphics graphics) {
        Color color;
        Color color2;
        if (this.selected) {
            color2 = this.getBackgroundSelectionColor();
        } else {
            color2 = this.getBackgroundNonSelectionColor();
            if (color2 == null) {
                color2 = this.getBackground();
            }
        }
        if (color2 != null) {
            graphics.setColor(color2);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.hasFocus && (color = this.getBorderSelectionColor()) != null) {
            graphics.setColor(color);
            graphics.drawRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(graphics);
    }

    protected Icon getClosedIcon(Object object) {
        return this.getClosedIcon();
    }

    protected String getLabel1Text(Object object, String string) {
        return string;
    }

    protected String getLabel2Text(Object object, String string) {
        return "";
    }

    protected String getLabel3Text(Object object, String string) {
        return "";
    }

    protected Icon getLeafIcon(Object object) {
        return this.getLeafIcon();
    }

    protected Icon getOpenIcon(Object object) {
        return this.getOpenIcon();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }
}

