/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.charts.AsyncMarksProvider;
import org.netbeans.lib.profiler.ui.charts.ChartActionListener;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.DateTimeAxisUtils;
import org.netbeans.lib.profiler.ui.charts.DecimalAxisUtils;
import org.netbeans.lib.profiler.ui.charts.DynamicSynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChartModel;

public class SynchronousXYChart
extends JComponent
implements ComponentListener,
ChartModelListener,
MouseListener,
MouseMotionListener,
AdjustmentListener,
Accessible {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.charts.Bundle");
    private static final String FIT_TO_WINDOW_STRING = messages.getString("SynchronousXYChart_FitToWindowString");
    public static final int TYPE_LINE = 1;
    public static final int TYPE_FILL = 2;
    public static final int VALUES_INTERPOLATED = 50;
    public static final int VALUES_DISCRETE = 51;
    public static final int COPY_ACCEL_GENERIC = 100;
    public static final int COPY_ACCEL_RASTER = 101;
    private static final int HORIZONTAL_LEGEND_MARGIN = 5;
    private static final double minimumVisibleDataWidthRel = 0.1;
    private static final long minimumOptimalUnits = 100L;
    private static final double maximumZoom = DateTimeAxisUtils.getMaximumScale(100L);
    private AccessibleContext accessibleContext;
    private BufferedImage offScreenImage;
    private Color evenSelectionSegmentsColor;
    private Color limitYColor = Color.WHITE;
    private Color oddSelectionSegmentColor;
    private Font horizontalAxisFont;
    private Font horizontalAxisFontSmall;
    private Font verticalAxisFont;
    private Graphics2D offScreenGraphics;
    private Insets chartInsets;
    private Insets insets;
    private JScrollBar scrollBar;
    private Paint backgroundPaint;
    private Paint chartPaint;
    private Paint horizontalAxisPaint;
    private Paint horizontalMeshPaint;
    private Paint verticalAxisPaint;
    private Paint verticalMeshPaint;
    private Rectangle horizontalAxisClip = new Rectangle();
    private Rectangle horizontalAxisMarksClip = new Rectangle();
    private Rectangle verticalAxisClip = new Rectangle();
    private Rectangle verticalAxisClip2 = new Rectangle();
    private String verticalAxisValueString;
    private String verticalAxisValueString2;
    private Stroke chartStroke;
    private Stroke evenSelectionSegmentsStroke;
    private Stroke horizontalAxisStroke;
    private Stroke horizontalMeshStroke;
    private Stroke oddSelectionSegmentStroke;
    private Stroke verticalAxisStroke;
    private Stroke verticalMeshStroke;
    private SynchronousXYChartModel model;
    private Vector chartActionListeners;
    private long[] dataOffsetsY;
    private long[] lastMaxYs;
    private long[] lastMinYs;
    private double[] scaleFactorsY;
    private boolean allowSelection;
    private boolean autoTrackingEnd;
    private boolean customizedEmptyAppearance = false;
    private boolean fitToWindow;
    private boolean internalScrollBarChange;
    private boolean lastLeadingItemIsForBuffer;
    private boolean lastScaleXValid;
    private boolean lastScaleYValid;
    private boolean lastTrailingItemIndexValid;
    private boolean lastViewOffsetXValid;
    private boolean mouseInProgress;
    private boolean offScreenImageInvalid;
    private boolean scaleFactorsNeedUpdate;
    private boolean scrollBarValuesDirty;
    private boolean selectionTracksMovement;
    private boolean trackingEnd;
    private boolean trailingItemVisible;
    private boolean useDayInTimeLegend;
    private boolean useSecondaryVerticalAxis;
    private boolean verticalAxisValueAdaptDivider;
    private boolean verticalAxisValueAdaptDivider2;
    private double dataWidthAtTrackingEndSwitch;
    private double initialZoom;
    private double scaleFactorX;
    private double scrollBarLongToIntFactor;
    private double viewScaleX;
    private int chartHeight;
    private int chartWidth;
    private int copyAccel = 100;
    private int dataType;
    private int drawHeight;
    private int drawWidth;
    private int lastLeadingItemIndex;
    private int lastTrailingItemIndex;
    private int minimumVerticalMarksDistance;
    private int selectionHeight;
    private int selectionWidth;
    private int selectionX;
    private int selectionY;
    private int topChartMargin;
    private int type;
    private int verticalAxisValueDivider;
    private int verticalAxisValueDivider2;
    private long dataOffsetX;
    private long dataViewWidth;
    private long firstValueH;
    private long firstValueV;
    private long lastMaxY;
    private long lastMinY;
    private long lastValueH;
    private long lastValueV;
    private long lastViewOffsetX;
    private long limitYValue = Long.MAX_VALUE;
    private long optimalUnits;
    private long viewOffsetX;

    public SynchronousXYChart() {
        this(2);
    }

    public SynchronousXYChart(int n) {
        this(n, 50);
    }

    public SynchronousXYChart(int n, int n2) {
        this(n, n2, 1.0);
    }

    public SynchronousXYChart(int n, int n2, double d) {
        this.type = n;
        this.dataType = n2;
        this.allowSelection = false;
        this.chartInsets = new Insets(10, 20, 10, 20);
        this.topChartMargin = 20;
        this.backgroundPaint = UIManager.getColor("Panel.background");
        this.chartPaint = Color.WHITE;
        this.chartStroke = new BasicStroke(2.0f);
        this.mouseInProgress = false;
        this.lastViewOffsetXValid = false;
        this.lastScaleXValid = false;
        this.lastScaleYValid = false;
        this.lastTrailingItemIndex = 0;
        this.lastTrailingItemIndexValid = false;
        this.changeTrackingEnd(false);
        this.changeFitToWindow(false);
        this.autoTrackingEnd = true;
        this.selectionTracksMovement = true;
        this.initialZoom = d;
        this.viewScaleX = d;
        this.viewOffsetX = 0L;
        this.verticalMeshPaint = new Color(80, 80, 80, 50);
        this.verticalMeshStroke = new BasicStroke();
        this.horizontalAxisFont = UIManager.getFont("Panel.font");
        this.horizontalAxisFontSmall = this.horizontalAxisFont.deriveFont((float)(this.horizontalAxisFont.getSize() - 2));
        this.verticalAxisFont = UIManager.getFont("Panel.font");
        this.horizontalAxisPaint = Color.BLACK;
        this.horizontalAxisStroke = new BasicStroke();
        this.verticalAxisPaint = Color.BLACK;
        this.verticalAxisStroke = new BasicStroke();
        this.useSecondaryVerticalAxis = false;
        this.verticalAxisValueDivider = 1;
        this.verticalAxisValueString = "";
        this.setVerticalAxisValueAdaptDivider(false);
        this.verticalAxisValueDivider2 = 1;
        this.verticalAxisValueString2 = "";
        this.setVerticalAxisValueAdaptDivider2(false);
        this.useDayInTimeLegend = false;
        this.minimumVerticalMarksDistance = 50;
        this.evenSelectionSegmentsColor = Color.WHITE;
        this.evenSelectionSegmentsStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
        this.oddSelectionSegmentColor = Color.BLACK;
        this.oddSelectionSegmentStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 2.0f);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public void setAutoTrackingEnd(boolean bl) {
        this.autoTrackingEnd = bl;
    }

    public boolean getAutoTrackingEnd() {
        return this.autoTrackingEnd;
    }

    public void setBackgroundPaint(Paint paint) {
        if (this.backgroundPaint == null && paint != null || !this.backgroundPaint.equals(paint)) {
            this.backgroundPaint = paint;
            this.doRepaint(false);
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setChartPaint(Paint paint) {
        if (this.chartPaint == null && paint != null || !this.chartPaint.equals(paint)) {
            this.chartPaint = paint;
            this.doRepaint(false);
        }
    }

    public Paint getChartPaint() {
        return this.backgroundPaint;
    }

    public void setChartStroke(Stroke stroke) {
        if (this.chartStroke == null && stroke != null || !this.chartStroke.equals(stroke)) {
            this.chartStroke = stroke;
            this.doRepaint(false);
        }
    }

    public Stroke getChartStroke() {
        return this.chartStroke;
    }

    public void setCopyAcceleration(int n) {
        this.copyAccel = n;
    }

    public int getCopyAcceleration() {
        return this.copyAccel;
    }

    public long getDataToViewHeight(long l, int n) {
        return (long)Math.ceil((double)l * this.scaleFactorsY[n]);
    }

    public long getDataToViewWidth(long l) {
        return (long)Math.ceil((double)l * this.scaleFactorX);
    }

    public long getDataToViewX(long l) {
        return (long)Math.ceil((double)(l - this.dataOffsetX) * this.scaleFactorX + (double)this.chartInsets.left - (double)this.viewOffsetX);
    }

    public long getDataToViewY(long l, int n) {
        return (long)this.chartHeight - (long)Math.ceil((double)(l - this.dataOffsetsY[n]) * this.scaleFactorsY[n] - (double)this.chartInsets.top);
    }

    public void setFitToWindow(boolean bl) {
        if (bl) {
            this.setFitToWindow();
        } else {
            this.resetFitToWindow();
        }
    }

    public void setFitToWindow() {
        if (!this.fitToWindow) {
            this.changeFitToWindow(true);
            this.changeTrackingEnd(false);
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public boolean isFitToWindow() {
        return this.fitToWindow;
    }

    public void setHorizontalAxisFont(Font font) {
        if (font != null && !this.horizontalAxisFont.equals(font)) {
            this.horizontalAxisFont = font;
            this.horizontalAxisFontSmall = font.deriveFont((float)(font.getSize() - 2));
        }
    }

    public Font getHorizontalAxisFont() {
        return this.horizontalAxisFont;
    }

    public void setHorizontalMeshPaint(Paint paint) {
        if (paint != null && !this.horizontalMeshPaint.equals(paint)) {
            this.horizontalMeshPaint = paint;
        }
    }

    public Paint getHorizontalMeshPaint() {
        return this.horizontalMeshPaint;
    }

    public void setHorizontalMeshStroke(Stroke stroke) {
        if (stroke != null && !this.horizontalMeshStroke.equals(stroke)) {
            this.horizontalMeshStroke = stroke;
        }
    }

    public Stroke getHorizontalMeshStroke() {
        return this.horizontalMeshStroke;
    }

    public int getIntBlockIncrement() {
        return (int)((double)(this.chartWidth - 20) * this.scrollBarLongToIntFactor);
    }

    public int getIntExtent() {
        return (int)((double)this.getRealExtent() * this.scrollBarLongToIntFactor);
    }

    public int getIntMaximum() {
        return (int)((double)this.getRealMaximum() * this.scrollBarLongToIntFactor);
    }

    public int getIntMinimum() {
        return 0;
    }

    public int getIntPosition() {
        return (int)((double)this.getRealPosition() * this.scrollBarLongToIntFactor);
    }

    public int getIntUnitIncrement() {
        return (int)(20.0 * this.scrollBarLongToIntFactor);
    }

    public int getLeadingItemIndexForPosition(int n) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return -1;
        }
        long l = (long)this.getXValueAtPosition(n);
        int n2 = this.lastLeadingItemIndex;
        if (this.model.getXValue(n2) == l) {
            return n2;
        }
        if (this.model.getXValue(n2) < l) {
            for (int i = n2; i < this.model.getItemCount() - 1; ++i) {
                if (this.model.getXValue(i + 1) <= l) continue;
                return i;
            }
            return -1;
        }
        for (int i = n2; i >= 0; --i) {
            if (this.model.getXValue(i) >= l) continue;
            return i;
        }
        return -1;
    }

    public double getMaximumZoom() {
        return maximumZoom;
    }

    public boolean isMaximumZoom() {
        return this.viewScaleX >= maximumZoom;
    }

    public void setMinimumVerticalMarksDistance(int n) {
        this.minimumVerticalMarksDistance = n;
    }

    public int getMinimumVerticalMarksDistance() {
        return this.minimumVerticalMarksDistance;
    }

    public double getMinimumZoom() {
        if (this.model == null) {
            return 0.0;
        }
        return Math.min(this.initialZoom, (double)this.chartWidth * 0.1 / (double)(this.model.getMaxXValue() - this.model.getMinXValue()));
    }

    public boolean isMinimumZoom() {
        return this.viewScaleX <= this.getMinimumZoom();
    }

    public void setModel(SynchronousXYChartModel synchronousXYChartModel) {
        if (this.model != null) {
            this.model.removeChartModelListener(this);
        }
        if (synchronousXYChartModel != null) {
            synchronousXYChartModel.addChartModelListener(this);
        }
        this.model = synchronousXYChartModel;
        this.lastMinYs = new long[synchronousXYChartModel.getSeriesCount()];
        this.lastMaxYs = new long[synchronousXYChartModel.getSeriesCount()];
        this.dataOffsetsY = new long[synchronousXYChartModel.getSeriesCount()];
        this.scaleFactorsY = new double[synchronousXYChartModel.getSeriesCount()];
        this.offScreenImageInvalid = true;
        this.doRepaint(true);
    }

    public SynchronousXYChartModel getModel() {
        return this.model;
    }

    public boolean isOverChart(Point point) {
        return this.isOverChart(point.x, point.y);
    }

    public boolean isOverChart(int n, int n2) {
        Insets insets = this.getInsets();
        return n >= insets.left + this.chartInsets.left && n <= insets.left + this.chartInsets.left + this.chartWidth && n2 >= insets.top + this.chartInsets.top && n2 <= insets.top + this.chartInsets.top + this.chartHeight;
    }

    public long getRealExtent() {
        return this.chartWidth;
    }

    public long getRealMaximum() {
        return this.dataViewWidth;
    }

    public long getRealMinimum() {
        return 0L;
    }

    public long getRealPosition() {
        return this.viewOffsetX;
    }

    public void setScale(double d) {
        if (!this.fitToWindow) {
            if (this.isMinimumZoom() && d < this.getMinimumZoom()) {
                return;
            }
            if (this.isMaximumZoom() && d > this.getMaximumZoom()) {
                return;
            }
        }
        if (this.viewScaleX != d) {
            double d2 = this.getViewToDataApproxX(this.chartInsets.left);
            this.changeZoom(d);
            this.changeFitToWindow(false);
            this.changePan(Math.min((long)((double)(this.model.getMaxXValue() - this.model.getMinXValue()) * this.viewScaleX - (double)this.chartWidth), (long)((d2 - (double)this.dataOffsetX) * this.viewScaleX)));
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        } else {
            this.repaint();
        }
    }

    public double getScale() {
        return this.viewScaleX;
    }

    public void setScaleAndOffsetX(double d, long l) {
        if (this.viewScaleX != d || this.viewOffsetX != l) {
            this.changeZoom(d);
            this.changePan(l);
            this.changeTrackingEnd(false);
            this.changeFitToWindow(false);
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public boolean isSelectionAllowed() {
        return this.allowSelection;
    }

    public void setSelectionTracksMovement(boolean bl) {
        this.selectionTracksMovement = bl;
    }

    public boolean getSelectionTracksMovement() {
        return this.selectionTracksMovement;
    }

    public String getTimeAtPosition(int n) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return null;
        }
        if (!this.useDayInTimeLegend) {
            return DateTimeAxisUtils.getMillisValue((long)this.getXValueAtPosition(n), false);
        }
        return DateTimeAxisUtils.getMillisValueFull((long)this.getXValueAtPosition(n));
    }

    public void setTopChartMargin(int n) {
        if (this.topChartMargin != n) {
            this.topChartMargin = n;
        }
    }

    public int getTopChartMargin() {
        return this.topChartMargin;
    }

    public void setTrackingEnd(double d) {
        if (this.viewScaleX != d) {
            this.changeZoom(d);
            this.lastScaleXValid = false;
        }
        this.setTrackingEnd();
    }

    public void setTrackingEnd(boolean bl) {
        if (bl) {
            this.setTrackingEnd();
        } else {
            this.resetTrackingEnd();
        }
    }

    public void setTrackingEnd() {
        if (!this.trackingEnd) {
            this.changeTrackingEnd(!this.trailingItemVisible || this.fitToWindow);
            this.lastViewOffsetXValid = false;
            if (this.fitToWindow && this.viewScaleX == 0.0) {
                this.dataWidthAtTrackingEndSwitch = this.model.getMaxXValue() - this.dataOffsetX;
            }
            this.changeFitToWindow(false);
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public boolean isTrackingEnd() {
        return this.trackingEnd;
    }

    public void setUseSecondaryVerticalAxis(boolean bl) {
        this.useSecondaryVerticalAxis = bl;
        this.updateOffScreenImageSize();
    }

    public boolean getUseSecondaryVerticalAxis() {
        return this.useSecondaryVerticalAxis;
    }

    public void setVerticalAxisFont(Font font) {
        if (font != null && !this.verticalAxisFont.equals(font)) {
            this.verticalAxisFont = font;
        }
    }

    public Font getVerticalAxisFont() {
        return this.verticalAxisFont;
    }

    public void setVerticalAxisValueDivider(int n) {
        this.verticalAxisValueDivider = n;
    }

    public int getVerticalAxisValueDivider() {
        return this.verticalAxisValueDivider;
    }

    public void setVerticalAxisValueDivider2(int n) {
        this.verticalAxisValueDivider2 = n;
    }

    public int getVerticalAxisValueDivider2() {
        return this.verticalAxisValueDivider2;
    }

    public void setVerticalAxisValueString(String string) {
        this.verticalAxisValueString = string == null ? "" : string;
    }

    public String getVerticalAxisValueString() {
        return this.verticalAxisValueString;
    }

    public void setVerticalAxisValueString2(String string) {
        this.verticalAxisValueString2 = string == null ? "" : string;
    }

    public String getVerticalAxisValueString2() {
        return this.verticalAxisValueString2;
    }

    public void setVerticalMeshPaint(Paint paint) {
        if (paint != null && !this.verticalMeshPaint.equals(paint)) {
            this.verticalMeshPaint = paint;
        }
    }

    public Paint getVerticalMeshPaint() {
        return this.verticalMeshPaint;
    }

    public void setVerticalMeshStroke(Stroke stroke) {
        if (stroke != null && !this.verticalMeshStroke.equals(stroke)) {
            this.verticalMeshStroke = stroke;
        }
    }

    public Stroke getVerticalMeshStroke() {
        return this.verticalMeshStroke;
    }

    public void setViewOffsetX(long l) {
        if (this.viewOffsetX != l) {
            this.changePan(l);
            this.changeTrackingEnd(false);
            this.changeFitToWindow(false);
            this.lastViewOffsetXValid = false;
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public long getViewOffsetX() {
        return this.viewOffsetX;
    }

    public double getViewToDataApproxHeight(long l, int n) {
        return 0.0;
    }

    public double getViewToDataApproxWidth(long l) {
        return (double)l / this.scaleFactorX;
    }

    public double getViewToDataApproxX(long l) {
        return (double)(l - (long)this.chartInsets.left + this.viewOffsetX) / this.scaleFactorX + (double)this.dataOffsetX;
    }

    public double getViewToDataApproxY(long l, int n) {
        return 0.0;
    }

    public boolean isWithinData(int n) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return false;
        }
        int n2 = this.getLeadingItemIndexForPosition(n);
        if (n2 == -1) {
            return false;
        }
        return n2 >= 0 && n2 < this.model.getItemCount();
    }

    public long getYValueAtPosition(int n, int n2) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return -1L;
        }
        double d = this.getXValueAtPosition(n);
        int n3 = this.getLeadingItemIndexForPosition(n);
        int n4 = n3 + 1;
        if (n4 == this.model.getItemCount()) {
            return -1L;
        }
        long l = this.model.getYValue(n3, n2);
        if (this.dataType == 51) {
            return l;
        }
        long l2 = this.model.getYValue(n4, n2);
        long l3 = this.model.getXValue(n3);
        long l4 = this.model.getXValue(n4);
        double d2 = (d - (double)l3) / (double)(l4 - l3);
        return (long)((double)(l2 - l) * d2) + l;
    }

    public synchronized void addChartActionListener(ChartActionListener chartActionListener) {
        if (this.chartActionListeners == null) {
            this.chartActionListeners = new Vector();
        }
        if (!this.chartActionListeners.contains(chartActionListener)) {
            this.chartActionListeners.add(chartActionListener);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.internalScrollBarChange) {
            this.internalScrollBarChange = false;
        } else if (this.autoTrackingEnd && adjustmentEvent.getValue() + this.scrollBar.getModel().getExtent() == this.scrollBar.getMaximum()) {
            this.setTrackingEnd();
        } else {
            this.setViewOffsetX((long)((double)adjustmentEvent.getValue() / this.scrollBarLongToIntFactor));
            if (!this.scrollBar.getValueIsAdjusting() && this.scrollBarValuesDirty) {
                this.scrollBarValuesDirty = false;
                this.updateScrollBarValues();
            }
        }
    }

    public void allowSelection() {
        this.allowSelection = true;
    }

    public void associateJScrollBar(JScrollBar jScrollBar) {
        this.deassociateJScrollBar();
        if (jScrollBar != null) {
            this.scrollBar = jScrollBar;
            this.scrollBar.addAdjustmentListener(this);
            this.updateScrollBarValues();
        }
    }

    public void chartDataChanged() {
        this.limitYValue = this.model.getLimitYValue();
        this.limitYColor = this.model.getLimitYColor();
        this.updateScaleFactors();
        this.fireChartDataChanged();
        if (this.isShowing()) {
            if (this.trackingEnd && this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                return;
            }
            this.checkChartMargins();
            if (this.trackingEnd || this.fitToWindow || this.trailingItemVisible || !this.lastScaleYValid) {
                this.offScreenImageInvalid = true;
                this.doRepaint(false);
            }
        } else {
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.lastScaleYValid = false;
            this.lastTrailingItemIndexValid = false;
            this.lastLeadingItemIsForBuffer = false;
            this.lastLeadingItemIndex = 0;
            this.trailingItemVisible = true;
            this.scrollBarValuesDirty = true;
            this.offScreenImageInvalid = true;
            if (this.trackingEnd) {
                this.viewOffsetX = (long)(-this.chartWidth) + this.dataViewWidth;
            }
            if (!this.fitToWindow && this.model.getItemCount() > 1) {
                this.updateTrailingItemVisible();
            }
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.updateOffScreenImageSize();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public boolean containsValidData() {
        return this.model != null && this.model.getItemCount() > 1;
    }

    public void deassociateJScrollBar() {
        if (this.scrollBar != null) {
            this.scrollBar.removeAdjustmentListener(this);
        }
    }

    public void denySelection() {
        this.allowSelection = false;
    }

    public void fitToViewRectangle(int n, int n2, int n3, int n4) {
        double d = this.getViewToDataApproxX(n - this.getInsets().left);
        double d2 = this.getViewToDataApproxWidth(n3 + 1);
        double d3 = (double)this.chartWidth / d2;
        if (this.isMaximumZoom() && d3 > maximumZoom) {
            this.repaint();
            return;
        }
        this.changeZoom(d3);
        this.changeFitToWindow(false);
        this.changePan((long)((d - (double)this.dataOffsetX) * this.viewScaleX));
        this.trackingEnd = false;
        this.lastViewOffsetXValid = false;
        this.lastScaleXValid = false;
        this.offScreenImageInvalid = true;
        this.doRepaint(true);
    }

    public boolean hasValidDataForPosition(Point point) {
        return this.hasValidDataForPosition(point.x, point.y);
    }

    public boolean hasValidDataForPosition(int n, int n2) {
        return this.isOverChart(n, n2) && this.isWithinData(n);
    }

    public static void main(String[] stringArray) {
        SynchronousXYChart synchronousXYChart = new SynchronousXYChart(2);
        synchronousXYChart.setBorder(BorderFactory.createEmptyBorder(15, 20, 35, 20));
        synchronousXYChart.setPreferredSize(new Dimension(600, 400));
        DynamicSynchronousXYChartModel dynamicSynchronousXYChartModel = new DynamicSynchronousXYChartModel();
        dynamicSynchronousXYChartModel.setupModel(new String[]{"Item 1", "Item 2", "Item 3"}, new Color[]{Color.RED, Color.GREEN, Color.BLUE});
        JFrame jFrame = new JFrame("SynchronousXYChart Tester");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)synchronousXYChart, "Center");
        JScrollBar jScrollBar = new JScrollBar(0);
        synchronousXYChart.associateJScrollBar(jScrollBar);
        jFrame.getContentPane().add((Component)jScrollBar, "South");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        dynamicSynchronousXYChartModel.addItemValues(0L, new long[]{30L, 20L, 10L});
        dynamicSynchronousXYChartModel.addItemValues(5L, new long[]{45L, 38L, 20L});
        dynamicSynchronousXYChartModel.addItemValues(20L, new long[]{62L, 61L, 30L});
        dynamicSynchronousXYChartModel.addItemValues(50L, new long[]{90L, 80L, 48L});
        synchronousXYChart.setModel(dynamicSynchronousXYChartModel);
    }

    public void setVerticalAxisValueAdaptDivider(boolean bl) {
        this.verticalAxisValueAdaptDivider = bl;
    }

    public boolean isVerticalAxisValueAdaptDivider() {
        return this.verticalAxisValueAdaptDivider;
    }

    public void setVerticalAxisValueAdaptDivider2(boolean bl) {
        this.verticalAxisValueAdaptDivider2 = bl;
    }

    public boolean isVerticalAxisValueAdaptDivider2() {
        return this.verticalAxisValueAdaptDivider2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.allowSelection && this.mouseInProgress) {
            int n = Math.min(this.insets.left + this.drawWidth - this.chartInsets.right - 1, mouseEvent.getX());
            if (this.trailingItemVisible) {
                n = Math.min(this.insets.left + (int)this.getDataToViewX(this.model.getXValue(this.model.getItemCount() - 1)), n);
            }
            int n2 = Math.min(this.insets.top + this.drawHeight - this.chartInsets.bottom, mouseEvent.getY());
            this.selectionWidth = n - this.selectionX;
            this.selectionHeight = n2 - this.selectionY - 1;
            this.doRepaint(false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.model == null || this.model.getItemCount() < 2) {
            return;
        }
        if (this.allowSelection && mouseEvent.getButton() == 1) {
            boolean bl;
            boolean bl2;
            int n = this.insets.left + this.chartInsets.left;
            int n2 = this.insets.top + this.chartInsets.top;
            int n3 = Math.max(n, mouseEvent.getX());
            int n4 = mouseEvent.getY();
            boolean bl3 = bl2 = n3 < n + this.chartWidth;
            if (this.trailingItemVisible) {
                bl2 = bl2 && n3 <= this.insets.left + (int)this.getDataToViewX(this.model.getXValue(this.model.getItemCount() - 1));
            }
            boolean bl4 = bl = n4 >= n2 && n4 < n2 + this.chartHeight;
            if (bl2 && bl) {
                this.selectionX = n3;
                this.selectionWidth = 0;
                this.selectionY = n4;
                this.selectionHeight = n4 - this.selectionY - 1;
                this.mouseInProgress = true;
                this.doRepaint(false);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.allowSelection && this.mouseInProgress) {
            this.mouseInProgress = false;
            this.performSelectionDone();
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.model == null) {
            return;
        }
        if (this.offScreenImage == null) {
            this.updateOffScreenImageSize();
        }
        if (this.offScreenImageInvalid) {
            this.drawChart(this.offScreenGraphics);
        }
        graphics.drawImage(this.offScreenImage, this.insets.left, this.insets.top, this);
        if (this.allowSelection && this.mouseInProgress) {
            this.drawSelection((Graphics2D)graphics);
        }
    }

    public synchronized void removeChartActionListener(ChartActionListener chartActionListener) {
        if (this.chartActionListeners != null) {
            this.chartActionListeners.remove(chartActionListener);
        }
    }

    public void resetChart() {
        this.changeTrackingEnd(false);
        this.changeFitToWindow(false);
        this.changePan(0L);
        this.changeZoom(this.initialZoom);
        this.mouseInProgress = false;
        this.lastViewOffsetXValid = false;
        this.lastScaleXValid = false;
        this.lastScaleYValid = false;
        this.lastLeadingItemIsForBuffer = false;
        this.lastLeadingItemIndex = 0;
        this.trailingItemVisible = true;
        this.scrollBarValuesDirty = true;
        this.offScreenImageInvalid = true;
        this.lastTrailingItemIndexValid = false;
        this.lastTrailingItemIndex = 0;
        this.useDayInTimeLegend = false;
        this.doRepaint(true);
    }

    public void resetFitToWindow() {
        if (this.fitToWindow) {
            this.changeFitToWindow(false);
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public void resetTrackingEnd() {
        if (this.trackingEnd) {
            this.changeTrackingEnd(false);
            this.offScreenImageInvalid = true;
            this.doRepaint(true);
        }
    }

    public void setupInitialAppearance(long l, long l2, long l3, long l4) {
        this.customizedEmptyAppearance = true;
        this.firstValueH = l;
        this.lastValueH = l2;
        this.firstValueV = l3;
        this.lastValueV = l4;
    }

    public void update(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartDataChanged() {
        Vector vector;
        if (this.chartActionListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.chartActionListeners.clone();
        }
        object = vector.iterator();
        while (object.hasNext()) {
            ((ChartActionListener)object.next()).chartDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartFitToWindowChanged() {
        Vector vector;
        if (this.chartActionListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.chartActionListeners.clone();
        }
        object = vector.iterator();
        while (object.hasNext()) {
            ((ChartActionListener)object.next()).chartFitToWindowChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartPanned() {
        Vector vector;
        if (this.chartActionListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.chartActionListeners.clone();
        }
        object = vector.iterator();
        while (object.hasNext()) {
            ((ChartActionListener)object.next()).chartPanned();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartTrackingEndChanged() {
        Vector vector;
        if (this.chartActionListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.chartActionListeners.clone();
        }
        object = vector.iterator();
        while (object.hasNext()) {
            ((ChartActionListener)object.next()).chartTrackingEndChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartZoomed() {
        Vector vector;
        if (this.chartActionListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.chartActionListeners.clone();
        }
        object = vector.iterator();
        while (object.hasNext()) {
            ((ChartActionListener)object.next()).chartZoomed();
        }
    }

    private int getBottomHorizontalAxisLegendHeight() {
        return this.horizontalAxisFont.getSize() + this.verticalAxisFont.getSize() / 2 + 10;
    }

    private int getLeadingItemIndex(long l) {
        for (int i = 0; i < this.model.getItemCount() - 1; ++i) {
            if ((long)Math.ceil((double)(this.model.getXValue(i + 1) - this.dataOffsetX) * this.viewScaleX) <= l) continue;
            return i;
        }
        return this.model.getItemCount() - 1;
    }

    private int getLeadingItemIndex(long l, int n) {
        if (l > this.lastViewOffsetX) {
            for (int i = n; i < this.model.getItemCount() - 1; ++i) {
                if ((long)Math.ceil((double)(this.model.getXValue(i + 1) - this.dataOffsetX) * this.viewScaleX) <= l) continue;
                return i;
            }
            return this.model.getItemCount() - 1;
        }
        for (int i = n; i >= 0; --i) {
            if ((long)Math.ceil((double)(this.model.getXValue(i) - this.dataOffsetX) * this.viewScaleX) >= l) continue;
            return i;
        }
        return 0;
    }

    private int getLeftVerticalAxisLegendWidth() {
        if (this.isVerticalAxisValueAdaptDivider()) {
            return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth("2000M" + (this.getVerticalAxisValueString() != null ? this.getVerticalAxisValueString() : ""));
        }
        return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth(this.getVerticalAxisMarkString(this.model.getMaxDisplayYValue(0))) - 10;
    }

    private int getRightVerticalAxisLegendWidth() {
        if (this.useSecondaryVerticalAxis) {
            if (this.isVerticalAxisValueAdaptDivider2()) {
                return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth("2000M" + (this.getVerticalAxisValueString2() != null ? this.getVerticalAxisValueString2() : ""));
            }
            return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth(this.getVerticalAxisMarkString2(this.model.getMaxDisplayYValue(1))) + 7;
        }
        return this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth("100") - 10;
    }

    private String getVerticalAxisMarkString(long l) {
        return l + this.verticalAxisValueString;
    }

    private String getVerticalAxisMarkString2(long l) {
        return l + this.verticalAxisValueString2;
    }

    private double getXValueAtPosition(int n) {
        return this.getViewToDataApproxX(n - this.getInsets().left);
    }

    private void changeFitToWindow(boolean bl) {
        if (this.fitToWindow != bl) {
            this.fitToWindow = bl;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronousXYChart.this.fireChartFitToWindowChanged();
                }
            });
        }
    }

    private void changePan(long l) {
        if (this.viewOffsetX != (l = Math.max(l, 0L))) {
            this.viewOffsetX = l;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronousXYChart.this.fireChartPanned();
                }
            });
        }
    }

    private void changeTrackingEnd(boolean bl) {
        if (this.trackingEnd != bl) {
            this.trackingEnd = bl;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronousXYChart.this.fireChartTrackingEndChanged();
                }
            });
        }
    }

    private void changeZoom(double d) {
        if (!this.fitToWindow) {
            d = Math.max(d, this.getMinimumZoom());
            d = Math.min(d, this.getMaximumZoom());
        }
        if (this.viewScaleX != d) {
            this.viewScaleX = d;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronousXYChart.this.fireChartZoomed();
                }
            });
        }
    }

    private boolean checkBottomChartMargin() {
        int n = this.getBottomHorizontalAxisLegendHeight();
        if (this.chartInsets.bottom < n) {
            this.chartInsets.bottom = n;
            return true;
        }
        return false;
    }

    private void checkChartMargins() {
        if (this.checkLeftChartMargin() || this.checkRightChartMargin()) {
            this.updateOffScreenImageSize();
        }
    }

    private boolean checkLeftChartMargin() {
        int n = this.getLeftVerticalAxisLegendWidth();
        if (this.chartInsets.left < n) {
            this.chartInsets.left = n;
            return true;
        }
        return false;
    }

    private boolean checkRightChartMargin() {
        int n = this.getRightVerticalAxisLegendWidth();
        if (this.chartInsets.right < n) {
            this.chartInsets.right = n;
            return true;
        }
        return false;
    }

    private void doRepaint(boolean bl) {
        this.scaleFactorsNeedUpdate = bl;
        this.repaint();
    }

    private void drawChart(Graphics2D graphics2D) {
        if (this.model.getItemCount() < 2) {
            if (this.customizedEmptyAppearance) {
                this.drawChartLegendEmpty(graphics2D);
            }
            return;
        }
        if (this.scaleFactorsNeedUpdate) {
            this.updateScaleFactors();
        }
        if (this.fitToWindow) {
            this.drawChartFitToWindow(graphics2D);
        } else {
            this.drawChartFromCurrentViewOffsetX(graphics2D);
        }
        this.offScreenImageInvalid = false;
    }

    private void drawChartFitToWindow(Graphics2D graphics2D) {
        int n;
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight);
        int n2 = Integer.MAX_VALUE;
        if (this.limitYValue != Long.MAX_VALUE) {
            n2 = (int)this.getDataToViewY(this.limitYValue, 0);
        }
        if (n2 != Integer.MAX_VALUE && n2 >= this.chartInsets.top) {
            graphics2D.setPaint(this.limitYColor);
            graphics2D.fillRect(this.chartInsets.left, this.chartInsets.top, this.chartWidth, n2 - this.chartInsets.top + 1);
            graphics2D.setPaint(this.chartPaint);
            graphics2D.fillRect(this.chartInsets.left, n2 + 1, this.chartWidth, this.chartHeight - n2 + this.chartInsets.top);
        } else {
            graphics2D.setPaint(this.chartPaint);
            graphics2D.fillRect(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight);
        }
        if (this.model instanceof AsyncMarksProvider) {
            AsyncMarksProvider asyncMarksProvider = (AsyncMarksProvider)((Object)this.model);
            Color color = asyncMarksProvider.getMarkColor();
            int n3 = asyncMarksProvider.getMarksCount();
            int n4 = Integer.MIN_VALUE;
            for (n = 0; n < n3; ++n) {
                long l = asyncMarksProvider.getMarkStart(n);
                long l2 = asyncMarksProvider.getMarkEnd(n);
                int n5 = (int)this.getDataToViewX(l);
                int n6 = Math.max((int)this.getDataToViewX(l2), n5 + 1);
                if (n6 <= n4) continue;
                int n7 = n6 - (n5 = Math.max(n5, n4));
                if (n7 > 0) {
                    graphics2D.setColor(color);
                    graphics2D.fillRect(n5, this.chartInsets.top, n6 - n5, this.chartHeight);
                }
                n4 = n6;
            }
        }
        for (n = 1; n < this.model.getItemCount(); ++n) {
            long l = this.getDataToViewX(this.model.getXValue(n - 1));
            long l3 = this.getDataToViewX(this.model.getXValue(n));
            for (int i = 0; i < this.model.getSeriesCount(); ++i) {
                this.drawSeriesItem(graphics2D, this.model.getSeriesColor(i), l, this.getDataToViewY(this.model.getYValue(n - 1, i), i), l3, this.getDataToViewY(this.model.getYValue(n, i), i));
            }
        }
        this.drawChartLegend(graphics2D, graphics2D.getClip(), 0, this.chartWidth - 1);
        graphics2D.setClip(shape);
    }

    private void drawChartFromCurrentViewOffsetX(Graphics2D graphics2D) {
        this.drawChartFromOffset(graphics2D, this.viewOffsetX);
    }

    private void drawChartFromOffset(Graphics2D graphics2D, long l) {
        Shape shape = graphics2D.getClip();
        if (this.lastViewOffsetXValid) {
            if (this.trailingItemVisible || !this.lastScaleYValid) {
                int n = this.lastLeadingItemIsForBuffer ? this.getLeadingItemIndex(l) : (this.lastScaleYValid && this.lastTrailingItemIndexValid ? this.lastTrailingItemIndex : this.getLeadingItemIndex(l, this.lastLeadingItemIndex));
                this.drawChartFromOffset(graphics2D, n, (int)this.getDataToViewX(this.model.getXValue(n)) - this.chartInsets.left, this.chartWidth);
                if (this.lastLeadingItemIsForBuffer) {
                    this.lastLeadingItemIndex = n;
                }
                this.lastLeadingItemIsForBuffer = false;
                this.lastTrailingItemIndex = this.model.getItemCount() - 1;
                this.lastTrailingItemIndexValid = true;
                if (this.trackingEnd) {
                    this.lastViewOffsetXValid = false;
                }
            } else {
                this.lastTrailingItemIndexValid = false;
            }
        } else {
            this.lastTrailingItemIndexValid = false;
            if (this.lastScaleXValid) {
                if (this.lastScaleYValid) {
                    if (this.viewOffsetX > this.lastViewOffsetX) {
                        int n;
                        int n2 = (int)(this.viewOffsetX - this.lastViewOffsetX);
                        int n3 = (int)(this.trailingItemVisible ? this.getDataToViewX(this.model.getMaxXValue()) : (long)(this.chartWidth - n2));
                        if (n3 > 0 && n2 > 0 && this.chartHeight > 0) {
                            if (this.copyAccel == 101) {
                                n = this.offScreenImage.getRaster().getWidth();
                                int n4 = this.offScreenImage.getRaster().getHeight();
                                int n5 = this.chartInsets.left + n2;
                                int n6 = this.chartInsets.top;
                                if (n5 >= 0 && n5 + n3 <= n && n6 >= 0 && n6 + this.chartHeight <= n4 && this.chartInsets.left >= 0 && this.chartInsets.left + n3 <= n && this.chartInsets.top >= 0 && this.chartInsets.top + this.chartHeight <= n4) {
                                    WritableRaster writableRaster = this.offScreenImage.getRaster().createWritableChild(n5, n6, n3, this.chartHeight, 0, 0, null);
                                    this.offScreenImage.getRaster().setDataElements(this.chartInsets.left, this.chartInsets.top, writableRaster);
                                }
                            } else {
                                graphics2D.copyArea(this.chartInsets.left + n2, this.chartInsets.top, n3, this.chartHeight, -n2, 0);
                            }
                        }
                        if (this.selectionTracksMovement && this.mouseInProgress && this.trackingEnd) {
                            n = Math.min(this.selectionX - this.chartInsets.left - this.getInsets().left, n2);
                            this.selectionX -= n;
                            this.selectionWidth += n;
                        }
                        int n7 = this.lastLeadingItemIsForBuffer ? this.getLeadingItemIndex(l + (long)n3, this.lastLeadingItemIndex) : this.getLeadingItemIndex(l);
                        this.drawChartFromOffset(graphics2D, n7, n3, this.chartWidth);
                        this.lastLeadingItemIsForBuffer = true;
                        this.lastLeadingItemIndex = n7;
                    } else {
                        int n = (int)(this.lastViewOffsetX - this.viewOffsetX);
                        int n8 = this.chartWidth - n;
                        if (n8 > 0 && n > 0 && this.chartHeight > 0) {
                            if (this.copyAccel == 101) {
                                int n9 = this.offScreenImage.getRaster().getWidth();
                                int n10 = this.offScreenImage.getRaster().getHeight();
                                int n11 = this.chartInsets.left + n;
                                int n12 = this.chartInsets.top;
                                if (n11 >= 0 && n11 + n8 <= n9 && n12 >= 0 && n12 + this.chartHeight <= n10 && this.chartInsets.left >= 0 && this.chartInsets.left + n8 <= n9 && this.chartInsets.top >= 0 && this.chartInsets.top + this.chartHeight <= n10) {
                                    WritableRaster writableRaster = this.offScreenImage.getRaster().createWritableChild(this.chartInsets.left, this.chartInsets.top, n8, this.chartHeight, 0, 0, null);
                                    this.offScreenImage.getRaster().setDataElements(n11, n12, writableRaster);
                                }
                            } else {
                                graphics2D.copyArea(this.chartInsets.left, this.chartInsets.top, n8, this.chartHeight, n, 0);
                            }
                        }
                        int n13 = this.lastLeadingItemIsForBuffer ? this.getLeadingItemIndex(l, this.lastLeadingItemIndex) : this.getLeadingItemIndex(l);
                        this.drawChartFromOffset(graphics2D, n13, 0, n);
                        this.lastLeadingItemIsForBuffer = true;
                        this.lastLeadingItemIndex = n13;
                    }
                } else {
                    int n = this.lastLeadingItemIsForBuffer ? this.getLeadingItemIndex(l) : this.getLeadingItemIndex(l, this.lastLeadingItemIndex);
                    this.drawChartFromOffset(graphics2D, n, 0, this.chartWidth);
                    this.lastLeadingItemIsForBuffer = false;
                    this.lastLeadingItemIndex = n;
                }
            } else {
                int n = this.getLeadingItemIndex(l);
                this.drawChartFromOffset(graphics2D, n, 0, this.chartWidth);
                this.lastLeadingItemIsForBuffer = false;
                this.lastLeadingItemIndex = n;
            }
        }
        this.lastViewOffsetX = l;
        this.lastViewOffsetXValid = true;
        this.lastScaleXValid = true;
        this.lastScaleYValid = true;
        this.updateTrailingItemVisible();
        graphics2D.setClip(shape);
    }

    private void drawChartFromOffset(Graphics2D graphics2D, int n, int n2, int n3) {
        n2 = Math.max(0, n2);
        n3 = Math.min(this.chartWidth, n3);
        graphics2D.setClip(this.chartInsets.left + n2, this.chartInsets.top, n3 - n2, this.chartHeight);
        int n4 = Integer.MAX_VALUE;
        if (this.limitYValue != Long.MAX_VALUE) {
            n4 = (int)this.getDataToViewY(this.limitYValue, 0);
        }
        if (n4 != Integer.MAX_VALUE && n4 >= this.chartInsets.top) {
            graphics2D.setPaint(this.limitYColor);
            graphics2D.fillRect(this.chartInsets.left + n2, this.chartInsets.top, n3 - n2, n4 - this.chartInsets.top + 1);
            graphics2D.setPaint(this.chartPaint);
            graphics2D.fillRect(this.chartInsets.left + n2, n4 + 1, n3 - n2, this.chartHeight - n4 + this.chartInsets.top);
        } else {
            graphics2D.setPaint(this.chartPaint);
            graphics2D.fillRect(this.chartInsets.left + n2, this.chartInsets.top, n3 - n2, this.chartHeight);
        }
        if (this.model instanceof AsyncMarksProvider) {
            AsyncMarksProvider asyncMarksProvider = (AsyncMarksProvider)((Object)this.model);
            Color color = asyncMarksProvider.getMarkColor();
            int n5 = asyncMarksProvider.getMarksCount();
            int n6 = Integer.MIN_VALUE;
            long l = this.model.getXValue(n);
            for (int i = 0; i < n5; ++i) {
                long l2 = asyncMarksProvider.getMarkEnd(i);
                if (l2 < l) continue;
                long l3 = asyncMarksProvider.getMarkStart(i);
                int n7 = (int)this.getDataToViewX(l3);
                if (n7 > this.chartInsets.left + n3 + 1) break;
                int n8 = Math.max((int)this.getDataToViewX(l2), n7 + 1);
                if (n8 <= n6) continue;
                int n9 = n8 - (n7 = Math.max(n7, n6));
                if (n9 > 0) {
                    graphics2D.setColor(color);
                    graphics2D.fillRect(n7, this.chartInsets.top, n8 - n7, this.chartHeight);
                }
                n6 = n8;
            }
        }
        n = this.type == 1 ? Math.max(0, n - 1) : n;
        for (int i = n + 1; i < this.model.getItemCount(); ++i) {
            long l = this.getDataToViewX(this.model.getXValue(i - 1));
            long l4 = this.getDataToViewX(this.model.getXValue(i));
            for (int j = 0; j < this.model.getSeriesCount(); ++j) {
                this.drawSeriesItem(graphics2D, this.model.getSeriesColor(j), l, this.getDataToViewY(this.model.getYValue(i - 1, j), j), l4, this.getDataToViewY(this.model.getYValue(i, j), j));
            }
            if (l4 > (long)(this.chartInsets.left + n3 + 1)) break;
        }
        this.drawChartLegend(graphics2D, graphics2D.getClip(), n2, n3);
    }

    private void drawChartLegend(Graphics2D graphics2D, Shape shape, int n, int n2) {
        long l = (long)this.getViewToDataApproxWidth(this.viewOffsetX) + this.model.getMinXValue();
        long l2 = (long)this.getViewToDataApproxWidth(this.viewOffsetX + (long)this.chartWidth) + this.model.getMinXValue();
        this.drawHorizontalChartLegend(graphics2D, shape, n, n2, l, l2);
        double d = (double)this.model.getMinDisplayYValue(0) / (double)this.verticalAxisValueDivider;
        double d2 = (double)this.model.getMaxDisplayYValue(0) / (double)this.verticalAxisValueDivider;
        this.drawVerticalChartLegend(graphics2D, shape, n, n2, d, d2);
    }

    private void drawChartLegendEmpty(Graphics2D graphics2D) {
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight);
        Shape shape2 = graphics2D.getClip();
        graphics2D.setPaint(this.chartPaint);
        graphics2D.fillRect(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight);
        this.drawHorizontalChartLegend(graphics2D, shape2, 0, this.chartWidth - 1, this.firstValueH, this.lastValueH);
        this.drawVerticalChartLegend(graphics2D, shape2, 0, this.chartWidth - 1, this.firstValueV, this.lastValueV);
        graphics2D.setClip(shape);
    }

    private void drawFillSeriesItem(Graphics2D graphics2D, Color color, int n, int n2, int n3, int n4) {
        graphics2D.setColor(color);
        graphics2D.setStroke(this.chartStroke);
        if (this.dataType == 50) {
            Polygon polygon = new Polygon(new int[]{n, n, n3, n3}, new int[]{n2, this.chartHeight + this.chartInsets.top, this.chartHeight + this.chartInsets.top, n4}, 4);
            graphics2D.fill(polygon);
        } else if (this.dataType == 51) {
            Polygon polygon = new Polygon(new int[]{n, n, n3, n3}, new int[]{n2, this.chartHeight + this.chartInsets.top, this.chartHeight + this.chartInsets.top, n2}, 4);
            graphics2D.fill(polygon);
        }
    }

    private void drawHorizontalAxisLegendSegment(Graphics2D graphics2D, long l, int n) {
        graphics2D.setClip(this.horizontalAxisMarksClip);
        graphics2D.setPaint(this.horizontalAxisPaint);
        graphics2D.drawLine(n, this.chartInsets.top + this.chartHeight + 1, n, this.chartInsets.top + this.chartHeight + 4);
        graphics2D.setClip(this.horizontalAxisClip);
        this.paintHorizontalTimeMarkString(graphics2D, l, n);
    }

    private void drawHorizontalChartLegend(Graphics2D graphics2D, Shape shape, int n, int n2, long l, long l2) {
        graphics2D.setClip(this.horizontalAxisMarksClip);
        graphics2D.setPaint(this.backgroundPaint);
        graphics2D.fillRect(this.horizontalAxisMarksClip.x, this.horizontalAxisMarksClip.y, this.horizontalAxisMarksClip.width, this.horizontalAxisMarksClip.height);
        graphics2D.setClip(this.horizontalAxisClip);
        graphics2D.setPaint(this.backgroundPaint);
        graphics2D.fillRect(this.horizontalAxisClip.x, this.horizontalAxisClip.y, this.horizontalAxisClip.width, this.horizontalAxisClip.height);
        if (l2 - l > 0L) {
            long l3;
            double d = (double)this.chartWidth / (double)(l2 - l);
            this.optimalUnits = DateTimeAxisUtils.getOptimalUnits(this.viewScaleX);
            for (long i = l3 = Math.max(l / this.optimalUnits * this.optimalUnits, 0L); i <= l2; i += this.optimalUnits) {
                if (i < l) continue;
                long l4 = i - l;
                int n3 = (int)Math.floor((double)l4 * d) + this.chartInsets.left;
                this.drawVerticalMeshSegment(graphics2D, shape, n3, this.chartInsets.top, n3, this.chartInsets.top + this.chartHeight);
                this.drawHorizontalAxisLegendSegment(graphics2D, i, n3);
            }
        }
    }

    private void drawHorizontalMeshSegment(Graphics2D graphics2D, Shape shape, int n, int n2, int n3, int n4) {
        graphics2D.setClip(shape);
        graphics2D.setPaint(this.verticalMeshPaint);
        graphics2D.setStroke(this.verticalMeshStroke);
        graphics2D.drawLine(n, n2, n3, n4);
    }

    private void drawLineSeriesItem(Graphics2D graphics2D, Color color, int n, int n2, int n3, int n4) {
        graphics2D.setColor(color);
        graphics2D.setStroke(this.chartStroke);
        if (this.dataType == 50) {
            graphics2D.drawLine(n, n2, n3, n4);
        } else if (this.dataType == 51) {
            graphics2D.drawLine(n, n2, n3, n2);
            graphics2D.drawLine(n3, n2, n3, n4);
        }
    }

    private void drawSelection(Graphics2D graphics2D) {
        int n = this.insets.top + this.chartInsets.top;
        int n2 = n + this.chartHeight - 1;
        if (this.selectionWidth < 0) {
            if (this.fitToWindow) {
                return;
            }
            Shape shape = graphics2D.getClip();
            Insets insets = this.getInsets();
            graphics2D.setClip(insets.left, insets.top, this.drawWidth, this.drawHeight);
            graphics2D.setFont(this.getFont());
            graphics2D.setColor(this.evenSelectionSegmentsColor);
            graphics2D.setStroke(this.evenSelectionSegmentsStroke);
            graphics2D.drawLine(this.selectionX, n, this.selectionX, n2);
            graphics2D.setColor(this.oddSelectionSegmentColor);
            graphics2D.setStroke(this.oddSelectionSegmentStroke);
            graphics2D.drawLine(this.selectionX, n, this.selectionX, n2);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(FIT_TO_WINDOW_STRING, this.selectionX + this.selectionWidth + 1, this.selectionY + this.selectionHeight + 1 - 5);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(FIT_TO_WINDOW_STRING, this.selectionX + this.selectionWidth, this.selectionY + this.selectionHeight - 5);
            graphics2D.setClip(shape);
            return;
        }
        graphics2D.setColor(this.evenSelectionSegmentsColor);
        graphics2D.setStroke(this.evenSelectionSegmentsStroke);
        graphics2D.drawLine(this.selectionX, n, this.selectionX + this.selectionWidth, n);
        graphics2D.drawLine(this.selectionX + this.selectionWidth, n, this.selectionX + this.selectionWidth, n2);
        graphics2D.drawLine(this.selectionX, n2, this.selectionX + this.selectionWidth, n2);
        graphics2D.drawLine(this.selectionX, n, this.selectionX, n2);
        graphics2D.setColor(this.oddSelectionSegmentColor);
        graphics2D.setStroke(this.oddSelectionSegmentStroke);
        graphics2D.drawLine(this.selectionX, n, this.selectionX + this.selectionWidth, n);
        graphics2D.drawLine(this.selectionX + this.selectionWidth, n, this.selectionX + this.selectionWidth, n2);
        graphics2D.drawLine(this.selectionX, n2, this.selectionX + this.selectionWidth, n2);
        graphics2D.drawLine(this.selectionX, n, this.selectionX, n2);
    }

    private void drawSeriesItem(Graphics2D graphics2D, Color color, long l, long l2, long l3, long l4) {
        if (Math.abs(l) > 1000000L || Math.abs(l3) > 1000000L) {
            l = Math.max(-1000000L, l);
            l = Math.min(1000000L, l);
            l3 = Math.max(-1000000L, l3);
            l3 = Math.min(1000000L, l3);
        }
        if (this.type == 2) {
            this.drawFillSeriesItem(graphics2D, color, (int)l, (int)l2, (int)l3, (int)l4);
        } else if (this.type == 1) {
            this.drawLineSeriesItem(graphics2D, color, (int)l, (int)l2, (int)l3, (int)l4);
        }
    }

    private void drawVerticalAxisLegendSegment(Graphics2D graphics2D, long l, long l2, int n) {
        if ("%".equals(this.verticalAxisValueString) && l > 100L) {
            return;
        }
        graphics2D.setClip(this.verticalAxisClip);
        graphics2D.setPaint(this.verticalAxisPaint);
        graphics2D.drawLine(this.chartInsets.left - 4, n, this.chartInsets.left, n);
        this.paintVerticalTimeMarkString(graphics2D, l, l2, n);
    }

    private void drawVerticalAxisLegendSegment2(Graphics2D graphics2D, long l, long l2, int n) {
        if ("%".equals(this.verticalAxisValueString2) && l > 100L) {
            return;
        }
        graphics2D.setClip(this.verticalAxisClip2);
        graphics2D.setPaint(this.verticalAxisPaint);
        graphics2D.drawLine(this.chartInsets.left + this.chartWidth, n, this.chartInsets.left + this.chartWidth + 3, n);
        this.paintVerticalTimeMarkString2(graphics2D, l, l2, n);
    }

    private void drawVerticalChartLegend(Graphics2D graphics2D, Shape shape, int n, int n2, double d, double d2) {
        int n3;
        double d3;
        long l;
        long l2;
        double d4;
        if (!this.lastScaleYValid) {
            graphics2D.setClip(this.verticalAxisClip);
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fillRect(this.verticalAxisClip.x, this.verticalAxisClip.y, this.verticalAxisClip.width, this.verticalAxisClip.height);
        }
        long l3 = this.verticalAxisValueDivider;
        String string = this.verticalAxisValueString;
        if (this.verticalAxisValueAdaptDivider) {
            if (this.model.getMaxDisplayYValue(0) > 2000000000L && l3 < 0x40000000L) {
                l3 = 0x40000000L;
                this.verticalAxisValueString = "G" + this.verticalAxisValueString;
            } else if (this.model.getMaxDisplayYValue(0) > 2000000L && l3 < 0x100000L) {
                l3 = 0x100000L;
                this.verticalAxisValueString = "M" + this.verticalAxisValueString;
            } else if (this.model.getMaxDisplayYValue(0) > 2000L && l3 < 1024L) {
                l3 = 1024L;
                this.verticalAxisValueString = "K" + this.verticalAxisValueString;
            }
            d /= (double)l3;
            d2 /= (double)l3;
        }
        if (d2 - d > 0.0) {
            d4 = (double)(this.chartHeight - this.topChartMargin) / (d2 - d);
            this.optimalUnits = DecimalAxisUtils.getOptimalUnits(d4, this.minimumVerticalMarksDistance);
            if (this.optimalUnits > 0L) {
                l = l2 = Math.max((long)(Math.ceil(d / (double)this.optimalUnits) * (double)this.optimalUnits), 0L);
                d3 = (double)l - d;
                n3 = this.chartInsets.top + this.chartHeight - (int)(d3 * d4);
                while (n3 >= this.chartInsets.top) {
                    if (n3 <= this.chartInsets.top + this.chartHeight) {
                        this.drawHorizontalMeshSegment(graphics2D, shape, n + this.chartInsets.left, n3, n2 + this.chartInsets.left, n3);
                        if (!this.lastScaleYValid) {
                            this.drawVerticalAxisLegendSegment(graphics2D, l, this.optimalUnits, n3);
                        }
                    }
                    d3 = (double)(l += this.optimalUnits) - d;
                    n3 = this.chartInsets.top + this.chartHeight - (int)(d3 * d4);
                }
            }
        }
        this.verticalAxisValueString = string;
        if (this.useSecondaryVerticalAxis && !this.lastScaleYValid) {
            graphics2D.setClip(this.verticalAxisClip2);
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fillRect(this.verticalAxisClip2.x, this.verticalAxisClip2.y, this.verticalAxisClip2.width, this.verticalAxisClip2.height);
            l3 = this.verticalAxisValueDivider2;
            string = this.verticalAxisValueString2;
            if (this.isVerticalAxisValueAdaptDivider2()) {
                if (this.model.getMaxDisplayYValue(1) > 2000000000L && l3 < 0x40000000L) {
                    l3 = 0x40000000L;
                    this.verticalAxisValueString2 = "G" + this.verticalAxisValueString2;
                } else if (this.model.getMaxDisplayYValue(1) > 2000000L && l3 < 0x100000L) {
                    l3 = 0x100000L;
                    this.verticalAxisValueString2 = "M" + this.verticalAxisValueString2;
                } else if (this.model.getMaxDisplayYValue(1) > 2000L && l3 < 1024L) {
                    l3 = 1024L;
                    this.verticalAxisValueString2 = "K" + this.verticalAxisValueString2;
                }
            }
            d = (double)this.model.getMinDisplayYValue(1) / (double)l3;
            d2 = (double)this.model.getMaxDisplayYValue(1) / (double)l3;
            if (d2 - d > 0.0) {
                d4 = (double)(this.chartHeight - this.topChartMargin) / (d2 - d);
                this.optimalUnits = DecimalAxisUtils.getOptimalUnits(d4, this.minimumVerticalMarksDistance);
                if (this.optimalUnits > 0L) {
                    l = l2 = Math.max((long)(Math.ceil(d / (double)this.optimalUnits) * (double)this.optimalUnits), 0L);
                    d3 = (double)l - d;
                    n3 = this.chartInsets.top + this.chartHeight - (int)(d3 * d4);
                    while (n3 >= this.chartInsets.top) {
                        if (n3 <= this.chartInsets.top + this.chartHeight) {
                            this.drawVerticalAxisLegendSegment2(graphics2D, l, this.optimalUnits, n3);
                        }
                        d3 = (double)(l += this.optimalUnits) - d;
                        n3 = this.chartInsets.top + this.chartHeight - (int)(d3 * d4);
                    }
                }
            }
            this.verticalAxisValueString2 = string;
        }
    }

    private void drawVerticalMeshSegment(Graphics2D graphics2D, Shape shape, int n, int n2, int n3, int n4) {
        graphics2D.setClip(shape);
        graphics2D.setPaint(this.verticalMeshPaint);
        graphics2D.setStroke(this.verticalMeshStroke);
        graphics2D.drawLine(n, n2, n3, n4);
    }

    private void fitToSelection() {
        this.fitToViewRectangle(this.selectionX, this.selectionY, this.selectionWidth, this.selectionHeight);
    }

    private void fitToWindow() {
        this.dataViewWidth = this.chartWidth;
        this.changeZoom((double)this.chartWidth / (double)(this.model.getMaxXValue() - this.dataOffsetX));
        this.lastScaleXValid = false;
        this.changePan(0L);
        this.lastViewOffsetXValid = false;
        this.offScreenImageInvalid = true;
        this.doRepaint(true);
    }

    private void paintHorizontalTimeMarkString(Graphics2D graphics2D, long l, int n) {
        int n2 = this.chartInsets.top + this.chartHeight + this.horizontalAxisFont.getSize() + this.verticalAxisFont.getSize() / 2;
        int n3 = 0;
        int n4 = 2;
        String string = DateTimeAxisUtils.getTimeMarkNoMillisString(l, this.optimalUnits, this.useDayInTimeLegend);
        int n5 = graphics2D.getFontMetrics(this.horizontalAxisFont).stringWidth(string);
        String string2 = DateTimeAxisUtils.getTimeMarkMillisString(l, this.optimalUnits);
        if (!string2.equals("")) {
            string2 = "." + string2;
        }
        int n6 = graphics2D.getFontMetrics(this.horizontalAxisFontSmall).stringWidth(string2);
        int n7 = n - (n5 + n6) / 2 + 1;
        int n8 = n7 + n5 + n3;
        graphics2D.setFont(this.horizontalAxisFont);
        graphics2D.drawString(string, n7, n2);
        graphics2D.setFont(this.horizontalAxisFontSmall);
        graphics2D.drawString(string2, n8, n2 - n4 + 1);
    }

    private void paintVerticalTimeMarkString(Graphics2D graphics2D, long l, long l2, int n) {
        String string = this.getVerticalAxisMarkString(l);
        int n2 = graphics2D.getFontMetrics(this.verticalAxisFont).stringWidth(string);
        int n3 = this.chartInsets.left - n2 - 6;
        int n4 = n + this.verticalAxisFont.getSize() / 2 - 2;
        if (this.useSecondaryVerticalAxis) {
            graphics2D.setPaint(this.model.getSeriesColor(0));
        }
        graphics2D.setFont(this.verticalAxisFont);
        graphics2D.drawString(string, n3, n4);
    }

    private void paintVerticalTimeMarkString2(Graphics2D graphics2D, long l, long l2, int n) {
        if (l > this.model.getMaxDisplayYValue(1)) {
            return;
        }
        String string = this.getVerticalAxisMarkString2(l);
        int n2 = this.chartInsets.left + this.chartWidth + 6;
        int n3 = n + this.verticalAxisFont.getSize() / 2 - 2;
        graphics2D.setPaint(this.model.getSeriesColor(1));
        graphics2D.setFont(this.verticalAxisFont);
        graphics2D.drawString(string, n2, n3);
    }

    private void performSelectionDone() {
        if (this.selectionWidth > 0) {
            this.fitToSelection();
        } else if (this.selectionWidth < 0) {
            this.fitToWindow();
        } else {
            this.doRepaint(false);
        }
    }

    private void updateOffScreenImageSize() {
        this.insets = this.getInsets();
        this.drawWidth = this.getWidth() - this.insets.left - this.insets.right - 1;
        this.drawHeight = this.getHeight() - this.insets.top - this.insets.bottom - 1;
        if (this.drawWidth > 0 && this.drawHeight > 0) {
            this.offScreenImage = (BufferedImage)this.createImage(this.drawWidth + 1, this.drawHeight + 1);
            this.offScreenGraphics = this.offScreenImage.createGraphics();
            this.chartInsets.top = 20;
            if (this.useSecondaryVerticalAxis) {
                this.checkRightChartMargin();
            } else {
                this.chartInsets.right = 0;
            }
            this.chartInsets.bottom = this.horizontalAxisFont.getSize() + this.verticalAxisFont.getSize() / 2 + 8;
            this.chartInsets.left = this.offScreenGraphics.getFontMetrics(this.verticalAxisFont).stringWidth("MMMMM");
            this.chartWidth = this.drawWidth - this.chartInsets.left - this.chartInsets.right;
            this.chartHeight = this.drawHeight - this.chartInsets.top - this.chartInsets.bottom;
            Area area = new Area(new Rectangle(this.chartInsets.left, this.chartInsets.top, this.chartWidth, this.chartHeight));
            Area area2 = new Area(new Rectangle(0, 0, this.drawWidth + 1, this.drawHeight + 1));
            area2.subtract(area);
            this.offScreenGraphics.setPaint(this.backgroundPaint);
            this.offScreenGraphics.fill(area2);
            this.offScreenGraphics.setPaint(this.chartPaint);
            this.offScreenGraphics.fill(area);
            this.offScreenGraphics.setPaint(this.horizontalAxisPaint);
            this.offScreenGraphics.setStroke(this.horizontalAxisStroke);
            this.offScreenGraphics.drawLine(this.chartInsets.left, this.chartInsets.top + this.chartHeight, this.chartInsets.left + this.chartWidth - 1, this.chartInsets.top + this.chartHeight);
            this.offScreenGraphics.setPaint(this.verticalAxisPaint);
            this.offScreenGraphics.setStroke(this.verticalAxisStroke);
            this.offScreenGraphics.drawLine(this.chartInsets.left - 1, this.chartInsets.top, this.chartInsets.left - 1, this.chartInsets.top + this.chartHeight);
            if (this.useSecondaryVerticalAxis) {
                this.offScreenGraphics.drawLine(this.chartInsets.left + this.chartWidth, this.chartInsets.top, this.chartInsets.left + this.chartWidth, this.chartInsets.top + this.chartHeight);
            }
            this.offScreenGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.offScreenGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.offScreenImageInvalid = true;
            this.lastScaleYValid = false;
            this.trailingItemVisible = true;
            this.lastViewOffsetXValid = false;
            this.lastScaleXValid = false;
            this.horizontalAxisMarksClip.setRect(this.chartInsets.left - 1, this.chartInsets.top + this.chartHeight + 1, this.chartWidth + 1, 3.0);
            this.horizontalAxisClip.setRect(5.0, this.chartInsets.top + this.chartHeight + this.verticalAxisFont.getSize() / 2 + 1, this.drawWidth - 10, this.horizontalAxisFont.getSize() + 2);
            this.verticalAxisClip.setRect(0.0, this.chartInsets.top - this.verticalAxisFont.getSize() / 2, this.chartInsets.left - 1, this.chartHeight + this.verticalAxisFont.getSize());
            if (this.useSecondaryVerticalAxis) {
                this.verticalAxisClip2.setRect(this.chartInsets.left + this.chartWidth + 1, this.chartInsets.top - this.verticalAxisFont.getSize() / 2, this.chartInsets.right - 1, this.chartHeight + this.verticalAxisFont.getSize());
            }
            if (this.model != null) {
                this.updateScaleFactors();
            }
            this.doRepaint(false);
        }
    }

    private void updateScaleFactors() {
        long l;
        if (!this.useDayInTimeLegend) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(this.model.getMinXValue()));
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(new Date(this.model.getMaxXValue()));
            if (calendar.get(7) != calendar2.get(7) || calendar.get(2) != calendar2.get(2) || calendar.get(1) != calendar2.get(1)) {
                this.useDayInTimeLegend = true;
            }
        }
        if (this.customizedEmptyAppearance && this.model.getItemCount() < 2) {
            l = this.lastValueH;
            this.dataOffsetX = this.firstValueH;
        } else {
            l = this.model.getMaxXValue();
            this.dataOffsetX = this.model.getMinXValue();
        }
        if (this.fitToWindow) {
            this.dataViewWidth = this.chartWidth;
            this.scaleFactorX = (double)this.chartWidth / (double)(l - this.dataOffsetX);
            this.lastScaleXValid = false;
            this.lastLeadingItemIndex = 0;
            this.trailingItemVisible = false;
            this.changePan(0L);
            this.lastViewOffsetXValid = false;
        } else {
            if (this.viewScaleX == 0.0 && this.chartWidth > 0) {
                this.viewScaleX = (double)this.chartWidth / this.dataWidthAtTrackingEndSwitch;
            }
            this.dataViewWidth = (long)((double)(l - this.dataOffsetX) * this.viewScaleX);
            this.scaleFactorX = this.viewScaleX;
            if (this.trackingEnd && !this.trailingItemVisible) {
                this.changePan((long)(-this.chartWidth) + this.dataViewWidth);
                this.lastViewOffsetXValid = false;
            }
        }
        if (this.fitToWindow) {
            this.changeZoom(this.scaleFactorX);
        } else {
            this.viewScaleX = this.scaleFactorX;
        }
        boolean bl = false;
        for (int i = 0; i < this.model.getSeriesCount(); ++i) {
            long l2 = this.model.getMaxDisplayYValue(i);
            long l3 = this.model.getMinDisplayYValue(i);
            if (this.lastMaxYs[i] != l2) {
                bl = true;
            }
            if (this.lastMinYs[i] != l3) {
                bl = true;
            }
            this.lastMaxYs[i] = l2;
            this.lastMinYs[i] = l3;
            this.dataOffsetsY[i] = l3;
            this.scaleFactorsY[i] = (double)(this.chartHeight - this.topChartMargin) / (double)(l2 - this.dataOffsetsY[i]);
        }
        this.lastScaleYValid = this.lastScaleYValid && !bl;
        this.updateScrollBarValues();
        this.scaleFactorsNeedUpdate = false;
    }

    private void updateScrollBarValues() {
        if (this.scrollBar != null) {
            this.scrollBarLongToIntFactor = this.dataViewWidth > Integer.MAX_VALUE ? 2.147483647E9 / (double)this.dataViewWidth : 1.0;
            int n = this.getIntPosition();
            int n2 = this.getIntExtent();
            int n3 = this.getIntMinimum();
            int n4 = this.getIntMaximum();
            if (this.dataViewWidth <= (long)this.chartWidth) {
                if (this.scrollBar.isEnabled()) {
                    this.scrollBar.setEnabled(false);
                }
            } else {
                if (!this.scrollBar.isEnabled()) {
                    this.scrollBar.setEnabled(true);
                }
                if (!this.scrollBar.getValueIsAdjusting()) {
                    this.internalScrollBarChange = true;
                    this.scrollBar.setUnitIncrement(this.getIntUnitIncrement());
                    this.scrollBar.setBlockIncrement(this.getIntBlockIncrement());
                    this.scrollBar.setValues(n, n2, n3, n4);
                } else {
                    this.scrollBarValuesDirty = true;
                }
            }
        }
    }

    private void updateTrailingItemVisible() {
        long l;
        if (this.trackingEnd) {
            this.trailingItemVisible = false;
        }
        boolean bl = (l = this.getDataToViewX(this.model.getXValue(this.model.getItemCount() - 2))) >= 0L && l <= (long)(this.chartWidth + this.chartInsets.left - 1);
        long l2 = this.getDataToViewX(this.model.getXValue(this.model.getItemCount() - 1));
        boolean bl2 = this.trailingItemVisible = l2 >= 0L && l2 <= (long)(this.chartWidth + this.chartInsets.left - 1);
        if (bl && !this.trailingItemVisible) {
            this.changeTrackingEnd(true);
        }
    }
}

