/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.IconBases;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BiFeature
implements IconBases,
Node.Cookie,
Comparable {
    private static final String TEXT_EXPERT = "setExpert";
    private static final String TEXT_HIDDEN = "setHidden";
    private static final String TEXT_PREFERRED = "setPreferred";
    private static final String TEXT_DISPLAY_NAME = "setDisplayName";
    private static final String TEXT_SHORT_DESCRIPTION = "setShortDescription";
    private String displayName = null;
    private boolean expert = false;
    private boolean hidden = false;
    private String name = null;
    private boolean preferred = false;
    private String shortDescription = null;
    private boolean included = true;
    private String brackets = "]";
    private final BiAnalyser bia;

    public BiFeature(Pattern pattern, BiAnalyser biAnalyser) {
        this(pattern.getName(), biAnalyser);
    }

    BiFeature(String string, String string2, BiAnalyser biAnalyser) {
        this.name = string;
        this.displayName = string2;
        this.bia = biAnalyser;
    }

    protected BiFeature(BiAnalyser biAnalyser) {
        this("beanDescriptor", biAnalyser);
    }

    private BiFeature(String string, BiAnalyser biAnalyser) {
        this(string, null, biAnalyser);
    }

    abstract String getCreationString();

    protected final void setModified() {
        this.bia.setModified();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
        this.setModified();
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean bl) {
        this.expert = bl;
        this.setModified();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
        this.setModified();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean bl) {
        this.preferred = bl;
        this.setModified();
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
        this.setModified();
    }

    abstract String getBracketedName();

    String getBrackets() {
        return this.brackets;
    }

    void setBrackets(String string) {
        this.brackets = string;
        this.setModified();
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean bl) {
        this.included = bl;
        this.setModified();
    }

    public String getToolTip() {
        return this.getName();
    }

    List<String> getCustomizationStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.expert) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_EXPERT).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.hidden) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_HIDDEN).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.preferred) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_PREFERRED).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.displayName != null && this.displayName.trim().length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_DISPLAY_NAME).append(" ( ");
            stringBuffer.append(this.displayName).append(" )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.shortDescription != null && this.shortDescription.trim().length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_SHORT_DESCRIPTION).append(" ( ");
            stringBuffer.append(this.shortDescription).append(" )");
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    void analyzeCustomization(Collection<String> collection) throws GenerateBeanException {
        this.setIncluded(false);
        Iterator<String> iterator = collection.iterator();
        String string = this.getBracketedName();
        String string2 = string + "=new";
        String string3 = string + "." + TEXT_EXPERT;
        String string4 = string + "." + TEXT_HIDDEN;
        String string5 = string + "." + TEXT_PREFERRED;
        String string6 = string + "." + TEXT_DISPLAY_NAME;
        String string7 = string + "." + TEXT_SHORT_DESCRIPTION;
        while (iterator.hasNext()) {
            String string8;
            String string9 = iterator.next();
            if (string9.indexOf(string2) != -1) {
                this.setIncluded(true);
                this.analyzeCreationString(string9);
                continue;
            }
            if (string9.indexOf(string3) != -1) {
                this.setExpert(true);
                continue;
            }
            if (string9.indexOf(string4) != -1) {
                this.setHidden(true);
                continue;
            }
            if (string9.indexOf(string5) != -1) {
                this.setPreferred(true);
                continue;
            }
            if (string9.indexOf(string6) != -1) {
                string8 = BiAnalyser.getArgumentParameter(string9);
                if (string8 == null) continue;
                this.setDisplayName(string8);
                continue;
            }
            if (string9.indexOf(string7) != -1) {
                string8 = BiAnalyser.getArgumentParameter(string9);
                if (string8 == null) continue;
                this.setShortDescription(string8);
                continue;
            }
            this.analyzeCustomizationString(string9);
        }
    }

    abstract String getIconBase(boolean var1);

    abstract void analyzeCreationString(String var1);

    abstract void analyzeCustomizationString(String var1);

    public int compareTo(Object object) {
        if (!(object instanceof BiFeature)) {
            return -1;
        }
        BiFeature biFeature = (BiFeature)object;
        return this.getName().compareToIgnoreCase(biFeature.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Method
    extends BiFeature {
        private ElementHandle<ExecutableElement> element;
        private String varName;
        private String toolTip;
        private String creationString;

        Method(ExecutableElement executableElement, PatternAnalyser patternAnalyser, CompilationInfo compilationInfo, BiAnalyser biAnalyser) throws GenerateBeanException {
            super(executableElement.getSimpleName().toString(), "\"\"", biAnalyser);
            this.element = ElementHandle.create((Element)executableElement);
            this.toolTip = Method.initToolTip(executableElement, compilationInfo);
            this.creationString = Method.initCreationString(executableElement);
        }

        @Override
        String getBracketedName() {
            return "[METHOD_" + this.getName() + "]";
        }

        private static String getTypeClass(TypeMirror typeMirror) {
            TypeKind typeKind = typeMirror.getKind();
            if (typeKind.isPrimitive()) {
                return typeKind.name();
            }
            if (typeKind == TypeKind.ARRAY) {
                return Method.resolveArrayClass((ArrayType)typeMirror);
            }
            if (typeKind == TypeKind.DECLARED) {
                return ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString();
            }
            if (typeKind == TypeKind.ERROR) {
                return ((Object)typeMirror).toString();
            }
            throw new IllegalStateException("Unknown type: " + typeMirror + ", " + (Object)((Object)typeMirror.getKind()));
        }

        private static String resolveArrayClass(ArrayType arrayType) {
            TypeMirror typeMirror = arrayType;
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (typeMirror.getKind() == TypeKind.ARRAY) {
                typeMirror = typeMirror.getComponentType();
                stringBuilder.append("[]");
                ++n;
            }
            return Method.getTypeClass(typeMirror) + stringBuilder;
        }

        @Override
        public String getToolTip() {
            return this.toolTip;
        }

        private static String initToolTip(ExecutableElement executableElement, CompilationInfo compilationInfo) {
            return ElementHeaders.getHeader((Element)executableElement, (CompilationInfo)compilationInfo, (String)"%name%%parameters%");
        }

        ElementHandle<ExecutableElement> getElement() {
            return this.element;
        }

        @Override
        String getCreationString() {
            return this.creationString;
        }

        private static String initCreationString(ExecutableElement executableElement) {
            TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
            String string = "new MethodDescriptor(%1$s.class.getMethod(\"%2$s\", new Class[] {%3$s}))";
            String string2 = ", ";
            StringBuilder stringBuilder = new StringBuilder();
            for (VariableElement variableElement : executableElement.getParameters()) {
                stringBuilder.append(string2).append(Method.getTypeClass(variableElement.asType())).append(".class");
            }
            return String.format(string, typeElement.getQualifiedName(), executableElement.getSimpleName(), stringBuilder.length() == 0 ? stringBuilder : stringBuilder.substring(string2.length()));
        }

        @Override
        String getIconBase(boolean bl) {
            if (bl) {
                return "org/netbeans/modules/beans/resources/bifMethod_S";
            }
            return "org/netbeans/modules/beans/resources/bifMethod_" + (this.isIncluded() ? "S" : "N");
        }

        @Override
        void analyzeCustomizationString(String string) {
        }

        @Override
        void analyzeCreationString(String string) {
        }

        @Override
        void analyzeCustomization(Collection<String> collection) throws GenerateBeanException {
            String string;
            if (this.element != null) {
                string = (String)BiAnalyser.normalizeText(this.getCreationString()).toArray()[0];
                for (String string2 : collection) {
                    int n = string2.indexOf(string);
                    if (n <= -1) continue;
                    this.varName = string2.substring(string2.indexOf("methods[METHOD_") + 15, n - 2);
                    break;
                }
                this.element = null;
            }
            string = this.getName();
            this.setName(this.varName);
            super.analyzeCustomization(collection);
            this.setName(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EventSet
    extends BiFeature
    implements Comparator {
        EventSetPattern pattern;
        private static final String TEXT_UNICAST = "setUnicast";
        private static final String TEXT_IN_DEFAULT = "setInDefaultEventSet";
        private boolean isInDefaultEventSet = true;
        private String creationString;

        EventSet(EventSetPattern eventSetPattern, CompilationInfo compilationInfo, BiAnalyser biAnalyser) throws GenerateBeanException {
            super(eventSetPattern, biAnalyser);
            this.pattern = eventSetPattern;
            this.creationString = this.initCreationString(compilationInfo);
        }

        public boolean isUnicast() {
            return this.pattern.isUnicast();
        }

        public boolean isInDefaultEventSet() {
            return this.isInDefaultEventSet;
        }

        public void setInDefaultEventSet(boolean bl) {
            this.isInDefaultEventSet = bl;
        }

        @Override
        String getBracketedName() {
            return "[EVENT_" + this.getName() + "]";
        }

        public int compare(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        String getCreationString() {
            return this.creationString;
        }

        private String initCreationString(CompilationInfo compilationInfo) throws GenerateBeanException {
            String string = "new EventSetDescriptor ( %1$s.class, \"%2$s\", %3$s.class, new String[] {%4$s}, \"%5$s\", \"%6$s\" )";
            String string2 = ", ";
            StringBuilder stringBuilder = new StringBuilder();
            TypeMirror typeMirror = this.pattern.getType().resolve(compilationInfo);
            TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                stringBuilder.append(string2).append('\"').append(executableElement.getSimpleName()).append('\"');
            }
            return String.format(string, ((TypeElement)this.pattern.getDeclaringClass().resolve(compilationInfo)).getQualifiedName(), this.pattern.getName(), ((Object)this.pattern.getType().resolve(compilationInfo)).toString(), stringBuilder.length() == 0 ? stringBuilder : stringBuilder.substring(string2.length()), ((ExecutableElement)this.pattern.getAddListenerMethod().resolve(compilationInfo)).getSimpleName(), ((ExecutableElement)this.pattern.getRemoveListenerMethod().resolve(compilationInfo)).getSimpleName());
        }

        @Override
        String getIconBase(boolean bl) {
            if (bl) {
                if (this.isUnicast()) {
                    return "org/netbeans/modules/beans/resources/bifEventSetUC_S";
                }
                return "org/netbeans/modules/beans/resources/bifEventSetMC_S";
            }
            if (this.isUnicast()) {
                return "org/netbeans/modules/beans/resources/bifEventSetUC_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifEventSetMC_" + (this.isIncluded() ? "S" : "N");
        }

        @Override
        List<String> getCustomizationStrings() {
            List<String> list = super.getCustomizationStrings();
            StringBuilder stringBuilder = new StringBuilder(100);
            if (this.isUnicast()) {
                stringBuilder.setLength(0);
                stringBuilder.append(TEXT_UNICAST).append(" ( true )");
                list.add(stringBuilder.toString());
            }
            if (!this.isInDefaultEventSet) {
                stringBuilder.setLength(0);
                stringBuilder.append(TEXT_IN_DEFAULT).append(" ( false )");
                list.add(stringBuilder.toString());
            }
            return list;
        }

        @Override
        void analyzeCustomizationString(String string) {
            String string2 = this.getBracketedName();
            String string3 = string2 + "." + TEXT_IN_DEFAULT;
            if (string.indexOf(string3) != -1) {
                this.setInDefaultEventSet(false);
                return;
            }
        }

        @Override
        void analyzeCreationString(String string) {
        }
    }

    public static final class IdxProperty
    extends Property {
        private boolean niGetter;
        private boolean niSetter;
        IdxPropertyPattern pattern;
        private String indexedGetterName;
        private String indexedSetterName;

        IdxProperty(IdxPropertyPattern idxPropertyPattern, CompilationInfo compilationInfo, BiAnalyser biAnalyser) throws GenerateBeanException {
            super(idxPropertyPattern, compilationInfo, biAnalyser);
            this.pattern = idxPropertyPattern;
            this.niGetter = this.hasNiGetter();
            this.niSetter = this.hasNiSetter();
            ElementHandle<ExecutableElement> elementHandle = this.pattern.getIndexedGetterMethod();
            this.indexedGetterName = elementHandle == null ? null : ((ExecutableElement)elementHandle.resolve(compilationInfo)).getSimpleName().toString();
            ElementHandle<ExecutableElement> elementHandle2 = this.pattern.getIndexedSetterMethod();
            this.indexedSetterName = elementHandle2 == null ? null : ((ExecutableElement)elementHandle2.resolve(compilationInfo)).getSimpleName().toString();
        }

        boolean isNiGetter() {
            return this.niGetter;
        }

        void setNiGetter(boolean bl) {
            this.niGetter = this.hasNiGetter() ? bl : false;
            this.setModified();
        }

        boolean isNiSetter() {
            return this.niSetter;
        }

        void setNiSetter(boolean bl) {
            this.niSetter = this.hasNiSetter() ? bl : false;
            this.setModified();
        }

        boolean hasNiGetter() {
            return this.pattern.getGetterMethod() != null;
        }

        boolean hasNiSetter() {
            return this.pattern.getSetterMethod() != null;
        }

        String getCreationString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("new IndexedPropertyDescriptor ( ");
            stringBuffer.append("\"" + this.getName() + "\", ");
            stringBuffer.append(this.getDeclaringClassName() + ".class, ");
            if (this.getGetterName() != null && this.niGetter) {
                stringBuffer.append("\"" + this.getGetterName() + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.getSetterName() != null && this.niSetter) {
                stringBuffer.append("\"" + this.getSetterName() + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.indexedGetterName != null && this.getMode() != 4) {
                stringBuffer.append("\"" + this.indexedGetterName + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.indexedSetterName != null && this.getMode() != 2) {
                stringBuffer.append("\"" + this.indexedSetterName + "\" )");
            } else {
                stringBuffer.append("null )");
            }
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            if (bl) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_S";
            }
            if (this.getMode() == 2) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.getMode() == 4) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCreationString(String string) {
            String[] stringArray = BiAnalyser.getParameters(string);
            if (stringArray.length == 6 && this.getMode() == 1) {
                if (stringArray[4].equals("null")) {
                    this.setMode(4);
                } else if (stringArray[5].equals("null")) {
                    this.setMode(2);
                }
                if (this.hasNiGetter() && stringArray[2].equals("null")) {
                    this.niGetter = false;
                }
                if (this.hasNiGetter() && stringArray[3].equals("null")) {
                    this.niSetter = false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Property
    extends BiFeature {
        private PropertyPattern pattern;
        private static final String TEXT_BOUND = "setBound";
        private static final String TEXT_CONSTRAINED = "setConstrained";
        private static final String TEXT_PROPERTY_EDITOR = "setPropertyEditorClass";
        private boolean bound;
        private boolean constrained;
        private int mode;
        private String propertyEditorClass;
        private String declaringClassName;
        private String getterName;
        private String setterName;

        Property(PropertyPattern propertyPattern, CompilationInfo compilationInfo, BiAnalyser biAnalyser) throws GenerateBeanException {
            super(propertyPattern, biAnalyser);
            this.mode = propertyPattern.getMode();
            this.pattern = propertyPattern;
            TypeElement typeElement = (TypeElement)this.pattern.getDeclaringClass().resolve(compilationInfo);
            this.declaringClassName = typeElement.getQualifiedName().toString();
            ElementHandle<ExecutableElement> elementHandle = this.pattern.getGetterMethod();
            this.getterName = elementHandle == null ? null : ((ExecutableElement)elementHandle.resolve(compilationInfo)).getSimpleName().toString();
            ElementHandle<ExecutableElement> elementHandle2 = this.pattern.getSetterMethod();
            this.setterName = elementHandle2 == null ? null : ((ExecutableElement)elementHandle2.resolve(compilationInfo)).getSimpleName().toString();
        }

        protected final String getDeclaringClassName() {
            return this.declaringClassName;
        }

        protected final String getGetterName() {
            return this.getterName;
        }

        protected final String getSetterName() {
            return this.setterName;
        }

        public boolean isBound() {
            return this.bound;
        }

        @Override
        String getBracketedName() {
            return "[PROPERTY_" + this.getName() + "]";
        }

        public void setBound(boolean bl) {
            this.bound = bl;
            this.setModified();
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        public void setConstrained(boolean bl) {
            this.constrained = bl;
            this.setModified();
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int n) {
            this.mode = n;
            this.setModified();
        }

        public boolean modeChangeable() {
            return this.pattern.getMode() == 1;
        }

        public String getPropertyEditorClass() {
            return this.propertyEditorClass;
        }

        public void setPropertyEditorClass(String string) {
            this.propertyEditorClass = string;
            this.setModified();
        }

        @Override
        String getCreationString() {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("new PropertyDescriptor ( ");
            stringBuilder.append("\"" + this.getName() + "\", ");
            stringBuilder.append(this.declaringClassName + ".class, ");
            if (this.getterName != null && this.getMode() != 4) {
                stringBuilder.append("\"" + this.getterName + "\", ");
            } else {
                stringBuilder.append("null, ");
            }
            if (this.setterName != null && this.getMode() != 2) {
                stringBuilder.append("\"" + this.setterName + "\" )");
            } else {
                stringBuilder.append("null )");
            }
            return stringBuilder.toString();
        }

        @Override
        String getIconBase(boolean bl) {
            if (bl) {
                return "org/netbeans/modules/beans/resources/bifPropertyRW_S";
            }
            if (this.mode == 2) {
                return "org/netbeans/modules/beans/resources/bifPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.mode == 4) {
                return "org/netbeans/modules/beans/resources/bifPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        @Override
        List<String> getCustomizationStrings() {
            List<String> list = super.getCustomizationStrings();
            StringBuilder stringBuilder = new StringBuilder(100);
            if (this.bound) {
                stringBuilder.setLength(0);
                stringBuilder.append(TEXT_BOUND).append(" ( true )");
                list.add(stringBuilder.toString());
            }
            if (this.constrained) {
                stringBuilder.setLength(0);
                stringBuilder.append(TEXT_CONSTRAINED).append(" ( true )");
                list.add(stringBuilder.toString());
            }
            if (this.propertyEditorClass != null && this.propertyEditorClass.trim().length() > 0) {
                stringBuilder.setLength(0);
                stringBuilder.append(TEXT_PROPERTY_EDITOR).append(" ( ");
                stringBuilder.append(this.propertyEditorClass).append(" )");
                list.add(stringBuilder.toString());
            }
            return list;
        }

        @Override
        void analyzeCustomizationString(String string) {
            String string2 = this.getBracketedName();
            String string3 = string2 + "." + TEXT_BOUND;
            String string4 = string2 + "." + TEXT_CONSTRAINED;
            String string5 = string2 + "." + TEXT_PROPERTY_EDITOR;
            if (string.indexOf(string3) != -1) {
                this.setBound(true);
                return;
            }
            if (string.indexOf(string4) != -1) {
                this.setConstrained(true);
                return;
            }
            int n = string.indexOf(string5);
            if (n != -1) {
                String string6 = string.substring(n + string5.length());
                String[] stringArray = BiAnalyser.getParameters(string6);
                if (stringArray.length > 0) {
                    this.setPropertyEditorClass(stringArray[0]);
                }
                return;
            }
        }

        @Override
        void analyzeCreationString(String string) {
            String[] stringArray = BiAnalyser.getParameters(string);
            if (stringArray.length == 4 && this.mode == 1) {
                if (stringArray[2].equals("null")) {
                    this.mode = 4;
                } else if (stringArray[3].equals("null")) {
                    this.mode = 2;
                }
            }
        }
    }

    public static final class Descriptor
    extends BiFeature {
        ElementHandle<TypeElement> element;
        String customizer;
        private String beanName;

        Descriptor(TypeElement typeElement, BiAnalyser biAnalyser) throws GenerateBeanException {
            super(biAnalyser);
            this.element = ElementHandle.create((Element)typeElement);
            this.beanName = typeElement.getQualifiedName().toString();
        }

        String getCreationString() {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("new BeanDescriptor  ( ");
            stringBuilder.append(this.getBeanName() + ".class , ");
            stringBuilder.append(String.valueOf(this.getCustomizer()) + " )");
            return stringBuilder.toString();
        }

        String getIconBase(boolean bl) {
            return "org/netbeans/modules/beans/resources/bifDescriptor";
        }

        void analyzeCustomizationString(String string) {
        }

        void analyzeCreationString(String string) {
            int n = string.indexOf(44);
            int n2 = string.lastIndexOf(41);
            if (n != -1 && n2 != -1 && ++n < n2) {
                this.setCustomizer(string.substring(n, n2));
            } else {
                this.setCustomizer(null);
            }
        }

        String getBracketedName() {
            return this.getName();
        }

        String getBrackets() {
            return "";
        }

        public String getCustomizer() {
            return this.customizer;
        }

        public void setCustomizer(String string) {
            this.customizer = string;
            this.setModified();
        }

        public boolean isIncluded() {
            return true;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

