/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.wsdl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.sql.project.wsdl.ExtensionFilter;

public class DirectoryUtil {
    public static List getFiles(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (DirectoryUtil.dirExists(string)) {
            File file = new File(string);
            String[] stringArray = file.list();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = string + System.getProperty("file.separator") + stringArray[i];
                if (DirectoryUtil.dirExists(string2)) continue;
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    public static void moveTree(File file, File file2, String[] stringArray) {
        ExtensionFilter extensionFilter = new ExtensionFilter(stringArray, false);
        DirectoryUtil.moveFilesInDir(file, file2, extensionFilter, true);
    }

    public static String buildFullPath(String string, String string2) {
        String string3 = ".";
        String string4 = "";
        string4 = string2.startsWith(string3) ? string + string2.substring(1) : (string2.startsWith(System.getProperty("file.separator")) ? string + string2 : string + System.getProperty("file.separator") + string2);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File file2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            DirectoryUtil.copyStream(fileInputStream, fileOutputStream);
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(String string, String string2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            fileInputStream = new FileInputStream(file);
            File file2 = new File(string2, file.getName());
            fileOutputStream = new FileOutputStream(file2);
            DirectoryUtil.copyStream(fileInputStream, fileOutputStream);
        }
        catch (Throwable throwable) {
            try {
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable3) {}
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable4) {}
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fileOutputStream.close();
            return true;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static void copyFilesInDir(File file, File file2, FileFilter fileFilter, boolean bl) {
        if (!file2.exists()) {
            file2.mkdirs();
        }
        File[] fileArray = file.listFiles(fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory() && bl) {
                DirectoryUtil.copyFilesInDir(fileArray[i], new File(file2, fileArray[i].getName()), fileFilter, bl);
                continue;
            }
            DirectoryUtil.copyFile(fileArray[i], new File(file2, fileArray[i].getName()));
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[32768];
        while (n != -1) {
            n = inputStream.read(byArray);
            if (n == -1) continue;
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static void copyStream(Reader reader, Writer writer) throws IOException {
        int n;
        char[] cArray = new char[32768];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.flush();
    }

    public static void copyTree(File file, File file2, String[] stringArray) {
        ExtensionFilter extensionFilter = new ExtensionFilter(stringArray, false);
        DirectoryUtil.copyFilesInDir(file, file2, extensionFilter, true);
    }

    public static boolean createDir(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return file.mkdirs();
        }
        return true;
    }

    public static boolean deleteDir(String string) {
        return DirectoryUtil.deleteDir(new File(string));
    }

    public static boolean deleteDir(File file) {
        return DirectoryUtil.deleteDir(file, true);
    }

    public static boolean deleteDir(File file, boolean bl) {
        if (!file.isDirectory() || !file.exists()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                DirectoryUtil.deleteDir(fileArray[i]);
            }
            fileArray[i].delete();
        }
        if (bl) {
            return file.delete();
        }
        return true;
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile() && file.canRead()) {
            return file.delete();
        }
        return false;
    }

    public static boolean deleteFile(String string, String string2) {
        return DirectoryUtil.deleteFile(string2 + File.separator + string);
    }

    public static boolean dirExists(String string) {
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists() && !file.isDirectory();
    }

    public static boolean moveFile(String string, String string2) {
        char c = System.getProperty("file.separator").charAt(0);
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        String string3 = string2 + c + file.getName();
        File file2 = new File(string3);
        if (file2.exists()) {
            DirectoryUtil.deleteFile(file.getName(), string2);
        }
        DirectoryUtil.createDir(string2);
        if (file.isFile() && file.canRead()) {
            return file.renameTo(new File(string2, file.getName()));
        }
        return false;
    }

    public static boolean moveFile(File file, String string) {
        char c = System.getProperty("file.separator").charAt(0);
        if (!file.exists()) {
            return false;
        }
        String string2 = string + c + file.getName();
        File file2 = new File(string2);
        if (file2.exists()) {
            DirectoryUtil.deleteFile(file.getName(), string);
        }
        DirectoryUtil.createDir(string);
        if (file.isFile() && file.canRead()) {
            return file.renameTo(new File(string, file.getName()));
        }
        return false;
    }

    public static boolean moveFile(String string, String string2, String string3) {
        return DirectoryUtil.moveFile(string2 + File.separator + string, string3);
    }

    public static void moveFilesInDir(File file, File file2, FileFilter fileFilter, boolean bl) {
        char c = System.getProperty("file.separator").charAt(0);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        File[] fileArray = file.listFiles(fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory() && bl) {
                DirectoryUtil.moveFilesInDir(fileArray[i], new File(file2, fileArray[i].getName()), fileFilter, bl);
                continue;
            }
            DirectoryUtil.moveFile(fileArray[i], file2.getAbsolutePath());
        }
    }

    public static List getFilesRecursively(File file, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles(fileFilter);
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (fileArray[i].isDirectory()) {
                arrayList.addAll(DirectoryUtil.getFilesRecursively(fileArray[i], fileFilter));
                continue;
            }
            arrayList.add(fileArray[i]);
        }
        return arrayList;
    }

    public static List getFilesRecursively(File file, String[] stringArray) {
        ExtensionFilter extensionFilter = new ExtensionFilter(stringArray);
        return DirectoryUtil.getFilesRecursively(file, extensionFilter);
    }
}

