/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.sql.project.ui.PackageRootNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class TreeRootNode
extends FilterNode
implements PropertyChangeListener {
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
    private final SourceGroup g;

    public TreeRootNode(SourceGroup sourceGroup) {
        this(DataFolder.findFolder((FileObject)sourceGroup.getRootFolder()), sourceGroup);
    }

    private TreeRootNode(DataFolder dataFolder, SourceGroup sourceGroup) {
        this((Node)new FilterNode(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(VISIBILITY_QUERY_FILTER)), sourceGroup);
    }

    private TreeRootNode(Node node, SourceGroup sourceGroup) {
        super(node, (Children)new PackageFilterChildren(node), (Lookup)new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.singleton((Object)new PathFinder(sourceGroup))}));
        this.g = sourceGroup;
        sourceGroup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup));
    }

    private Image computeIcon(boolean bl, int n) {
        Icon icon = this.g.getIcon(bl);
        if (icon == null) {
            Image image = bl ? super.getOpenedIcon(n) : super.getIcon(n);
            return Utilities.mergeImages((Image)image, (Image)PackageRootNode.PACKAGE_BADGE, (int)7, (int)7);
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return PackageRootNode.icon2image(icon);
    }

    public Image getIcon(int n) {
        return this.computeIcon(false, n);
    }

    public Image getOpenedIcon(int n) {
        return this.computeIcon(true, n);
    }

    public String getName() {
        return this.g.getName();
    }

    public String getDisplayName() {
        return this.g.getDisplayName();
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    private static final class PackageFilterNode
    extends FilterNode {
        public PackageFilterNode(Node node) {
            super(node, (Children)new PackageFilterChildren(node));
        }

        public void setName(String string) {
            if (Utilities.isJavaIdentifier((String)string)) {
                super.setName(string);
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(TreeRootNode.class, (String)"MSG_InvalidPackageName"), 1));
            }
        }
    }

    private static final class PackageFilterChildren
    extends FilterNode.Children {
        public PackageFilterChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            return dataObject instanceof DataFolder ? new PackageFilterNode(node) : super.copyNode(node);
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        private static final long serialVersionUID = 1L;
        private final EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object[] objectArray = this.ell.getListenerList();
            ChangeEvent changeEvent2 = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent2 == null) {
                    changeEvent2 = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent2);
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.ell.add(ChangeListener.class, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.ell.remove(ChangeListener.class, changeListener);
        }
    }

    public static final class PathFinder {
        private final SourceGroup g;

        PathFinder(SourceGroup sourceGroup) {
            this.g = sourceGroup;
        }

        public Node findPath(Node node, Object object) {
            FileObject fileObject;
            if (object instanceof FileObject) {
                fileObject = (FileObject)object;
            } else if (object instanceof DataObject) {
                fileObject = ((DataObject)object).getPrimaryFile();
            } else {
                return null;
            }
            FileObject fileObject2 = this.g.getRootFolder();
            if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
                String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                arrayList.set(arrayList.size() - 1, fileObject.getName());
                try {
                    return NodeOp.findPath((Node)node, Collections.enumeration(arrayList));
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    try {
                        arrayList.set(arrayList.size() - 1, fileObject.getNameExt());
                        return NodeOp.findPath((Node)node, Collections.enumeration(arrayList));
                    }
                    catch (NodeNotFoundException nodeNotFoundException2) {
                        return null;
                    }
                }
            }
            if (fileObject2.equals(fileObject)) {
                return node;
            }
            return null;
        }
    }
}

