/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

final class CloseButtonTabbedPane
extends JTabbedPane {
    private Image closeTabImage;
    private Image closeTabPressedImage;
    private Image closeTabMouseOverImage;
    static final String PROP_CLOSE = "close";
    private int pressedCloseButtonIndex = -1;
    private int mouseOverCloseButtonIndex = -1;
    private boolean draggedOut = false;

    CloseButtonTabbedPane() {
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CloseButtonTabbedPane.this.reset();
            }
        });
        CloseButtonListener.install();
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new CBTPPolicy());
    }

    private Component sel() {
        Component component = this.getSelectedComponent();
        return component == null ? this : component;
    }

    public Component add(Component component) {
        Component component2 = super.add(component);
        if (!(component instanceof UIResource)) {
            String string = component.getName();
            if (string != null) {
                string = string + "  ";
            }
            this.setTitleAt(this.getComponentCount() - 1, string);
        }
        return component2;
    }

    public void setTitleAt(int n, String string) {
        String string2;
        String string3 = string2 = string.indexOf("</html>") != -1 ? Utilities.replaceString((String)string, (String)"</html>", (String)"&nbsp;&nbsp;</html>") : string + "  ";
        if (!string.equals(this.getTitleAt(n))) {
            super.setTitleAt(n, string2);
        }
    }

    private void reset() {
        this.setMouseOverCloseButtonIndex(-1);
        this.setPressedCloseButtonIndex(-1);
        this.draggedOut = false;
    }

    private Rectangle getCloseButtonBoundsAt(int n) {
        Rectangle rectangle = this.getBoundsAt(n);
        if (rectangle == null) {
            return null;
        }
        rectangle = new Rectangle(rectangle);
        CloseButtonTabbedPane.fixGetBoundsAt(rectangle);
        Dimension dimension = this.getSize();
        if (rectangle.x + rectangle.width >= dimension.width || rectangle.y + rectangle.height >= dimension.height) {
            return null;
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        if ((this.isWindowsVistaLaF() || this.isWindowsXPLaF() || this.isWindowsLaF()) && n == this.getSelectedIndex()) {
            rectangle.x -= 3;
            rectangle.y -= 2;
        } else if (this.isWindowsXPLaF() || this.isWindowsLaF() || this.isAquaLaF()) {
            rectangle.x -= 2;
        }
        if (n == this.getTabCount() - 1) {
            if (this.isMetalLaF()) {
                --rectangle.x;
            } else if (this.isAquaLaF()) {
                rectangle.x -= 3;
            }
        }
        return new Rectangle(rectangle.x + rectangle.width - 13, rectangle.y + rectangle.height / 2 - 5, 12, 12);
    }

    private boolean isWindowsVistaLaF() {
        String string = System.getProperty("os.name");
        return string.indexOf("Vista") >= 0 || string.equals("Windows NT (unknown)") && "6.0".equals(System.getProperty("os.version"));
    }

    private boolean isWindowsXPLaF() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return this.isWindowsLaF() && bl != null && bl != false;
    }

    private boolean isWindowsLaF() {
        String string = UIManager.getLookAndFeel().getID();
        return string.endsWith("Windows");
    }

    private boolean isAquaLaF() {
        return "Aqua".equals(UIManager.getLookAndFeel().getID());
    }

    private boolean isMetalLaF() {
        String string = UIManager.getLookAndFeel().getID();
        return "Metal".equals(string);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = this.getCloseButtonBoundsAt(i);
            if (rectangle == null) continue;
            if (i == this.mouseOverCloseButtonIndex || i == this.pressedCloseButtonIndex && this.draggedOut) {
                graphics.drawImage(this.getCloseTabMouseOverImage(), rectangle.x, rectangle.y, this);
                continue;
            }
            if (i == this.pressedCloseButtonIndex) {
                graphics.drawImage(this.getCloseTabPressedImage(), rectangle.x, rectangle.y, this);
                continue;
            }
            graphics.drawImage(this.getCloseTabImage(), rectangle.x, rectangle.y, this);
        }
    }

    private Image getCloseTabImage() {
        if (null == this.closeTabImage) {
            this.closeTabImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_enabled.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_enabled.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_enabled.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_enabled.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_enabled.png"))));
        }
        return this.closeTabImage;
    }

    private Image getCloseTabPressedImage() {
        if (null == this.closeTabPressedImage) {
            this.closeTabPressedImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_pressed.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_pressed.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_pressed.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_pressed.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_pressed.png"))));
        }
        return this.closeTabPressedImage;
    }

    private Image getCloseTabMouseOverImage() {
        if (null == this.closeTabMouseOverImage) {
            this.closeTabMouseOverImage = this.isWindowsVistaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/vista_close_rollover.png") : (this.isWindowsXPLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/xp_close_rollover.png") : (this.isWindowsLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/win_close_rollover.png") : (this.isAquaLaF() ? Utilities.loadImage((String)"org/openide/awt/resources/mac_close_rollover.png") : Utilities.loadImage((String)"org/openide/awt/resources/metal_close_rollover.png"))));
        }
        return this.closeTabMouseOverImage;
    }

    private void setPressedCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.pressedCloseButtonIndex == n) {
            return;
        }
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            JComponent jComponent;
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            if ((jComponent = this._getJComponentAt(this.pressedCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.pressedCloseButtonIndex, jComponent.getToolTipText());
            }
        }
        this.pressedCloseButtonIndex = n;
        if (this.pressedCloseButtonIndex >= 0 && this.pressedCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.pressedCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            this.setMouseOverCloseButtonIndex(-1);
            this.setToolTipTextAt(this.pressedCloseButtonIndex, null);
        }
    }

    private void setMouseOverCloseButtonIndex(int n) {
        Rectangle rectangle;
        if (this.mouseOverCloseButtonIndex == n) {
            return;
        }
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            JComponent jComponent;
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            if ((jComponent = this._getJComponentAt(this.mouseOverCloseButtonIndex)) != null) {
                this.setToolTipTextAt(this.mouseOverCloseButtonIndex, jComponent.getToolTipText());
            }
        }
        this.mouseOverCloseButtonIndex = n;
        if (this.mouseOverCloseButtonIndex >= 0 && this.mouseOverCloseButtonIndex < this.getTabCount()) {
            rectangle = this.getCloseButtonBoundsAt(this.mouseOverCloseButtonIndex);
            if (rectangle != null) {
                this.repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
            }
            this.setPressedCloseButtonIndex(-1);
            this.setToolTipTextAt(this.mouseOverCloseButtonIndex, null);
        }
    }

    private JComponent _getJComponentAt(int n) {
        Component component = this.getComponentAt(n);
        return component instanceof JComponent ? (JComponent)component : null;
    }

    private void fireCloseRequest(Component component) {
        this.firePropertyChange(PROP_CLOSE, null, component);
    }

    static void fixGetBoundsAt(Rectangle rectangle) {
        if (rectangle.y < 0) {
            rectangle.y = -rectangle.y;
        }
        if (rectangle.x < 0) {
            rectangle.x = -rectangle.x;
        }
    }

    static int findTabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            Rectangle rectangle = jTabbedPane.getBoundsAt(i);
            if (rectangle == null) continue;
            rectangle = new Rectangle(rectangle);
            CloseButtonTabbedPane.fixGetBoundsAt(rectangle);
            if (!rectangle.contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        try {
            super.processMouseEvent(mouseEvent);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Exceptions.attachLocalizedMessage((Throwable)arrayIndexOutOfBoundsException, (String)"Suppressed AIOOBE bug in BasicTabbedPaneUI");
            Logger.getAnonymousLogger().log(Level.WARNING, null, arrayIndexOutOfBoundsException);
        }
    }

    protected void fireStateChanged() {
        block2: {
            try {
                super.fireStateChanged();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (Utilities.isMac()) break block2;
                throw arrayIndexOutOfBoundsException;
            }
        }
    }

    private static class CloseButtonListener
    implements AWTEventListener {
        private static boolean installed = false;

        private CloseButtonListener() {
        }

        private static synchronized void install() {
            if (installed) {
                return;
            }
            installed = true;
            Toolkit.getDefaultToolkit().addAWTEventListener(new CloseButtonListener(), 48L);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            Component component;
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (!(aWTEvent.getSource() instanceof Component)) {
                return;
            }
            for (component = (Component)mouseEvent.getSource(); component != null && !(component instanceof CloseButtonTabbedPane); component = component.getParent()) {
            }
            if (component == null) {
                return;
            }
            CloseButtonTabbedPane closeButtonTabbedPane = (CloseButtonTabbedPane)component;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), closeButtonTabbedPane);
            if (mouseEvent.getID() == 500) {
                return;
            }
            int n = CloseButtonTabbedPane.findTabForCoordinate(closeButtonTabbedPane, point.x, point.y);
            Rectangle rectangle = null;
            if (n >= 0) {
                rectangle = closeButtonTabbedPane.getCloseButtonBoundsAt(n);
            }
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, 0, 0);
            }
            switch (mouseEvent.getID()) {
                case 501: {
                    if (!rectangle.contains(point)) break;
                    closeButtonTabbedPane.setPressedCloseButtonIndex(n);
                    closeButtonTabbedPane.draggedOut = false;
                    mouseEvent.consume();
                    return;
                }
                case 502: {
                    if (rectangle.contains(point) && closeButtonTabbedPane.pressedCloseButtonIndex >= 0) {
                        Component component2 = closeButtonTabbedPane.getComponentAt(closeButtonTabbedPane.pressedCloseButtonIndex);
                        closeButtonTabbedPane.reset();
                        closeButtonTabbedPane.fireCloseRequest(component2);
                        mouseEvent.consume();
                        return;
                    }
                    closeButtonTabbedPane.reset();
                    break;
                }
                case 504: {
                    break;
                }
                case 505: {
                    break;
                }
                case 503: {
                    if (rectangle.contains(point)) {
                        closeButtonTabbedPane.setMouseOverCloseButtonIndex(n);
                        closeButtonTabbedPane.draggedOut = false;
                        mouseEvent.consume();
                        return;
                    }
                    if (closeButtonTabbedPane.mouseOverCloseButtonIndex < 0) break;
                    closeButtonTabbedPane.setMouseOverCloseButtonIndex(-1);
                    closeButtonTabbedPane.draggedOut = false;
                    mouseEvent.consume();
                    break;
                }
                case 506: {
                    if (closeButtonTabbedPane.pressedCloseButtonIndex < 0) break;
                    if (closeButtonTabbedPane.draggedOut != !rectangle.contains(point)) {
                        closeButtonTabbedPane.draggedOut = !rectangle.contains(point);
                        closeButtonTabbedPane.repaint(rectangle.x, rectangle.y, rectangle.width + 2 + 6, rectangle.height + 2 + 6);
                    }
                    mouseEvent.consume();
                    return;
                }
            }
        }
    }

    private class CBTPPolicy
    extends FocusTraversalPolicy {
        private CBTPPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getComponentBefore(Container container, Component component) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getFirstComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getLastComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }

        public Component getDefaultComponent(Container container) {
            return CloseButtonTabbedPane.this.sel();
        }
    }
}

