/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.CommonAttributeVisualPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ConnectionPoolOptionalVisualPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceWizardPanel;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

public class CommonAttributePanel
extends ResourceWizardPanel {
    private Component component;
    private ResourceConfigHelper helper;
    private Wizard wizardInfo;
    private String[] groupNames;
    private boolean setupValid = true;
    private String panelType;
    private boolean isConnPool = false;

    public CommonAttributePanel(ResourceConfigHelper resourceConfigHelper, Wizard wizard, String[] stringArray) {
        this.helper = resourceConfigHelper;
        this.wizardInfo = wizard;
        this.groupNames = stringArray;
    }

    public Component getComponent() {
        if (this.component == null) {
            FieldGroup[] fieldGroupArray = new FieldGroup[this.groupNames.length];
            for (int i = 0; i < this.groupNames.length; ++i) {
                fieldGroupArray[i] = FieldGroupHelper.getFieldGroup(this.wizardInfo, this.groupNames[i]);
            }
            if (this.wizardInfo.getName().equals("jdbc-connection-pool")) {
                this.panelType = "_CP_SETTING";
                this.component = new ConnectionPoolOptionalVisualPanel(this, this.helper);
            } else if (this.wizardInfo.getName().equals("jdbc-resource")) {
                this.panelType = "_DS";
                this.component = new CommonAttributeVisualPanel(this, fieldGroupArray, this.panelType, this.helper);
            } else if (this.wizardInfo.getName().equals("persistence-manager-factory-resource")) {
                this.panelType = "_PM";
                this.component = new CommonAttributeVisualPanel(this, fieldGroupArray, this.panelType, this.helper);
            }
            this.setIsConnPool();
        }
        return this.component;
    }

    public boolean isNewResourceSelected() {
        if (this.component == null) {
            return false;
        }
        if (!this.getIsConnPool()) {
            return ((CommonAttributeVisualPanel)this.component).isNewResourceSelected();
        }
        return false;
    }

    public void setInitialFocus() {
        if (this.component != null && !this.getIsConnPool()) {
            ((CommonAttributeVisualPanel)this.component).setInitialFocus();
        }
    }

    public void setPropInitialFocus() {
        if (this.component != null && !this.getIsConnPool()) {
            ((CommonAttributeVisualPanel)this.component).setPropInitialFocus();
        }
    }

    public String getResourceName() {
        return this.wizardInfo.getName();
    }

    public HelpCtx getHelp() {
        if (this.wizardInfo.getName().equals("jdbc-connection-pool")) {
            return new HelpCtx("AS_Wiz_ConnPool_poolSettings");
        }
        if (this.wizardInfo.getName().equals("jdbc-resource")) {
            return new HelpCtx("AS_Wiz_DataSource_general");
        }
        if (this.wizardInfo.getName().equals("persistence-manager-factory-resource")) {
            return new HelpCtx("AS_Wiz_PMF_general");
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public ResourceConfigHelper getHelper() {
        return this.helper;
    }

    public Wizard getWizard() {
        return this.wizardInfo;
    }

    public String getJndiName() {
        CommonAttributeVisualPanel commonAttributeVisualPanel;
        if (!this.getIsConnPool() && (commonAttributeVisualPanel = (CommonAttributeVisualPanel)this.component) != null && commonAttributeVisualPanel.jLabels != null && commonAttributeVisualPanel.jFields != null) {
            for (int i = 0; i < commonAttributeVisualPanel.jLabels.length; ++i) {
                String string = commonAttributeVisualPanel.jLabels[i].getText();
                if (!string.equals(this.bundle.getString("LBL_jndi-name"))) continue;
                return ((JTextField)commonAttributeVisualPanel.jFields[i]).getText();
            }
        }
        return null;
    }

    public boolean isValid() {
        if (!this.setupValid) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidSetup"));
            return false;
        }
        this.setErrorMsg(this.bundle.getString("Empty_String"));
        if (!this.getIsConnPool()) {
            CommonAttributeVisualPanel commonAttributeVisualPanel = (CommonAttributeVisualPanel)this.component;
            if (commonAttributeVisualPanel != null && commonAttributeVisualPanel.jLabels != null && commonAttributeVisualPanel.jFields != null) {
                for (int i = 0; i < commonAttributeVisualPanel.jLabels.length; ++i) {
                    String string;
                    HashSet<String> hashSet;
                    String string2 = commonAttributeVisualPanel.jLabels[i].getText();
                    if (string2.equals(this.bundle.getString("LBL_jndi-name"))) {
                        hashSet = ((JTextField)commonAttributeVisualPanel.jFields[i]).getText();
                        if (hashSet == null || ((String)((Object)hashSet)).length() == 0) {
                            this.setErrorMsg(this.bundle.getString("Err_InvalidJndiName"));
                            return false;
                        }
                        if (!ResourceUtils.isLegalResourceName((String)((Object)hashSet))) {
                            return false;
                        }
                        string = this.helper.getData().getTargetFileObject();
                        if (string == null) continue;
                        if (this.wizardInfo.getName().equals("jdbc-resource")) {
                            if (ResourceUtils.isUniqueFileName((String)((Object)hashSet), (FileObject)string, "jdbc/myDatasource")) continue;
                            this.setErrorMsg(this.bundle.getString("Err_DuplFileJndiName"));
                            return false;
                        }
                        if (!this.wizardInfo.getName().equals("persistence-manager-factory-resource") || ResourceUtils.isUniqueFileName((String)((Object)hashSet), (FileObject)string, "persistence")) continue;
                        this.setErrorMsg(this.bundle.getString("Err_DuplFileJndiName"));
                        return false;
                    }
                    hashSet = new HashSet<String>(Arrays.asList(COMMON_ATTR_INTEGER));
                    if (!hashSet.contains(string2.trim()) || (string = ((JTextField)commonAttributeVisualPanel.jFields[i]).getText()) != null && string.length() != 0) continue;
                    this.setErrorMessage(this.bundle.getString("Err_EmptyValue"), string2);
                    return false;
                }
            }
            if (!this.isNewResourceSelected()) {
                String string;
                if (this.helper.getData().getResourceName().equals("jdbc-resource") && ((string = this.helper.getData().getString("pool-name")) == null || string.trim().equals(""))) {
                    this.setErrorMsg(this.bundle.getString("Err_ChooseOrCreatePool"));
                    return false;
                }
                if (this.helper.getData().getResourceName().equals("persistence-manager-factory-resource")) {
                    if (this.helper.getData().getHolder().hasDSHelper()) {
                        String string3 = this.helper.getData().getHolder().getDSHelper().getData().getString("pool-name");
                        if (string3 == null || string3.trim().equals("")) {
                            this.setErrorMsg(this.bundle.getString("Err_ChooseOrCreatePool"));
                            return false;
                        }
                    } else {
                        String string4 = this.helper.getData().getString("jdbc-resource-jndi-name");
                        if (string4 == null || string4.trim().equals("")) {
                            this.setErrorMsg(this.bundle.getString("Err_ChooseOrCreateDS"));
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public void initData() {
        if (!this.getIsConnPool()) {
            CommonAttributeVisualPanel commonAttributeVisualPanel = (CommonAttributeVisualPanel)this.component;
            commonAttributeVisualPanel.initData();
        }
    }

    public void readSettings(Object object) {
        this.wizDescriptor = (WizardDescriptor)object;
        TemplateWizard templateWizard = (TemplateWizard)object;
        String string = templateWizard.getTargetName();
        FileObject fileObject = ResourceUtils.getResourceDirectory(this.helper.getData().getTargetFileObject());
        this.helper.getData().setTargetFileObject(fileObject);
        if (this.component == null) {
            this.getComponent();
        }
        if (fileObject != null) {
            String string2 = this.helper.getData().getString("jndi-name");
            if (string2 != null && !string2.equals("")) {
                this.helper.getData().setTargetFile(string2);
            } else if (this.wizardInfo.getName().equals("jdbc-resource")) {
                if (this.helper.getData().getString("dynamicPanel").equals("true")) {
                    string = null;
                }
                string = ResourceUtils.createUniqueFileName(string, fileObject, "jdbc/myDatasource");
                this.helper.getData().setTargetFile(string);
            } else if (this.wizardInfo.getName().equals("persistence-manager-factory-resource")) {
                string = ResourceUtils.createUniqueFileName(string, fileObject, "persistence");
                this.helper.getData().setTargetFile(string);
            }
            if (!this.getIsConnPool()) {
                CommonAttributeVisualPanel commonAttributeVisualPanel = (CommonAttributeVisualPanel)this.component;
                commonAttributeVisualPanel.setHelper(this.helper);
            }
        } else {
            this.setupValid = false;
        }
    }

    public boolean isFinishPanel() {
        if (this.isNewResourceSelected()) {
            return false;
        }
        return this.isValid();
    }

    private boolean setupValid() {
        return this.setupValid;
    }

    private void setIsConnPool() {
        this.isConnPool = !this.panelType.equals("_DS") && !this.panelType.equals("_PM");
    }

    private boolean getIsConnPool() {
        return this.isConnPool;
    }
}

