/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.beans;

import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePairsPropertyEditor;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.BaseResourceNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader.SunResourceDataObject;
import org.openide.filesystems.FileObject;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JMSBeanDataNode
extends BaseResourceNode
implements PropertyChangeListener {
    private JMSBean resource = null;

    public JMSBeanDataNode(SunResourceDataObject sunResourceDataObject, JMSBean jMSBean) {
        super(sunResourceDataObject);
        this.resource = jMSBean;
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/sun/ide/resources/ResNodeNodeIcon.gif");
        this.setShortDescription(NbBundle.getMessage(JMSBeanDataNode.class, (String)"DSC_JmsNode"));
        jMSBean.addPropertyChangeListener(this);
        Class<?> clazz = jMSBean.getClass();
        try {
            this.createProperties(jMSBean, Utilities.getBeanInfo(clazz));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected JMSBeanDataNode getJMSBeanDataNode() {
        return this;
    }

    protected JMSBean getJMSBean() {
        return this.resource;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FileObject fileObject = this.getJMSBeanDataNode().getDataObject().getPrimaryFile();
        ResourceUtils.saveNodeToXml(fileObject, this.getBeanGraph());
    }

    public Resources getBeanGraph() {
        String string = this.getJmsResType();
        if (string.equals("javax.jms.Queue") || string.equals("javax.jms.Topic")) {
            return this.resource.getAdminObjectGraph();
        }
        return this.resource.getConnectorGraph();
    }

    public String getJmsResType() {
        return this.resource.getResType();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected void createProperties(Object object, BeanInfo beanInfo) {
        BeanNode.Descriptor descriptor = BeanNode.computeProperties((Object)object, (BeanInfo)beanInfo);
        PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite("extraParams", JMSBeanDataNode.class, NbBundle.getMessage(JMSBeanDataNode.class, (String)"LBL_ExtParams"), NbBundle.getMessage(JMSBeanDataNode.class, (String)"DSC_ExtParams")){

            public Object getValue() {
                return JMSBeanDataNode.this.resource.getExtraParams();
            }

            public void setValue(Object object) {
                if (object instanceof Object[]) {
                    JMSBeanDataNode.this.resource.setExtraParams((Object[])object);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new NameValuePairsPropertyEditor(JMSBeanDataNode.this.resource.getExtraParams());
            }
        };
        Sheet sheet = this.getSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put(descriptor.property);
        set.put((Node.Property)readWrite);
        sheet.put(set);
    }
}

