/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class SchemaTransformPatternSelectionUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    private transient SchemaGenerator.Pattern edp;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private JRadioButton createtype;
    private JLabel existingPatternDescLabel;
    private JLabel existingPatternText;
    private JLabel globalElement;
    private ButtonGroup globalElementGroup;
    private JScrollPane jScrollPane1;
    private JRadioButton multipleGlobalElement;
    private JRadioButton noType;
    private JLabel patternDescText;
    private JLabel patternExampleLabel;
    private JEditorPane patternExamplePane;
    private JLabel reusableType;
    private JLabel selectedPatternDescLabel;
    private JLabel selectedPatternText;
    private JRadioButton singleGlobalElement;
    private ButtonGroup typeGroup;
    private transient ItemListener typeCheckBoxListener;
    private transient ItemListener elementCheckBoxListener;
    private transient SchemaGenerator.Pattern currentPattern;

    public SchemaTransformPatternSelectionUI(SchemaGenerator.Pattern pattern) {
        this.edp = pattern;
        this.initComponents();
        this.patternExamplePane.setActionMap(null);
        this.patternExamplePane.getActions();
        this.patternExamplePane.getEditorKit().getActions();
        this.reset();
    }

    public String getName() {
        return NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)"SchemaTransform_PatternSelection");
    }

    public void reset() {
        this.removeListeners();
        this.initializeUISelection();
        this.addListeners();
    }

    private void addListeners() {
        if (this.elementCheckBoxListener == null) {
            this.elementCheckBoxListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                        SchemaTransformPatternSelectionUI.this.selectPattern(SchemaTransformPatternSelectionUI.this.getSelectedDesignPattern());
                    }
                }
            };
        }
        if (this.typeCheckBoxListener == null) {
            this.typeCheckBoxListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                        SchemaTransformPatternSelectionUI.this.selectPattern(SchemaTransformPatternSelectionUI.this.getSelectedDesignPattern());
                    }
                }
            };
        }
        this.singleGlobalElement.addItemListener(this.elementCheckBoxListener);
        this.createtype.addItemListener(this.elementCheckBoxListener);
    }

    private void removeListeners() {
        this.singleGlobalElement.removeItemListener(this.elementCheckBoxListener);
        this.createtype.removeItemListener(this.elementCheckBoxListener);
    }

    private void initializeUISelection() {
        this.selectInitialDesignPattern(this.edp);
        this.existingPatternText.setText(NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)("LBL_SchemaTransform_" + this.edp.toString())));
    }

    public boolean isSingleGlobalElementSelected() {
        return this.singleGlobalElement.isSelected();
    }

    public void setSingleGlobalElementSelected(boolean bl) {
        this.singleGlobalElement.setSelected(bl);
        this.multipleGlobalElement.setSelected(!bl);
    }

    public boolean isTypeReuseSelected() {
        return this.createtype.isSelected();
    }

    public void setTypeReuseSelected(boolean bl) {
        this.createtype.setSelected(bl);
        this.noType.setSelected(!bl);
    }

    private void selectPattern(SchemaGenerator.Pattern pattern) {
        this.selectedPatternText.setText(NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)("LBL_SchemaTransform_" + pattern.toString())));
        this.patternDescText.setText(NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)("MSG_SchemaTransform_" + pattern.toString() + "_Desc")));
        this.patternExamplePane.setText(NbBundle.getMessage(SchemaTransformPatternSelectionUI.class, (String)("MSG_SchemaTransform_" + pattern.toString() + "_Example")));
        this.patternExamplePane.setCaretPosition(0);
        this.fireChange();
    }

    public SchemaGenerator.Pattern getSelectedDesignPattern() {
        if (this.isSingleGlobalElementSelected() && !this.isTypeReuseSelected()) {
            return SchemaGenerator.Pattern.RUSSIAN_DOLL;
        }
        if (this.isSingleGlobalElementSelected() && this.isTypeReuseSelected()) {
            return SchemaGenerator.Pattern.VENITIAN_BLIND;
        }
        if (!this.isSingleGlobalElementSelected() && !this.isTypeReuseSelected()) {
            return SchemaGenerator.Pattern.SALAMI_SLICE;
        }
        if (!this.isSingleGlobalElementSelected() && this.isTypeReuseSelected()) {
            return SchemaGenerator.Pattern.GARDEN_OF_EDEN;
        }
        return SchemaGenerator.DEFAULT_DESIGN_PATTERN;
    }

    private void selectInitialDesignPattern(SchemaGenerator.Pattern pattern) {
        if (pattern == SchemaGenerator.Pattern.RUSSIAN_DOLL) {
            this.setSingleGlobalElementSelected(true);
            this.setTypeReuseSelected(false);
        } else if (pattern == SchemaGenerator.Pattern.VENITIAN_BLIND) {
            this.setSingleGlobalElementSelected(true);
            this.setTypeReuseSelected(true);
        } else if (pattern == SchemaGenerator.Pattern.SALAMI_SLICE) {
            this.setSingleGlobalElementSelected(false);
            this.setTypeReuseSelected(false);
        } else if (pattern == SchemaGenerator.Pattern.GARDEN_OF_EDEN) {
            this.setSingleGlobalElementSelected(false);
            this.setTypeReuseSelected(true);
        }
        this.selectPattern(pattern);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.globalElementGroup = new ButtonGroup();
        this.typeGroup = new ButtonGroup();
        this.selectedPatternDescLabel = new JLabel();
        this.patternExampleLabel = new JLabel();
        this.selectedPatternText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.patternExamplePane = new JEditorPane(){
            static final long serialVersionUID = 1L;

            protected void processMouseEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }

            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        };
        this.existingPatternDescLabel = new JLabel();
        this.existingPatternText = new JLabel();
        this.singleGlobalElement = new JRadioButton();
        this.multipleGlobalElement = new JRadioButton();
        this.globalElement = new JLabel();
        this.reusableType = new JLabel();
        this.createtype = new JRadioButton();
        this.noType = new JRadioButton();
        this.patternDescText = new JLabel();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/xml/schema/abe/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.selectedPatternDescLabel, (String)resourceBundle.getString("LBL_SchemaTransform_Selected_DesignPattern_Desc"));
        this.selectedPatternDescLabel.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_Selected_DesignPattern_Desc"));
        Mnemonics.setLocalizedText((JLabel)this.patternExampleLabel, (String)resourceBundle.getString("LBL_SchemaTransform_DesignPattern_Example"));
        this.patternExampleLabel.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_DesignPattern_Example"));
        Mnemonics.setLocalizedText((JLabel)this.selectedPatternText, (String)resourceBundle.getString("LBL_SchemaTransform_Selected_DesignPattern_Text"));
        this.jScrollPane1.setMinimumSize(null);
        this.jScrollPane1.setPreferredSize(null);
        this.patternExamplePane.setContentType("text/xml");
        this.patternExamplePane.setEditable(false);
        this.patternExamplePane.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_Example"));
        this.patternExamplePane.setEnabled(false);
        this.patternExamplePane.setMinimumSize(null);
        this.patternExamplePane.setPreferredSize(null);
        this.jScrollPane1.setViewportView(this.patternExamplePane);
        this.patternExamplePane.getAccessibleContext().setAccessibleName(resourceBundle.getString("MSG_SchemaTransform_Example"));
        this.patternExamplePane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("HINT_SchemaTransform_Example"));
        Mnemonics.setLocalizedText((JLabel)this.existingPatternDescLabel, (String)resourceBundle.getString("LBL_SchemaTransform_Existing_DesignPattern_Desc"));
        this.existingPatternDescLabel.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_Existing_DesignPattern_Desc"));
        Mnemonics.setLocalizedText((JLabel)this.existingPatternText, (String)resourceBundle.getString("LBL_SchemaTransform_Existing_DesignPattern_Text"));
        this.globalElementGroup.add(this.singleGlobalElement);
        Mnemonics.setLocalizedText((AbstractButton)this.singleGlobalElement, (String)resourceBundle.getString("LBL_SchemaTransform_SingleGlobalElement"));
        this.singleGlobalElement.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_SingleGlobalElement"));
        this.singleGlobalElement.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.singleGlobalElement.setMargin(new Insets(0, 0, 0, 0));
        this.globalElementGroup.add(this.multipleGlobalElement);
        Mnemonics.setLocalizedText((AbstractButton)this.multipleGlobalElement, (String)resourceBundle.getString("LBL_SchemaTransform_MultipleGlobalElement"));
        this.multipleGlobalElement.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_MultipleGlobalElement"));
        this.multipleGlobalElement.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.multipleGlobalElement.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.globalElement, (String)resourceBundle.getString("LBL_SchemaTransform_GlobalElement"));
        this.globalElement.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_GlobalElement"));
        Mnemonics.setLocalizedText((JLabel)this.reusableType, (String)resourceBundle.getString("LBL_SchemaTransform_Type"));
        this.reusableType.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_Type"));
        this.typeGroup.add(this.createtype);
        Mnemonics.setLocalizedText((AbstractButton)this.createtype, (String)resourceBundle.getString("LBL_SchemaTransform_ReusableTypes"));
        this.createtype.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_ReusableTypes"));
        this.createtype.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createtype.setMargin(new Insets(0, 0, 0, 0));
        this.typeGroup.add(this.noType);
        Mnemonics.setLocalizedText((AbstractButton)this.noType, (String)resourceBundle.getString("LBL_SchemaTransform_No_ReusableTypes"));
        this.noType.setToolTipText(resourceBundle.getString("HINT_SchemaTransform_No_ReusableTypes"));
        this.noType.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noType.setMargin(new Insets(0, 0, 0, 0));
        this.patternDescText.setHorizontalAlignment(2);
        this.patternDescText.setVerticalAlignment(1);
        this.patternDescText.setMaximumSize(new Dimension(333333, 333333));
        this.patternDescText.setMinimumSize(null);
        this.patternDescText.setPreferredSize(null);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 505, Short.MAX_VALUE).add(1, (Component)this.patternDescText, -1, 505, Short.MAX_VALUE).add(1, (Component)this.globalElement).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.singleGlobalElement).add(1, (Component)this.multipleGlobalElement))).add(1, (Component)this.reusableType).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.noType).add((Component)this.createtype))).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.selectedPatternDescLabel).addPreferredGap(0).add((Component)this.selectedPatternText).add(35, 35, 35).add((Component)this.existingPatternDescLabel).addPreferredGap(0).add((Component)this.existingPatternText)).add(1, (Component)this.patternExampleLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.globalElement).addPreferredGap(0).add((Component)this.singleGlobalElement).add(7, 7, 7).add((Component)this.multipleGlobalElement).add(6, 6, 6).add((Component)this.reusableType).addPreferredGap(0).add((Component)this.createtype).addPreferredGap(0).add((Component)this.noType).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.selectedPatternDescLabel).add((Component)this.selectedPatternText).add((Component)this.existingPatternDescLabel).add((Component)this.existingPatternText)).addPreferredGap(0).add((Component)this.patternDescText, -2, 72, -2).addPreferredGap(0).add((Component)this.patternExampleLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 95, -2).add(29, 29, 29)));
        this.patternDescText.getAccessibleContext().setAccessibleName(resourceBundle.getString("MSG_SchemaTransform_Desc"));
        this.patternDescText.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("HINT_SchemaTransform_Desc"));
    }
}

