/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe.nodes.properties;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.schema.abe.nodes.properties.NamespacePanel;
import org.netbeans.modules.xml.schema.abe.nodes.properties.StringEditor;
import org.netbeans.modules.xml.schema.model.Schema;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class NamespaceEditor
extends StringEditor {
    private String typeDisplayName;
    private String property;
    private String initialUri;
    private Collection<String> uris;
    private Collection<Option> options;

    public NamespaceEditor(AXIComponent aXIComponent, String string, String string2) {
        this.typeDisplayName = string;
        this.property = string2;
        this.options = new ArrayList<Option>();
        if (aXIComponent.getPeer() instanceof Schema) {
            Schema schema = (Schema)aXIComponent.getPeer();
            this.initialUri = schema.getTargetNamespace();
            this.uris = new ArrayList<String>();
            for (String string3 : schema.getPrefixes().values()) {
                if (this.uris.contains(string3)) continue;
                this.uris.add(string3);
            }
            this.options.add(Option.None);
            this.options.add(Option.Declared);
            this.options.add(Option.Other);
        }
    }

    public Component getCustomEditor() {
        final NamespacePanel namespacePanel = new NamespacePanel(this.initialUri, this.uris, this.options);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)namespacePanel, NbBundle.getMessage(NamespaceEditor.class, (String)"LBL_Custom_Property_Editor_Title", (Object)this.typeDisplayName, (Object)this.property), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    try {
                        NamespaceEditor.this.setValue(namespacePanel.getCurrentSelection());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), illegalArgumentException.getLocalizedMessage(), null, new Date());
                        throw illegalArgumentException;
                    }
                }
            }
        });
        namespacePanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("validSelection")) {
                    dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                }
            }
        });
        namespacePanel.checkValidity();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        return dialog;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        None,
        Declared,
        Other,
        TargetNamespace,
        Local;

    }
}

