/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.abe;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIContainer;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.schema.abe.ABEBaseDropPanel;
import org.netbeans.modules.xml.schema.abe.InplaceEditableLabel;
import org.netbeans.modules.xml.schema.abe.InputValidator;
import org.netbeans.modules.xml.schema.abe.InstanceDesignConstants;
import org.netbeans.modules.xml.schema.abe.InstanceUIContext;
import org.netbeans.modules.xml.schema.abe.ModelEventMediator;
import org.netbeans.modules.xml.schema.abe.StartTagPanel;
import org.netbeans.modules.xml.schema.abe.TagPanel;
import org.netbeans.modules.xml.schema.abe.UIUtilities;
import org.netbeans.modules.xml.schema.abe.UIVisitor;
import org.netbeans.modules.xml.schema.abe.nodes.ABEAbstractNode;
import org.netbeans.modules.xml.schema.abe.nodes.AttributeNode;
import org.netbeans.modules.xml.schema.abe.palette.DnDHelper;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.openide.util.NbBundle;

public class AttributePanel
extends ABEBaseDropPanel {
    private static final long serialVersionUID = 7526472295622776147L;
    private static final Border normalBorder = new EmptyBorder(2, 2, 2, 2);
    private static final Border selectedBorder = new LineBorder(InstanceDesignConstants.XP_ORANGE, 2);
    Color attrColor = InstanceDesignConstants.ATTRIBUTE_COLOR;
    Color attrBGColor = InstanceDesignConstants.NO_BACKGROUND_COLOR;
    private static final int ATTR_HEIGHT = TagPanel.getTagHeight() - 10;
    private static final int INTER_LABEL_SPACE = 5;
    public static final int HEAD_ROOM_SPACE = AttributePanel.getAttributePanelHeight() / 2 - 11;
    private JLabel equals;
    private StartTagPanel startTagPanel;
    private AbstractAttribute attribute;
    private InplaceEditableLabel attributeNameLabel;
    private InplaceEditableLabel attributeValueLabel;
    private AttributeNode attributeNode;

    public AttributePanel(StartTagPanel startTagPanel, AbstractAttribute abstractAttribute, InstanceUIContext instanceUIContext) {
        super(instanceUIContext);
        this.startTagPanel = startTagPanel;
        this.attribute = abstractAttribute;
        this.initialize();
        abstractAttribute.addPropertyChangeListener((PropertyChangeListener)new ModelEventMediator(this, (AXIComponent)abstractAttribute){

            public void _propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("name") || string.equals("type")) {
                    AttributePanel.this.attributePropertyChangeAction(propertyChangeEvent);
                }
            }
        });
        this.initKeyListener();
        this.addSelectionListener();
        this.makeNBNode();
    }

    protected void initMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                AttributePanel.this.mouseClickedActionHandler(mouseEvent, true);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                AttributePanel.this.mouseClickedActionHandler(mouseEvent, true);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                AttributePanel.this.mouseClickedActionHandler(mouseEvent, false);
            }
        });
    }

    private void initialize() {
        String string;
        String string2;
        this.setLayout(new FlowLayout(1, 1, HEAD_ROOM_SPACE));
        AbstractAttribute abstractAttribute = this.getAttribute();
        boolean bl = abstractAttribute.isShared();
        boolean bl2 = abstractAttribute.isReadOnly();
        String string3 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_VALUE");
        String string4 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_NAME");
        String string5 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR");
        this.setOpaque(false);
        this.setBorder(normalBorder);
        if (bl || abstractAttribute.isGlobal()) {
            this.attrBGColor = InstanceDesignConstants.ATTR_BG_SHARED_COLOR;
            this.setBackground(this.attrBGColor);
            this.setOpaque(true);
            this.attrColor = InstanceDesignConstants.ATTRIBUTE_COLOR;
            if (abstractAttribute.isGlobal()) {
                string3 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_VALUE_GLOBAL");
                string4 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_NAME_GLOBAL");
                string5 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_GLOBAL");
            } else if (abstractAttribute.getContentModel() != null) {
                string2 = abstractAttribute.getContentModel().getName();
                string = abstractAttribute.getContentModel().getType().equals((Object)ContentModel.ContentModelType.ATTRIBUTE_GROUP) ? "LBL_GLOBAL_ATTRIBUTE_GROUP" : "LBL_GLOBAL_COMPLEX_TYPE";
                string = NbBundle.getMessage(AttributePanel.class, (String)string);
                string3 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_VALUE_SHARED", (Object)string, (Object)string2);
                string4 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_NAME_SHARED", (Object)string, (Object)string2);
                string5 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_SHARED", (Object)string, (Object)string2);
            } else {
                string2 = abstractAttribute.getParentElement().getName();
                string3 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_VALUE_SHARED_NO_CM", (Object)string2);
                string4 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_NAME_SHARED_NO_CM", (Object)string2);
                string5 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_SHARED_NO_CM", (Object)string2);
            }
        }
        if (bl2) {
            this.attrBGColor = InstanceDesignConstants.ATTR_BG_READONLY_COLOR;
            this.setBackground(this.attrBGColor);
            this.setOpaque(true);
            this.attrColor = InstanceDesignConstants.TAG_NAME_READONLY_COLOR;
            string3 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_VALUE_READONLY");
            string4 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_LABEL_NAME_READONLY");
            string5 = NbBundle.getMessage(AttributePanel.class, (String)"TTP_ATTR_READONLY");
        }
        this.setToolTipText(string5);
        this.attributeNameLabel = new InplaceEditableLabel(abstractAttribute.getName());
        this.attributeNameLabel.setForeground(this.attrColor);
        this.attributeNameLabel.setToolTipText(string4);
        this.add(this.attributeNameLabel);
        this.equals = new JLabel(" = ");
        this.equals.setForeground(this.attrColor);
        this.equals.setToolTipText(string5);
        this.add(this.equals);
        this.equals.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                AttributePanel.this.dispatchEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                AttributePanel.this.dispatchEvent(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                AttributePanel.this.dispatchEvent(mouseEvent);
            }
        });
        string2 = "?";
        if (abstractAttribute instanceof Attribute && (string = (Attribute)abstractAttribute).getType() != null) {
            string2 = string.getType().getName();
        }
        this.attributeValueLabel = new InplaceEditableLabel(string2);
        this.attributeValueLabel.setForeground(this.attrColor);
        this.attributeValueLabel.setToolTipText(string3);
        this.add(this.attributeValueLabel);
        this.refreshAttributeParameters();
        this.initAttributeEditListeners();
        this.initMouseListener();
    }

    protected void initKeyListener() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 113) {
                    AttributePanel.this.attributeNameLabel.showEditor();
                }
                if (AttributePanel.this.context.getFocusTraversalManager().isFocusChangeEvent(keyEvent)) {
                    AttributePanel.this.context.getFocusTraversalManager().handleEvent(keyEvent, AttributePanel.this);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == ' ') {
                    AttributePanel.this.attributeNameLabel.showEditor();
                }
            }
        });
    }

    protected void mouseClickedActionHandler(MouseEvent mouseEvent, boolean bl) {
        if (mouseEvent.getClickCount() == 1) {
            if (mouseEvent.isPopupTrigger()) {
                this.context.getMultiComponentActionManager().showPopupMenu(mouseEvent, (ABEBaseDropPanel)this);
                return;
            }
            if (bl) {
                return;
            }
            if (mouseEvent.isControlDown()) {
                this.context.getComponentSelectionManager().addToSelectedComponents(this);
            } else {
                this.context.getComponentSelectionManager().setSelectedComponent(this);
            }
        }
    }

    public AbstractAttribute getAttribute() {
        return this.attribute;
    }

    public void refreshAttributeParameters() {
        Attribute attribute;
        this.attributeNameLabel.setText(this.getAttribute().toString());
        String string = "?";
        AbstractAttribute abstractAttribute = this.getAttribute();
        if (abstractAttribute instanceof Attribute && (attribute = (Attribute)abstractAttribute).getType() != null) {
            string = attribute.getType().getName();
        }
        this.attributeValueLabel.setText(string);
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, AttributePanel.getAttributePanelHeight());
    }

    private void initAttributeEditListeners() {
        this.initAttributeNameEditListener();
        this.initAttributeValueEditListener();
    }

    protected void initAttributeNameEditListener() {
        this.attributeNameLabel.addCtrlClickHandler(new InplaceEditableLabel.CtrlClickHandler(){

            public void handleCtrlClick() {
                AttributePanel.this.getNBNode().showSuperDefinition();
            }
        });
        this.attributeNameLabel.setInputValidator(new InputValidator(){

            public boolean isStringValid(String string) {
                return Utils.isValidNCName((String)string);
            }
        }, NbBundle.getMessage(AttributePanel.class, (String)"MSG_NOT_A_NCNAME"));
        this.attributeNameLabel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("PROPERTY_MODE_CHANGE") && propertyChangeEvent.getNewValue() == InplaceEditableLabel.Mode.EDIT) {
                    String string;
                    final JTextField jTextField = new JTextField(AttributePanel.this.getAttribute().toString());
                    jTextField.select(0, jTextField.getText().length());
                    jTextField.addActionListener(new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = jTextField.getText();
                            if (Utils.isValidNCName((String)string)) {
                                jTextField.setCursor(new Cursor(3));
                                try {
                                    if (AttributePanel.this.firstTimeRename) {
                                        AttributePanel.this.getNBNode().setNameInModel(string);
                                    } else {
                                        AttributePanel.this.setAttrNameInModel(string);
                                    }
                                    AttributePanel.this.firstTimeRename = false;
                                }
                                finally {
                                    jTextField.setCursor(new Cursor(0));
                                }
                            }
                        }
                    });
                    if (AttributePanel.this.attribute.isShared() || AttributePanel.this.attribute.isGlobal()) {
                        string = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_SHARED_ATTRIBUTE_EDIT");
                        AttributePanel.this.attributeNameLabel.setEditInfoText(string, AttributePanel.this.context);
                    }
                    if (!AttributePanel.this.attribute.isReadOnly()) {
                        if (AttributePanel.this.attribute instanceof AnyAttribute) {
                            string = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_ANY_ATTRIBUTE_EDIT");
                            AttributePanel.this.attributeNameLabel.setEditInfoText(string, AttributePanel.this.context);
                        } else {
                            AttributePanel.this.attributeNameLabel.setInlineEditorComponent(jTextField);
                        }
                    } else {
                        string = NbBundle.getMessage(StartTagPanel.class, (String)"MSG_READONLY_ATTRIBUTE_EDIT");
                        AttributePanel.this.attributeNameLabel.setEditInfoText(string, AttributePanel.this.context);
                    }
                }
            }
        });
    }

    protected void initAttributeValueEditListener() {
        this.attributeValueLabel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("PROPERTY_MODE_CHANGE") && propertyChangeEvent.getNewValue() == InplaceEditableLabel.Mode.EDIT) {
                    AttributePanel.this.attributeValueLabel.hideEditor();
                }
            }
        });
    }

    private void setAttrNameInModel(String string) {
        this.getNBNode().setName(string);
    }

    private void setAttrValueInModel(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute() {
        AXIContainer aXIContainer = this.startTagPanel.getElementPanel().getAXIContainer();
        AXIModel aXIModel = aXIContainer.getModel();
        if (aXIModel != null) {
            aXIModel.startTransaction();
            try {
                aXIContainer.removeAttribute(this.attribute);
            }
            finally {
                aXIModel.endTransaction();
            }
        }
    }

    private void attributePropertyChangeAction(PropertyChangeEvent propertyChangeEvent) {
        this.refreshAttributeParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttributeToAttrGrp() {
        ContentModel contentModel = this.getAttribute().getContentModel();
        AXIModel aXIModel = this.context.getAXIModel();
        aXIModel.startTransaction();
        try {
            Attribute attribute = aXIModel.getComponentFactory().createAttribute();
            String string = UIUtilities.getUniqueName("newAttribute", (AXIComponent)contentModel);
            attribute.setName(string);
            contentModel.addAttribute((AbstractAttribute)attribute);
        }
        finally {
            aXIModel.endTransaction();
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.removeDragFeedback();
        ContentModel contentModel = this.getAttribute().getContentModel();
        if (contentModel != null && contentModel.getType() == ContentModel.ContentModelType.ATTRIBUTE_GROUP) {
            this.addAttributeToAttrGrp();
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DnDHelper.PaletteItem paletteItem = DnDHelper.getDraggedPaletteItem(dropTargetDragEvent);
        if (paletteItem != DnDHelper.PaletteItem.ATTRIBUTE) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        ContentModel contentModel = this.getAttribute().getContentModel();
        if (contentModel != null && contentModel.getType() == ContentModel.ContentModelType.ATTRIBUTE_GROUP) {
            return;
        }
        dropTargetDragEvent.rejectDrag();
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Object object;
        DnDHelper.PaletteItem paletteItem = DnDHelper.getDraggedPaletteItem(dropTargetDragEvent);
        if (paletteItem != DnDHelper.PaletteItem.ATTRIBUTE) {
            object = NbBundle.getMessage(AttributePanel.class, (String)"MSG_ATTRIBUTE_PANEL_DROP_REJECT_WRONG_COMPONENT", (Object)this.attribute.getName());
            UIUtilities.showErrorMessageFor((String)object, this.context, this);
            dropTargetDragEvent.rejectDrag();
        }
        this.setDragFeedback();
        object = this.getAttribute().getContentModel();
        if (object != null && object.getType() == ContentModel.ContentModelType.ATTRIBUTE_GROUP) {
            String string = NbBundle.getMessage(AttributePanel.class, (String)"MSG_ATTRIBUTE_PANEL_DROP_ACCEPT", (Object)this.getAttribute().getContentModel().getName());
            UIUtilities.showBulbMessageFor(string, this.context, this);
            return;
        }
        String string = NbBundle.getMessage(AttributePanel.class, (String)"MSG_ATTRIBUTE_PANEL_DROP_REJECT", (Object)this.attribute.getName());
        UIUtilities.showErrorMessageFor(string, this.context, this);
        dropTargetDragEvent.rejectDrag();
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.removeDragFeedback();
    }

    public void setDragFeedback() {
        this.setBackground(InstanceDesignConstants.DARK_BLUE);
        this.setOpaque(true);
        this.attributeNameLabel.setForeground(Color.WHITE);
        this.attributeValueLabel.setForeground(Color.WHITE);
        this.equals.setForeground(Color.WHITE);
        this.setBorder(new LineBorder(InstanceDesignConstants.DARK_BLUE, 2));
        this.revalidate();
    }

    public void removeDragFeedback() {
        UIUtilities.hideGlassMessage();
        if (this.attrBGColor == InstanceDesignConstants.NO_BACKGROUND_COLOR) {
            this.setOpaque(false);
        } else {
            this.setBackground(this.attrBGColor);
        }
        this.attributeNameLabel.setForeground(this.attrColor);
        this.attributeValueLabel.setForeground(this.attrColor);
        this.equals.setForeground(this.attrColor);
        this.setBorder(normalBorder);
        this.revalidate();
    }

    void showEditorForName(boolean bl) {
        this.firstTimeRename = bl;
        this.attributeNameLabel.showEditor();
    }

    public static int getAttributePanelHeight() {
        return ATTR_HEIGHT;
    }

    protected void makeNBNode() {
        this.attributeNode = new AttributeNode(this.attribute, this.context);
        if (this.attribute.isReadOnly()) {
            this.attributeNode.setReadOnly(true);
        }
    }

    public ABEAbstractNode getNBNode() {
        return this.attributeNode;
    }

    public AXIComponent getAXIComponent() {
        return this.attribute;
    }

    private void addSelectionListener() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("SELECTED")) {
                    if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                        AttributePanel.this.attributeNameLabel.setForeground(Color.BLACK);
                        AttributePanel.this.attributeValueLabel.setForeground(Color.BLACK);
                        AttributePanel.this.equals.setForeground(Color.BLACK);
                        AttributePanel.this.setBorder(selectedBorder);
                        AttributePanel.this.revalidate();
                    } else {
                        AttributePanel.this.attributeNameLabel.setForeground(AttributePanel.this.attrColor);
                        AttributePanel.this.attributeValueLabel.setForeground(AttributePanel.this.attrColor);
                        AttributePanel.this.equals.setForeground(AttributePanel.this.attrColor);
                        AttributePanel.this.setBorder(normalBorder);
                        AttributePanel.this.revalidate();
                    }
                }
            }
        });
    }

    public void accept(UIVisitor uIVisitor) {
        uIVisitor.visit(this);
    }
}

