/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.spi.tasklist.TaskScanningScope;

class ScopeButton
extends JToggleButton
implements PropertyChangeListener {
    private TaskManagerImpl tm;
    private TaskScanningScope scope;

    public ScopeButton(TaskManagerImpl taskManagerImpl, TaskScanningScope taskScanningScope) {
        this.tm = taskManagerImpl;
        this.scope = taskScanningScope;
        this.setText(null);
        this.setIcon(new ImageIcon(Accessor.getIcon(taskScanningScope)));
        this.setToolTipText(Accessor.getDescription(taskScanningScope));
        this.setSelected(taskScanningScope.equals(taskManagerImpl.getScope()));
        this.setFocusable(false);
    }

    public void addNotify() {
        super.addNotify();
        this.tm.addPropertyChangeListener("taskScanningScope", this);
        this.setSelected(this.scope.equals(this.tm.getScope()));
    }

    public void removeNotify() {
        super.removeNotify();
        this.tm.removePropertyChangeListener("taskScanningScope", this);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        super.fireActionPerformed(actionEvent);
        this.switchScope();
    }

    private void switchScope() {
        if (this.scope.equals(this.tm.getScope())) {
            this.setSelected(true);
            return;
        }
        this.tm.observe(this.scope, this.tm.getFilter());
        this.setSelected(true);
        Settings.getDefault().setActiveScanningScope(this.scope);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setSelected(this.scope.equals(this.tm.getScope()));
    }
}

