/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl.references;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.bpel.model.xam.spi.ExternalModelRetriever;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalModelRetrieverImpl
implements ExternalModelRetriever {
    @Override
    public Collection<WSDLModel> getWSDLModels(BpelModel bpelModel, String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<WSDLModel> linkedList = new LinkedList<WSDLModel>();
        this.collectWsdlModelsViaImports(bpelModel, string, linkedList);
        return linkedList;
    }

    @Override
    public Collection<SchemaModel> getSchemaModels(BpelModel bpelModel, String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<SchemaModel> linkedList = new LinkedList<SchemaModel>();
        this.collectShemaModelsViaImports(bpelModel, string, linkedList);
        return linkedList;
    }

    private void collectWsdlModelsViaImports(BpelModel bpelModel, String string, List<WSDLModel> list) {
        Import[] importArray;
        for (Import import_ : importArray = bpelModel.getProcess().getImports()) {
            WSDLModel wSDLModel;
            if (!string.equals(import_.getNamespace()) || (wSDLModel = ImportHelper.getWsdlModel(import_)) == null || wSDLModel.getState() != Model.State.VALID) continue;
            list.add(wSDLModel);
        }
    }

    private void collectShemaModelsViaImports(BpelModel bpelModel, String string, List<SchemaModel> list) {
        Import[] importArray;
        for (Import import_ : importArray = bpelModel.getProcess().getImports()) {
            SchemaModel schemaModel;
            if ("http://schemas.xmlsoap.org/wsdl/".equals(import_.getImportType()) && (schemaModel = ImportHelper.getInlineSchema(import_, string)) != null) {
                list.addAll((Collection<SchemaModel>)schemaModel);
            }
            if (!string.equals(import_.getNamespace()) || (schemaModel = ImportHelper.getSchemaModel(import_)) == null || schemaModel.getState() != Model.State.VALID) continue;
            list.add(schemaModel);
        }
    }
}

