/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.impl.BpelEntityImpl;
import org.netbeans.modules.bpel.model.impl.PreferredNsPrefixes;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;
import org.netbeans.modules.xml.xpath.ext.schema.InvalidNamespaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExNamespaceContextImpl
implements ExNamespaceContext {
    static final String DEFAULT_NS_PREFIX = "ns";
    private BpelEntityImpl myElement;

    public ExNamespaceContextImpl(BpelEntityImpl bpelEntityImpl) {
        this.myElement = bpelEntityImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNamespaceURI(String string) {
        this.myElement.readLock();
        try {
            String string2 = this.myElement.lookupNamespaceURI(string);
            return string2;
        }
        finally {
            this.myElement.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrefix(String string) {
        this.myElement.readLock();
        try {
            String string2 = this.myElement.getPeer().lookupPrefix(string);
            if (string2 != null && string2.length() == 0) {
                String string3 = null;
                return string3;
            }
            String string4 = string2;
            return string4;
        }
        finally {
            this.myElement.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getPrefixes(String string) {
        this.myElement.readLock();
        try {
            assert (string != null);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (BpelEntityImpl bpelEntityImpl = this.myElement; bpelEntityImpl != null; bpelEntityImpl = bpelEntityImpl.getParent()) {
                this.fillPrefixes(bpelEntityImpl, string, linkedList);
            }
            Iterator iterator = linkedList.iterator();
            return iterator;
        }
        finally {
            this.myElement.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getPrefixes() {
        this.myElement.readLock();
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (BpelEntityImpl bpelEntityImpl = this.myElement; bpelEntityImpl != null; bpelEntityImpl = bpelEntityImpl.getParent()) {
                this.fillPrefixes(bpelEntityImpl, null, linkedList);
            }
            Iterator<String> iterator = linkedList.iterator();
            return iterator;
        }
        finally {
            this.myElement.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addNamespace(String string) throws InvalidNamespaceException {
        try {
            new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            InvalidNamespaceException invalidNamespaceException = new InvalidNamespaceException(uRISyntaxException.getMessage());
            throw invalidNamespaceException;
        }
        this.myElement.writeLock();
        try {
            int n;
            if (this.getPrefix(string) != null) {
                String string2 = this.getPrefix(string);
                return string2;
            }
            boolean bl = false;
            String string3 = PreferredNsPrefixes.getPreferredPrefix(string);
            if (string3 == null) {
                string3 = DEFAULT_NS_PREFIX;
                bl = true;
            }
            if ((n = this.getMaximumSuffix(string3)) == -1) {
                if (bl) {
                    string3 = string3 + "0";
                } else if (this.isPrefixRegistered(string3)) {
                    string3 = string3 + "1";
                }
            } else {
                string3 = string3 + ++n;
            }
            BpelEntityImpl bpelEntityImpl = this.getRoot();
            bpelEntityImpl.addPrefix(string3, string);
            String string4 = string3;
            return string4;
        }
        finally {
            this.myElement.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamespace(String string, String string2) throws InvalidNamespaceException {
        assert (string != null && string.length() != 0);
        String string3 = this.getNamespaceURI(string);
        if (string3 != null && string3.length() > 0 && !string3.equals(string2)) {
            throw new InvalidNamespaceException("Element's scope already have the prefix \"" + string + "\" and it declared " + "with different namespace uri");
        }
        try {
            new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            InvalidNamespaceException invalidNamespaceException = new InvalidNamespaceException(uRISyntaxException.getMessage());
            throw invalidNamespaceException;
        }
        this.myElement.writeLock();
        try {
            if (!Utils.checkNCName(string)) {
                throw new InvalidNamespaceException("Prefix : '" + string + "' is not acceptable as prefix fot namespace.");
            }
            this.getRoot().addPrefix(string, string2);
        }
        finally {
            this.myElement.writeUnlock();
        }
    }

    private void fillPrefixes(BpelEntityImpl bpelEntityImpl, String string, List<String> list) {
        Map map = bpelEntityImpl.getPrefixes();
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (string == null) {
                list.add(string2);
            }
            if (string3 == null || !string3.equals(string)) continue;
            list.add(string2);
        }
    }

    private boolean isPrefixRegistered(String string) {
        assert (string != null);
        String string2 = this.getNamespaceURI(string);
        return string2 != null && string2.length() > 0;
    }

    private int getMaximumSuffix(String string) {
        assert (string != null);
        Iterator<String> iterator = this.getPrefixes();
        int n = -1;
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length());
            try {
                int n2 = Integer.parseInt(string3);
                if (n2 <= n) continue;
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    private BpelEntityImpl getRoot() {
        BpelEntityImpl bpelEntityImpl = this.myElement;
        while (bpelEntityImpl.getParent() != null) {
            bpelEntityImpl = bpelEntityImpl.getParent();
        }
        return bpelEntityImpl;
    }
}

