/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.ext.logging.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ExtensionEntity;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.support.EntityUpdater;
import org.netbeans.modules.bpel.model.ext.logging.api.Alert;
import org.netbeans.modules.bpel.model.ext.logging.api.AlertLevel;
import org.netbeans.modules.bpel.model.ext.logging.api.Location;
import org.netbeans.modules.bpel.model.ext.logging.api.Trace;
import org.netbeans.modules.bpel.model.ext.logging.impl.LoggingEntityFactory;
import org.netbeans.modules.bpel.model.ext.logging.impl.LoggingEntityImpl;
import org.netbeans.modules.bpel.model.ext.logging.xam.LoggingAttributes;
import org.netbeans.modules.bpel.model.ext.logging.xam.LoggingElements;
import org.netbeans.modules.bpel.model.impl.BpelBuilderImpl;
import org.netbeans.modules.bpel.model.impl.BpelModelImpl;
import org.netbeans.modules.bpel.model.impl.FromImpl;
import org.netbeans.modules.bpel.model.xam.BpelElements;
import org.netbeans.modules.bpel.model.xam.BpelTypes;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlertImpl
extends LoggingEntityImpl
implements Alert {
    private static AtomicReference<Attribute[]> myAttributes = new AtomicReference();

    AlertImpl(LoggingEntityFactory loggingEntityFactory, BpelModelImpl bpelModelImpl, Element element) {
        super(loggingEntityFactory, bpelModelImpl, element);
    }

    AlertImpl(LoggingEntityFactory loggingEntityFactory, BpelBuilderImpl bpelBuilderImpl) {
        super(loggingEntityFactory, bpelBuilderImpl, LoggingElements.ALERT);
    }

    @Override
    protected BpelEntity create(Element element) {
        if (BpelElements.FROM.getName().equals(element.getLocalName())) {
            return new FromImpl(this.getModel(), element);
        }
        return null;
    }

    @Override
    protected Attribute[] getDomainAttributes() {
        if (myAttributes.get() == null) {
            Attribute[] attributeArray = new Attribute[]{LoggingAttributes.LOCATION, LoggingAttributes.ALERT_LEVEL};
            myAttributes.compareAndSet(null, attributeArray);
        }
        return myAttributes.get();
    }

    @Override
    public Class<? extends BpelEntity> getElementType() {
        return Alert.class;
    }

    @Override
    public EntityUpdater getEntityUpdater() {
        return AlertEntityUpdater.getInstance();
    }

    @Override
    public From getFrom() {
        return this.getChild(From.class);
    }

    @Override
    public void setFrom(From from) {
        this.setChild(from, From.class, new BpelTypes[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlertLevel getLevel() {
        this.readLock();
        try {
            String string = this.getAttribute(LoggingAttributes.ALERT_LEVEL);
            AlertLevel alertLevel = AlertLevel.forString(string);
            return alertLevel;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setLevel(AlertLevel alertLevel) {
        this.setBpelAttribute((Attribute)LoggingAttributes.ALERT_LEVEL, alertLevel);
    }

    @Override
    public void removeLevel() {
        this.removeAttribute(LoggingAttributes.ALERT_LEVEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location getLocation() {
        this.readLock();
        try {
            String string = this.getAttribute(LoggingAttributes.LOCATION);
            Location location = Location.forString(string);
            return location;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setLocation(Location location) {
        this.setBpelAttribute((Attribute)LoggingAttributes.LOCATION, location);
    }

    @Override
    public void removeLocation() {
        this.removeAttribute(LoggingAttributes.LOCATION);
    }

    private static class AlertEntityUpdater
    implements EntityUpdater {
        private static EntityUpdater INSTANCE = new AlertEntityUpdater();

        public static EntityUpdater getInstance() {
            return INSTANCE;
        }

        private AlertEntityUpdater() {
        }

        public void update(BpelEntity bpelEntity, ExtensionEntity extensionEntity, ComponentUpdater.Operation operation) {
            if (bpelEntity instanceof Trace) {
                Trace trace = (Trace)bpelEntity;
                Alert alert = (Alert)extensionEntity;
                switch (operation) {
                    case ADD: {
                        trace.addAlert(alert);
                        break;
                    }
                    case REMOVE: {
                        trace.remove(alert);
                    }
                }
            }
        }

        public void update(BpelEntity bpelEntity, ExtensionEntity extensionEntity, int n, ComponentUpdater.Operation operation) {
            if (bpelEntity instanceof Trace) {
                Trace trace = (Trace)bpelEntity;
                Alert alert = (Alert)extensionEntity;
                switch (operation) {
                    case ADD: {
                        trace.insertAlert(alert, n);
                        break;
                    }
                    case REMOVE: {
                        trace.remove(alert);
                    }
                }
            }
        }
    }
}

