/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Compensate;
import org.netbeans.modules.bpel.model.api.CompensateScope;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.ContentElement;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.ExpressionLanguageSpec;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.TerminationHandler;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.SchemaReferenceBuilder;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.ActivityCreatorHolder;
import org.netbeans.modules.bpel.model.api.support.BpelVariableResolver;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.bpel.model.api.support.BpelXPathNamespaceContext;
import org.netbeans.modules.bpel.model.api.support.BpelXpathExtFunctionResolver;
import org.netbeans.modules.bpel.model.api.support.Initiate;
import org.netbeans.modules.bpel.model.api.support.Pattern;
import org.netbeans.modules.bpel.model.api.support.Roles;
import org.netbeans.modules.bpel.model.api.support.TBoolean;
import org.netbeans.modules.bpel.model.api.support.XPathCastResolverImpl;
import org.netbeans.modules.bpel.model.ext.editor.api.Cast;
import org.netbeans.modules.bpel.model.ext.editor.api.Casts;
import org.netbeans.modules.bpel.model.ext.editor.api.Editor;
import org.netbeans.modules.bpel.model.ext.editor.api.Source;
import org.netbeans.modules.bpel.model.impl.BpelBuilderImpl;
import org.netbeans.modules.bpel.model.impl.BpelContainerImpl;
import org.netbeans.modules.bpel.model.impl.BpelModelImpl;
import org.netbeans.modules.bpel.model.impl.references.BpelAttributesType;
import org.netbeans.modules.bpel.model.impl.references.BpelReferenceBuilder;
import org.netbeans.modules.bpel.model.impl.references.WSDLReferenceBuilder;
import org.netbeans.modules.bpel.model.xam.BpelTypes;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.Attribute;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xpath.ext.XPathException;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathModelHelper;
import org.netbeans.modules.xml.xpath.ext.schema.ExNamespaceContext;
import org.netbeans.modules.xml.xpath.ext.spi.ExtensionFunctionResolver;
import org.netbeans.modules.xml.xpath.ext.spi.ExternalModelResolver;
import org.netbeans.modules.xml.xpath.ext.spi.VariableResolver;
import org.netbeans.modules.xml.xpath.ext.spi.XPathCastResolver;
import org.netbeans.modules.xml.xpath.ext.spi.validation.XPathValidationContext;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static final char SEMICOLON = ';';
    public static final char AMP = '&';
    public static final String QUOT = "&quot;";
    public static final String APOS = "&apos;";
    public static final String GT = "&gt;";
    public static final String BAD_ATTRIBUTE_VALUE = "BAD_ATTRIBUTE_VALUE";
    public static final String BAD_ATTRIBUTE_URI_VALUE = "BAD_ATTRIBUTE_URI_VALUE";
    public static final String BAD_VARIABLE_NAME = "BAD_VARIABLE_NAME";
    public static final String BAD_CORRELATION_SET_NAME = "BAD_CORRELATION_SET_NAME";
    public static final String BAD_PARTNER_LINK_NAME = "BAD_PARTNER_LINK_NAME";
    public static final String BAD_MESSAGE_EXCHANGE_NAME = "BAD_MESSAGE_EXCHANGE_NAME";
    public static final String BAD_LINK_NAME = "BAD_LINK_NAME";
    public static final String BAD_URI_VALUE = "BAD_URI_VALUE";
    public static final String BAD_NCNAME_VALUE = "BAD_NCNAME_VALUE";
    public static final String BAD_VARIABLE_FOR_FOR_EACH = "BAD_VARIABLE_FOR_FOR_EACH";
    public static final String BAD_VARIABLE_FOR_ON_EVENT = "BAD_VARIABLE_FOR_ON_EVENT";
    public static final String BAD_VARIABLE_FOR_SCOPE_IN_ON_EVENT = "BAD_VARIABLE_FOR_SCOPE_IN_ON_EVENT";
    public static final String SOURCES_TYPE_BPELPRO = "BIZPRO";
    private static final String BUNDLE = "org/netbeans/modules/bpel/model/impl/Bundle";
    private static final String XML_COMMENT_START = "<!--";
    private static final String XML_COMMENT_END = "-->";
    public static final DefaultParentAccess DEFAULT_PARENT_ACCESS = new DefaultParentAccess();

    private Utils() {
    }

    public static SchemaComponent checkXPathExpression(ContentElement contentElement) {
        return Utils.checkXPathExpression(contentElement, null);
    }

    public static SchemaComponent checkXPathExpression(ContentElement contentElement, XPathValidationContext xPathValidationContext) {
        String string = contentElement.getContent();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        String string2 = null;
        if (contentElement instanceof ExpressionLanguageSpec) {
            string2 = ((ExpressionLanguageSpec)((Object)contentElement)).getExpressionLanguage();
        }
        return Utils.checkExpression(string2, string, contentElement, xPathValidationContext);
    }

    private static SchemaComponent checkExpression(String string, String string2, final ContentElement contentElement, final XPathValidationContext xPathValidationContext) {
        boolean bl;
        boolean bl2 = bl = string == null || "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(string);
        if (!bl) {
            return null;
        }
        XPathModelHelper xPathModelHelper = XPathModelHelper.getInstance();
        XPathModel xPathModel = xPathModelHelper.newXPathModel();
        if (xPathValidationContext != null) {
            xPathValidationContext.setXPathModel(xPathModel);
            xPathModel.setValidationContext(xPathValidationContext);
        }
        ExNamespaceContext exNamespaceContext = ((BpelEntity)((Object)contentElement)).getNamespaceContext();
        xPathModel.setNamespaceContext((NamespaceContext)((Object)new BpelXPathNamespaceContext(exNamespaceContext)));
        xPathModel.setVariableResolver((VariableResolver)new BpelVariableResolver(xPathValidationContext, (BpelEntity)((Object)contentElement)));
        xPathModel.setExtensionFunctionResolver((ExtensionFunctionResolver)new BpelXpathExtFunctionResolver());
        xPathModel.setExternalModelResolver(new ExternalModelResolver(){

            public Collection<SchemaModel> getModels(String string) {
                BpelModel bpelModel = ((BpelEntity)((Object)contentElement)).getBpelModel();
                return SchemaReferenceBuilder.getSchemaModels(bpelModel, string, true);
            }

            public Collection<SchemaModel> getVisibleModels() {
                if (xPathValidationContext != null) {
                    xPathValidationContext.addResultItem(Validator.ResultType.ERROR, NbBundle.getMessage(Utils.class, (String)"ABSOLUTE_PATH_DISALLOWED"), new Object[0]);
                }
                return null;
            }

            public boolean isSchemaVisible(String string) {
                assert (string != null);
                BpelModel bpelModel = ((BpelEntity)((Object)contentElement)).getBpelModel();
                if (bpelModel.getState() == Model.State.VALID) {
                    for (Import import_ : bpelModel.getProcess().getImports()) {
                        if (!"http://www.w3.org/2001/XMLSchema".equals(import_.getImportType()) || !string.equals(import_.getNamespace())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        xPathModel.setXPathCastResolver(Utils.createXPathCastResolver(contentElement));
        if (BpelXPathModelFactory.isSplitable(string2)) {
            String[] stringArray;
            if (xPathValidationContext != null) {
                xPathValidationContext.addResultItem(string2, Validator.ResultType.ERROR, NbBundle.getMessage(Utils.class, (String)"INCOMPLETE_XPATH"), new Object[0]);
            }
            for (String string3 : stringArray = BpelXPathModelFactory.split(string2)) {
                Utils.checkSingleExpr(xPathModel, string3);
            }
            return null;
        }
        return Utils.checkSingleExpr(xPathModel, string2);
    }

    private static SchemaComponent checkSingleExpr(XPathModel xPathModel, String string) {
        try {
            XPathExpression xPathExpression = xPathModel.parseExpression(string);
            xPathModel.resolveExtReferences(true);
            return xPathModel.getLastSchemaComponent();
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    private static void out() {
        System.out.println();
    }

    private void out(Object object) {
        System.out.println("*** " + object);
    }

    private static XPathCastResolver createXPathCastResolver(ContentElement contentElement) {
        if (!(contentElement instanceof BpelEntity)) {
            return null;
        }
        BpelEntity bpelEntity = (BpelEntity)((Object)contentElement);
        BpelContainer bpelContainer = bpelEntity.getParent();
        if (!(bpelContainer instanceof Copy)) {
            return null;
        }
        List list = bpelContainer.getChildren(Editor.class);
        if (list == null) {
            return null;
        }
        ArrayList<Cast> arrayList = new ArrayList<Cast>();
        boolean bl = contentElement instanceof From;
        boolean bl2 = contentElement instanceof To;
        for (Editor editor : list) {
            Cast[] castArray;
            Casts casts = editor.getCasts();
            if (casts == null || (castArray = casts.getCasts()) == null) continue;
            for (Cast cast : castArray) {
                if (cast == null) continue;
                Source source = cast.getSource();
                if (bl && source == Source.FROM) {
                    arrayList.add(cast);
                    continue;
                }
                if (!bl2 || source != Source.TO) continue;
                arrayList.add(cast);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new XPathCastResolverImpl(arrayList);
    }

    public static QName getQName(String string, BpelEntity bpelEntity) {
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[2];
        Utils.splitQName(string, stringArray);
        String string2 = bpelEntity.getNamespaceContext().getNamespaceURI(stringArray[0]);
        if (string2 == null) {
            return null;
        }
        return new QName(string2, stringArray[1]);
    }

    public static Collection<Class<? extends BpelEntity>> of(BpelTypes[] bpelTypesArray) {
        if (bpelTypesArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Class<? extends BpelEntity>> arrayList = new ArrayList<Class<? extends BpelEntity>>(bpelTypesArray.length);
        for (BpelTypes bpelTypes : bpelTypesArray) {
            Class<? extends BpelEntity> clazz = bpelTypes.getComponentType();
            arrayList.add(clazz);
        }
        return arrayList;
    }

    public static Object parse(Class clazz, String string) {
        if (clazz.equals(Roles.class)) {
            return Roles.forString(string);
        }
        if (clazz.equals(Pattern.class)) {
            return Pattern.forString(string);
        }
        if (clazz.equals(TBoolean.class)) {
            return TBoolean.forString(string);
        }
        if (clazz.equals(Initiate.class)) {
            return Initiate.forString(string);
        }
        assert (false);
        return null;
    }

    public static <T> List<T> parseList(BpelEntity bpelEntity, Class<T> clazz, String string) {
        if (clazz.equals(QName.class)) {
            LinkedList<QName> linkedList = new LinkedList<QName>();
            if (string == null) {
                return linkedList;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                QName qName = Utils.getQName(string2, bpelEntity);
                if (qName == null) continue;
                linkedList.add(qName);
            }
            return linkedList;
        }
        assert (false);
        return null;
    }

    public static BpelEntity createActivityGroup(BpelModelImpl bpelModelImpl, Element element) {
        BpelBuilderImpl.ActivityBuilder activityBuilder = Utils.getActivityBuilder(element.getLocalName());
        if (activityBuilder != null) {
            return activityBuilder.build(bpelModelImpl, element);
        }
        return null;
    }

    public static String getResourceString(String string, Object ... objectArray) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE);
        String string2 = resourceBundle.getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    public static boolean checkNCName(String string) {
        return org.netbeans.modules.xml.xam.dom.Utils.isValidNCName((String)string);
    }

    public static void splitQName(String string, String[] stringArray) {
        String string2;
        String string3;
        assert (string != null);
        assert (stringArray != null);
        String[] stringArray2 = string.split(":");
        if (stringArray2.length == 2) {
            string3 = stringArray2[0];
            string2 = stringArray2[1];
        } else {
            string3 = null;
            string2 = stringArray2[0];
        }
        if (stringArray.length > 0) {
            stringArray[0] = string3;
        }
        if (stringArray.length > 1) {
            stringArray[1] = string2;
        }
    }

    public static boolean isEquals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static boolean validate(QName qName) {
        assert (qName != null);
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        try {
            if (string != null) {
                new URI(string);
            }
            if (string2 == null) {
                return false;
            }
            return Utils.checkNCName(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static boolean canUpdatePrefix(Attribute attribute) {
        Class clazz = attribute.getMemberType() != null ? attribute.getMemberType() : attribute.getType();
        if (BpelReferenceable.class.isAssignableFrom(clazz)) {
            BpelAttributesType.AttrType attrType = BpelReferenceBuilder.getInstance().getAttributeType(attribute);
            return attrType == BpelAttributesType.AttrType.QNAME;
        }
        if (ReferenceableSchemaComponent.class.isAssignableFrom(clazz)) {
            BpelAttributesType.AttrType attrType = SchemaReferenceBuilder.getInstance().getAttributeType(attribute);
            return attrType == BpelAttributesType.AttrType.QNAME;
        }
        if (ReferenceableWSDLComponent.class.isAssignableFrom(clazz)) {
            BpelAttributesType.AttrType attrType = WSDLReferenceBuilder.getInstance().getAttributeType(attribute);
            return attrType == BpelAttributesType.AttrType.QNAME;
        }
        return false;
    }

    public static BpelEntity getUnattachedRoot(BpelEntity bpelEntity) {
        BpelEntity bpelEntity2 = bpelEntity;
        for (BpelEntity bpelEntity3 = bpelEntity; bpelEntity3 != null; bpelEntity3 = bpelEntity3.getParent()) {
            bpelEntity2 = bpelEntity3;
        }
        return bpelEntity2;
    }

    public static boolean checkPasteCompensate(final BpelContainerImpl bpelContainerImpl, final Component component) {
        LinkedList<ExtendableActivity> linkedList = new LinkedList<ExtendableActivity>();
        Utils.collectCompensates(component, linkedList);
        ParentAccess parentAccess = new ParentAccess(){

            public BpelContainer getParent(BpelEntity bpelEntity) {
                if (bpelEntity == component) {
                    return bpelContainerImpl;
                }
                return bpelEntity.getParent();
            }
        };
        for (ExtendableActivity extendableActivity : linkedList) {
            if (Utils.hasAscendant(extendableActivity, FaultHandlers.class, parentAccess) || Utils.hasAscendant(extendableActivity, CompensationHandler.class, parentAccess) || Utils.hasAscendant(extendableActivity, TerminationHandler.class, parentAccess)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAscendant(BpelEntity bpelEntity, Class<? extends BpelContainer> clazz) {
        return Utils.hasAscendant(bpelEntity, clazz, DEFAULT_PARENT_ACCESS);
    }

    public static boolean hasAscendant(BpelEntity bpelEntity, Class<? extends BpelContainer> clazz, ParentAccess parentAccess) {
        assert (bpelEntity != null);
        BpelEntity bpelEntity2 = bpelEntity;
        while (!bpelEntity2.getElementType().equals(clazz) && (bpelEntity2 = parentAccess.getParent(bpelEntity2)) != null) {
        }
        return bpelEntity2 != null && bpelEntity2.getElementType().equals(clazz);
    }

    public static NamedComponentReference<PortType> getPortTypeRef(BpelReference<PartnerLink> bpelReference, Component component) {
        if (bpelReference == null) {
            return null;
        }
        PartnerLink partnerLink = (PartnerLink)bpelReference.get();
        if (partnerLink == null) {
            return null;
        }
        WSDLReference<Role> wSDLReference = null;
        wSDLReference = component instanceof Invoke ? partnerLink.getPartnerRole() : partnerLink.getMyRole();
        if (wSDLReference == null) {
            return null;
        }
        Role role = (Role)wSDLReference.get();
        if (role == null) {
            return null;
        }
        return role.getPortType();
    }

    public static boolean equals(QName qName, QName qName2) {
        if (qName == null) {
            return qName2 == null;
        }
        if (qName2 == null) {
            return false;
        }
        return Utils.isEquals(qName.getLocalPart(), qName2.getLocalPart()) && Utils.isEquals(qName.getNamespaceURI(), qName2.getNamespaceURI());
    }

    public static String removeXmlComments(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.indexOf(XML_COMMENT_START);
        int n2 = 0;
        while (n != -1) {
            stringBuilder.append(string.substring(n2, n));
            n2 = string.indexOf(XML_COMMENT_END, n) + XML_COMMENT_END.length();
            n = string.indexOf(XML_COMMENT_START, n2);
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    public static String hackXmlEntities(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(38);
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            for (Map.Entry<String, Character> entry : ActivityCreatorHolder.XML_ENTITIES.entrySet()) {
                String string2 = entry.getKey();
                Character c = entry.getValue();
                n = stringBuilder.indexOf(string2);
                while (n >= 0) {
                    stringBuilder.replace(n, n + string2.length(), Character.toString(c.charValue()));
                    n = stringBuilder.indexOf(string2);
                }
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static void collectCompensates(Component component, Collection<ExtendableActivity> collection) {
        if (component instanceof Compensate || component instanceof CompensateScope) {
            collection.add((ExtendableActivity)component);
        }
        List list = component.getChildren();
        for (Object e : list) {
            Utils.collectCompensates((Component)e, collection);
        }
    }

    public static FileObject getFileObjectByModel(Model model) {
        Lookup lookup;
        ModelSource modelSource;
        if (model != null && (modelSource = model.getModelSource()) != null && (lookup = modelSource.getLookup()) != null) {
            return (FileObject)lookup.lookup(FileObject.class);
        }
        return null;
    }

    public static Project safeGetProject(BpelModel bpelModel) {
        FileObject fileObject = Utils.getFileObjectByModel(bpelModel);
        if (fileObject != null && fileObject.isValid()) {
            return FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return null;
    }

    public static SchemaModel getSchemaModel(FileObject fileObject) {
        SchemaModel schemaModel = null;
        try {
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
            schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return schemaModel;
    }

    private static BpelBuilderImpl.ActivityBuilder getActivityBuilder(String string) {
        return ActivityCreatorHolder.ACTIVITY_BUILDERS.get(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<T> {
        private T first;
        private T second;

        public Pair(T t, T t2) {
            this.first = t;
            this.second = t2;
        }

        public T getFirst() {
            return this.first;
        }

        public T getSecond() {
            return this.second;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Pair)) {
                return false;
            }
            boolean bl = Utils.equals(this.first, ((Pair)object).first) && Utils.equals(this.second, ((Pair)object).second);
            return bl;
        }

        public int hashCode() {
            int n = 0;
            if (this.first != null) {
                n += this.first.hashCode();
            }
            if (this.second != null) {
                n += 37 * this.second.hashCode();
            }
            return n;
        }

        public String toString() {
            return "[first: " + (this.first == null ? null : this.first.toString()) + ", second:" + (this.second == null ? null : this.second.toString()) + "]";
        }
    }

    public static class DefaultParentAccess
    implements ParentAccess {
        public BpelContainer getParent(BpelEntity bpelEntity) {
            return bpelEntity.getParent();
        }
    }

    public static interface ParentAccess {
        public BpelContainer getParent(BpelEntity var1);
    }
}

