/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.server;

import com.tomsawyer.service.TSService;
import com.tomsawyer.service.TSServiceException;
import com.tomsawyer.service.ds;
import com.tomsawyer.service.server.TSServletServiceServer;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class TSServletHelper {
    String serviceData;
    String outputDataString;
    TSServletServiceServer server;
    private InputStream inStream;
    private OutputStream outStream;
    private int debugLevel = 0;

    public TSServletHelper(TSServletServiceServer tSServletServiceServer, InputStream inputStream, OutputStream outputStream) {
        this.server = tSServletServiceServer;
        this.inStream = inputStream;
        this.outStream = outputStream;
    }

    public void run() throws IOException {
        this.fetchGraphData();
        try {
            Class<?> clazz = Class.forName(this.server.getServiceName().e());
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            TSService tSService = (TSService)constructor.newInstance(new Object[0]);
            this.outputDataString = tSService.runRemote(this.serviceData);
        }
        catch (InstantiationException instantiationException) {
            throw new TSServiceException(80, instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TSServiceException(81, illegalAccessException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TSServiceException(80, classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TSServiceException(80, noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TSServiceException(80, invocationTargetException.getMessage());
        }
        this.storeGraphData();
    }

    public void fetchGraphData() throws IOException {
        Closeable closeable;
        try {
            closeable = new ObjectInputStream(this.inStream);
            ds ds2 = (ds)((ObjectInputStream)closeable).readObject();
            this.server.setServiceName(ds2);
            this.serviceData = (String)((ObjectInputStream)closeable).readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new TSServiceException(80, classNotFoundException.getMessage());
        }
        if (this.debugLevel > 0) {
            closeable = new ObjectOutputStream(new FileOutputStream("fetchData.out"));
            ((ObjectOutputStream)closeable).writeObject(this.serviceData);
            ((ObjectOutputStream)closeable).flush();
            ((ObjectOutputStream)closeable).close();
        }
    }

    public String getServiceData() {
        return this.serviceData;
    }

    public void storeGraphData() throws IOException {
        ObjectOutputStream objectOutputStream;
        if (this.debugLevel > 0) {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream("storeData.out"));
            objectOutputStream.writeObject(this.outputDataString);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        objectOutputStream = new ObjectOutputStream(this.outStream);
        objectOutputStream.writeObject(this.outputDataString);
        objectOutputStream.flush();
    }
}

