/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.server;

import com.tomsawyer.service.TSRMIService;
import com.tomsawyer.service.TSService;
import com.tomsawyer.service.TSServiceException;
import com.tomsawyer.service.ds;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;

public class TSRMIHelper
implements Runnable {
    String serviceData;
    String outputDataString;
    Integer id;
    TSRMIService caller;
    private ds serviceName;

    public TSRMIHelper(TSRMIService tSRMIService, Integer n) {
        this.id = n;
        this.caller = tSRMIService;
        try {
            this.serviceName = this.caller.getServiceName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        TSRMIService tSRMIService = this.caller;
        synchronized (tSRMIService) {
            this.fetchGraphData();
            try {
                Class<?> clazz = Class.forName(this.serviceName.e());
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                TSService tSService = (TSService)constructor.newInstance(new Object[0]);
                this.outputDataString = tSService.runRemote(this.serviceData);
            }
            catch (InstantiationException instantiationException) {
                throw new TSServiceException(80, instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TSServiceException(81, illegalAccessException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TSServiceException(80, classNotFoundException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new TSServiceException(80, noSuchMethodException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TSServiceException(80, invocationTargetException.getMessage());
            }
            this.storeGraphData();
        }
    }

    public void fetchGraphData() {
        try {
            this.serviceData = this.caller.fetchData(this.id);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TSServiceException(81, remoteException.getMessage());
        }
    }

    public String getServiceData() {
        return this.serviceData;
    }

    public void storeGraphData() {
        try {
            this.caller.storeData(this.id, this.outputDataString);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new TSServiceException(81, remoteException.getMessage());
        }
    }
}

