/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout;

import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.TSHasNodesConstraint;
import com.tomsawyer.service.dk;
import com.tomsawyer.service.layout.TSLayoutConstraint;
import com.tomsawyer.util.TSParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class TSSingleNodeListLayoutConstraint
extends TSLayoutConstraint
implements TSHasNodesConstraint {
    private dk nodes = new dk();

    public TSSingleNodeListLayoutConstraint() {
        this(-1, 0);
    }

    public TSSingleNodeListLayoutConstraint(int n, int n10) {
        super(n, n10);
    }

    public List getNodeList() {
        return Collections.unmodifiableList(this.nodes);
    }

    public boolean checkValidity() {
        boolean bl;
        boolean bl2 = bl = this.nodes.size() != 0;
        if (bl && this.nodes.contains(null)) {
            bl = false;
        }
        HashSet hashSet = this.nodes.iterator();
        while (hashSet.hasNext() && bl) {
            TSDNode tSDNode = (TSDNode)hashSet.next();
            if (tSDNode.isOwned()) continue;
            bl = false;
        }
        if (bl) {
            hashSet = new HashSet(this.nodes);
            bl = hashSet.size() == this.nodes.size();
        }
        return bl;
    }

    public void addNode(TSDNode tSDNode) {
        if (this.nodes.add(tSDNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void addNode(int n, TSDNode tSDNode) {
        this.nodes.add(n, tSDNode);
        this.fireConstraintChangedEvent();
    }

    public void removeNode(TSNode tSNode) {
        this.onNodeDiscarded(tSNode);
    }

    public void onNodeRemoved(TSNode tSNode) {
        if (this.nodes.remove(tSNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    public void onNodeInserted(TSNode tSNode) {
        if (this.nodes.c(tSNode)) {
            this.nodes.a(tSNode);
            this.fireConstraintChangedEvent();
        }
    }

    public void onNodeDiscarded(TSNode tSNode) {
        if (this.nodes.b(tSNode)) {
            this.fireConstraintChangedEvent();
        }
    }

    protected void copy(TSConstraint tSConstraint) {
        super.copy(tSConstraint);
        this.nodes = new dk();
        if (tSConstraint instanceof TSSingleNodeListLayoutConstraint) {
            Iterator iterator = ((TSSingleNodeListLayoutConstraint)tSConstraint).getNodeList().iterator();
            while (iterator.hasNext()) {
                TSDNode tSDNode = (TSDNode)iterator.next();
                if (tSDNode.getUtilityObject() instanceof TSDNode) {
                    this.nodes.add(tSDNode.getUtilityObject());
                    continue;
                }
                this.nodes.add(tSDNode);
            }
        }
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        super.read(tSGraphObjectTable, tSParser);
        tSParser.parseInputString("nodeList");
        tSParser.parseOpenBracket();
        while (tSParser.getString().equals("node")) {
            int n = tSParser.getInt();
            this.nodes.add(tSGraphObjectTable.get((long)n));
        }
        tSParser.pushBack();
        tSParser.parseCloseBracket();
        this.setValid(this.checkValidity());
    }
}

