/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout;

import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.TSHasNodesConstraint;
import com.tomsawyer.service.layout.TSLayoutConstraint;
import com.tomsawyer.util.TSParser;
import java.io.IOException;

public abstract class TSSingleNodeLayoutConstraint
extends TSLayoutConstraint
implements TSHasNodesConstraint {
    private TSDNode node = null;
    private TSDNode removedNode = null;

    public TSSingleNodeLayoutConstraint() {
        this(-1, 0);
    }

    public TSSingleNodeLayoutConstraint(int n, int n10) {
        super(n, n10);
    }

    public TSDNode getNode() {
        return this.node;
    }

    public void setNode(TSDNode tSDNode) {
        TSDNode tSDNode2 = this.node;
        this.node = tSDNode;
        if (tSDNode2 != tSDNode) {
            this.fireConstraintChangedEvent();
        }
    }

    public boolean checkValidity() {
        return this.node != null && this.node.isOwned();
    }

    public void removeNode(TSNode tSNode) {
        this.onNodeDiscarded(tSNode);
    }

    public void onNodeRemoved(TSNode tSNode) {
        if (this.node == tSNode) {
            this.removedNode = (TSDNode)tSNode;
            this.node = null;
            this.fireConstraintChangedEvent();
        }
    }

    public void onNodeInserted(TSNode tSNode) {
        if (this.removedNode == tSNode) {
            this.node = (TSDNode)tSNode;
            this.removedNode = null;
            this.fireConstraintChangedEvent();
        }
    }

    public void onNodeDiscarded(TSNode tSNode) {
        if (this.node == tSNode) {
            this.node = null;
            this.removedNode = null;
            this.fireConstraintChangedEvent();
        }
    }

    protected void copy(TSConstraint tSConstraint) {
        super.copy(tSConstraint);
        this.node = null;
        if (tSConstraint instanceof TSSingleNodeLayoutConstraint) {
            TSDNode tSDNode = ((TSSingleNodeLayoutConstraint)tSConstraint).getNode();
            this.node = tSDNode != null && tSDNode.getUtilityObject() instanceof TSDNode ? (TSDNode)tSDNode.getUtilityObject() : tSDNode;
        }
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        super.read(tSGraphObjectTable, tSParser);
        tSParser.parseInputString("node");
        this.node = (TSDNode)tSGraphObjectTable.getNode((long)tSParser.getInt());
        this.setValid(this.checkValidity());
    }
}

