/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.algorithm.layout.util;

import com.tomsawyer.algorithm.layout.util.TSLayoutCancelledException;

public class TSProgress {
    static int maxStackLevel = 100;
    String[] stepName = new String[100];
    String[] taskName = new String[100];
    double[] taskCurrent = new double[100];
    double[] stepLength = new double[100];
    int stackLevel = -1;
    double maxFraction = 0.0;
    boolean canceled = false;

    public void reset() {
        this.canceled = false;
        this.maxFraction = 0.0;
        this.stackLevel = -1;
    }

    public void startTask(String string) {
        if (this.canceled) {
            throw new TSLayoutCancelledException("Cancelled");
        }
        ++this.stackLevel;
        if (this.stackLevel < maxStackLevel) {
            this.taskName[this.stackLevel] = new String(string);
            this.stepLength[this.stackLevel] = 1.0;
            this.taskCurrent[this.stackLevel] = 0.0;
        }
    }

    public void startStep(String string, double d) {
        if (this.canceled) {
            throw new TSLayoutCancelledException("Cancelled");
        }
        if (this.stackLevel < maxStackLevel) {
            this.stepName[this.stackLevel] = new String(string);
            if (this.stepLength[this.stackLevel] != 1.0) {
                int n = this.stackLevel;
                this.taskCurrent[n] = this.taskCurrent[n] + this.stepLength[this.stackLevel];
            }
            this.stepLength[this.stackLevel] = Math.min(Math.max(0.0, d), 1.0);
        }
    }

    public synchronized int getStackLevel() {
        return this.stackLevel;
    }

    public synchronized String getCurrentStepName() {
        if (this.stackLevel == -1 || this.stackLevel >= maxStackLevel) {
            return "...";
        }
        return this.stepName[Math.min(this.stackLevel, maxStackLevel - 1)];
    }

    public void endTask() {
        if (this.canceled) {
            throw new TSLayoutCancelledException("Cancelled");
        }
        if (this.stackLevel >= 0) {
            --this.stackLevel;
            if (this.stackLevel == -1) {
                this.maxFraction = 1.0;
            }
        } else {
            System.err.println("Warning: progress monitor, wrong stack");
        }
    }

    public synchronized double getCurrentFraction() {
        double d = 0.0;
        for (int i = Math.min(this.stackLevel, maxStackLevel - 1); i >= 0; --i) {
            d = this.taskCurrent[i] + this.stepLength[i] * d;
        }
        this.maxFraction = Math.max(d, this.maxFraction);
        return this.maxFraction;
    }

    public synchronized void cancel() {
        this.canceled = true;
    }
}

