/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.algorithm;

import com.tomsawyer.algorithm.TSAlgorithmData;

public abstract class TSAlgorithm {
    private TSAlgorithmData inputData;
    private TSAlgorithmData outputData;

    protected TSAlgorithm() {
        this.init();
    }

    private void init() {
        this.outputData = null;
        this.inputData = null;
    }

    public int run() {
        int n = this.checkData();
        if (n == 0) {
            this.resetOutputData();
            this.initialize();
            this.parseInputData();
            this.preprocess();
            n = this.algorithmBody();
            this.generateOutputData();
            this.postprocess();
            this.cleanup();
        }
        return n;
    }

    protected abstract int checkData();

    protected abstract void resetOutputData();

    protected void parseInputData() {
    }

    protected void initialize() {
    }

    protected void preprocess() {
    }

    protected abstract int algorithmBody();

    protected abstract void generateOutputData();

    protected void postprocess() {
    }

    protected void cleanup() {
    }

    public void setInputData(TSAlgorithmData tSAlgorithmData) {
        this.inputData = tSAlgorithmData;
    }

    public TSAlgorithmData getInputData() {
        return this.inputData;
    }

    public void setOutputData(TSAlgorithmData tSAlgorithmData) {
        this.outputData = tSAlgorithmData;
    }

    public TSAlgorithmData getOutputData() {
        return this.outputData;
    }
}

