/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageBody;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageElement;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageHeader;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.TargetElement;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.AsymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.Body;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.EncryptedElements;
import org.netbeans.modules.websvc.wsitmodelext.security.EncryptedParts;
import org.netbeans.modules.websvc.wsitmodelext.security.Header;
import org.netbeans.modules.websvc.wsitmodelext.security.Lax;
import org.netbeans.modules.websvc.wsitmodelext.security.LaxTsFirst;
import org.netbeans.modules.websvc.wsitmodelext.security.LaxTsLast;
import org.netbeans.modules.websvc.wsitmodelext.security.Layout;
import org.netbeans.modules.websvc.wsitmodelext.security.RequiredElements;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.SignedElements;
import org.netbeans.modules.websvc.wsitmodelext.security.SignedParts;
import org.netbeans.modules.websvc.wsitmodelext.security.Strict;
import org.netbeans.modules.websvc.wsitmodelext.security.SymmetricBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.TransportBinding;
import org.netbeans.modules.websvc.wsitmodelext.security.Trust10;
import org.netbeans.modules.websvc.wsitmodelext.security.TrustElement;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss10;
import org.netbeans.modules.websvc.wsitmodelext.security.Wss11;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.XPath;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.EncryptBeforeSigning;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.EncryptSignature;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.IncludeTimestamp;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportClientChallenge;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportIssuedTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefEmbeddedToken;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefEncryptedKey;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefExternalURI;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefIssuerSerial;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefKeyIdentifier;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportRefThumbprint;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.MustSupportServerChallenge;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.OnlySignEntireHeadersAndBody;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireClientEntropy;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireServerEntropy;
import org.netbeans.modules.websvc.wsitmodelext.security.parameters.RequireSignatureConfirmation;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.KeyStore;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.TrustStore;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireDerivedKeys;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireEmbeddedTokenReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireExternalReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireExternalUriReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireInternalReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireIssuerSerialReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireKeyIdentifierReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RequireThumbprintReference;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SC10SecurityContextToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.TokensQName;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityPolicyModelHelper {
    public static boolean isSecurityEnabled(WSDLComponent wSDLComponent) {
        Policy policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        if (policy != null) {
            ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
            return extensibilityElement != null;
        }
        return false;
    }

    public static void disableSecurity(WSDLComponent wSDLComponent, boolean bl) {
        Collection collection;
        Binding binding;
        assert (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation);
        SecurityPolicyModelHelper.setSecurityBindingType(wSDLComponent, null);
        SecurityTokensModelHelper.setSupportingTokens(wSDLComponent, null, 4);
        if (wSDLComponent instanceof Binding) {
            ProprietarySecurityPolicyModelHelper.setStreamingSecurity((Binding)wSDLComponent, true);
        }
        SecurityPolicyModelHelper.disableWss(wSDLComponent);
        SecurityPolicyModelHelper.disableTrust10(wSDLComponent);
        SecurityPolicyModelHelper.removeTargets(wSDLComponent);
        Policy policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        if (policy != null && bl) {
            binding = (KeyStore)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, KeyStore.class);
            collection = (TrustStore)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, TrustStore.class);
            if (binding != null) {
                PolicyModelHelper.removeElement((WSDLComponent)binding);
            }
            if (collection != null) {
                PolicyModelHelper.removeElement((WSDLComponent)collection);
            }
        }
        if (wSDLComponent instanceof Binding) {
            binding = (Binding)wSDLComponent;
            collection = binding.getBindingOperations();
            for (BindingOperation bindingOperation : collection) {
                SecurityPolicyModelHelper.disableSecurity((WSDLComponent)bindingOperation, bl);
            }
        } else {
            binding = (BindingOperation)wSDLComponent;
            collection = binding.getBindingInput();
            BindingOutput bindingOutput = binding.getBindingOutput();
            if (collection != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)collection);
            }
            if (bindingOutput != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bindingOutput);
            }
        }
        PolicyModelHelper.cleanPolicies(wSDLComponent);
    }

    public static WssElement enableWss(WSDLComponent wSDLComponent, boolean bl) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            wSDLComponent = PolicyModelHelper.createPolicy(wSDLComponent, true);
        }
        if (bl) {
            if (SecurityPolicyModelHelper.isWss10(wSDLComponent)) {
                SecurityPolicyModelHelper.disableWss(wSDLComponent);
            }
            if (!SecurityPolicyModelHelper.isWss11(wSDLComponent)) {
                return (WssElement)PolicyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.WSS11.getQName(), Wss11.class, false);
            }
            return SecurityPolicyModelHelper.getWss11(wSDLComponent);
        }
        if (SecurityPolicyModelHelper.isWss11(wSDLComponent)) {
            SecurityPolicyModelHelper.disableWss(wSDLComponent);
        }
        if (!SecurityPolicyModelHelper.isWss10(wSDLComponent)) {
            return (WssElement)PolicyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.WSS10.getQName(), Wss10.class, false);
        }
        return SecurityPolicyModelHelper.getWss10(wSDLComponent);
    }

    public static TrustElement enableTrust10(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            wSDLComponent = PolicyModelHelper.createPolicy(wSDLComponent, true);
        }
        if (!SecurityPolicyModelHelper.isTrust10(wSDLComponent)) {
            return (TrustElement)PolicyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.TRUST10.getQName(), Trust10.class, false);
        }
        return SecurityPolicyModelHelper.getTrust10(wSDLComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableWss(WSDLComponent wSDLComponent) {
        WSDLModel wSDLModel = wSDLComponent.getModel();
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            wSDLComponent = PolicyModelHelper.createPolicy(wSDLComponent, true);
        }
        Wss10 wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent);
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            if (wss10 != null) {
                ((WSDLComponent)wss10.getParent()).removeExtensibilityElement((ExtensibilityElement)wss10);
            }
            if (wss11 != null) {
                ((WSDLComponent)wss11.getParent()).removeExtensibilityElement((ExtensibilityElement)wss11);
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableTrust10(WSDLComponent wSDLComponent) {
        boolean bl;
        WSDLModel wSDLModel = wSDLComponent.getModel();
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            wSDLComponent = PolicyModelHelper.createPolicy(wSDLComponent, true);
        }
        if (!(bl = wSDLModel.isIntransaction())) {
            wSDLModel.startTransaction();
        }
        Trust10 trust10 = SecurityPolicyModelHelper.getTrust10(wSDLComponent);
        try {
            if (trust10 != null) {
                ((WSDLComponent)trust10.getParent()).removeExtensibilityElement((ExtensibilityElement)trust10);
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }

    public static boolean isWss10(WSDLComponent wSDLComponent) {
        return SecurityPolicyModelHelper.getWss10(wSDLComponent) != null;
    }

    public static boolean isWss11(WSDLComponent wSDLComponent) {
        return SecurityPolicyModelHelper.getWss11(wSDLComponent) != null;
    }

    public static boolean isTrust10(WSDLComponent wSDLComponent) {
        return SecurityPolicyModelHelper.getTrust10(wSDLComponent) != null;
    }

    public static Wss10 getWss10(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        }
        return (Wss10)PolicyModelHelper.getTopLevelElement(wSDLComponent, Wss10.class);
    }

    public static Wss11 getWss11(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        }
        return (Wss11)PolicyModelHelper.getTopLevelElement(wSDLComponent, Wss11.class);
    }

    public static Trust10 getTrust10(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        }
        return (Trust10)PolicyModelHelper.getTopLevelElement(wSDLComponent, Trust10.class);
    }

    public static boolean isMustSupportRefEmbeddedToken(WSDLComponent wSDLComponent) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        Wss10 wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss10, MustSupportRefEmbeddedToken.class) || SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, MustSupportRefEmbeddedToken.class);
    }

    public static boolean isMustSupportRefExternalURI(WSDLComponent wSDLComponent) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        Wss10 wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss10, MustSupportRefExternalURI.class) || SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, MustSupportRefExternalURI.class);
    }

    public static boolean isMustSupportRefIssuerSerial(WSDLComponent wSDLComponent) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        Wss10 wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss10, MustSupportRefIssuerSerial.class) || SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, MustSupportRefIssuerSerial.class);
    }

    public static boolean isMustSupportRefKeyIdentifier(WSDLComponent wSDLComponent) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        Wss10 wss10 = SecurityPolicyModelHelper.getWss10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss10, MustSupportRefKeyIdentifier.class) || SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, MustSupportRefKeyIdentifier.class);
    }

    public static boolean isMustSupportRefEncryptedKey(WSDLComponent wSDLComponent) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, MustSupportRefEncryptedKey.class);
    }

    public static boolean isMustSupportRefThumbprint(WSDLComponent wSDLComponent) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, MustSupportRefThumbprint.class);
    }

    public static boolean isRequireSignatureConfirmation(WSDLComponent wSDLComponent) {
        Wss11 wss11 = SecurityPolicyModelHelper.getWss11(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wss11, RequireSignatureConfirmation.class);
    }

    public static boolean isRequireServerEntropy(WSDLComponent wSDLComponent) {
        Trust10 trust10 = SecurityPolicyModelHelper.getTrust10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)trust10, RequireServerEntropy.class);
    }

    public static boolean isRequireClientEntropy(WSDLComponent wSDLComponent) {
        Trust10 trust10 = SecurityPolicyModelHelper.getTrust10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)trust10, RequireClientEntropy.class);
    }

    public static boolean isMustSupportIssuedTokens(WSDLComponent wSDLComponent) {
        Trust10 trust10 = SecurityPolicyModelHelper.getTrust10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)trust10, MustSupportIssuedTokens.class);
    }

    public static boolean isMustSupportClientChallenge(WSDLComponent wSDLComponent) {
        Trust10 trust10 = SecurityPolicyModelHelper.getTrust10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)trust10, MustSupportClientChallenge.class);
    }

    public static boolean isMustSupportServerChallenge(WSDLComponent wSDLComponent) {
        Trust10 trust10 = SecurityPolicyModelHelper.getTrust10(wSDLComponent);
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)trust10, MustSupportServerChallenge.class);
    }

    public static boolean isAttributeEnabled(ExtensibilityElement extensibilityElement, Class clazz) {
        if (extensibilityElement != null) {
            Policy policy = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)extensibilityElement, Policy.class);
            return PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, clazz) != null;
        }
        return false;
    }

    public static void enableIncludeTimestamp(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.INCLUDETIMESTAMP.getQName(), IncludeTimestamp.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, IncludeTimestamp.class, true);
        }
    }

    public static void enableEncryptSignature(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.ENCRYPTSIGNATURE.getQName(), EncryptSignature.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, EncryptSignature.class, true);
        }
    }

    public static void enableSignEntireHeadersAndBody(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.ONLYSIGNENTIREHEADERSANDBODY.getQName(), OnlySignEntireHeadersAndBody.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, OnlySignEntireHeadersAndBody.class, true);
        }
    }

    public static void enableEncryptBeforeSigning(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.ENCRYPTBEFORESIGNING.getQName(), EncryptBeforeSigning.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, EncryptBeforeSigning.class, true);
        }
    }

    public static void enableMustSupportRefEmbeddedToken(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFEMBEDDEDTOKEN.getQName(), MustSupportRefEmbeddedToken.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefEmbeddedToken.class, true);
        }
    }

    public static void enableMustSupportRefExternalURI(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFEXTERNALURI.getQName(), MustSupportRefExternalURI.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefExternalURI.class, true);
        }
    }

    public static void enableMustSupportRefIssuerSerial(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFISSUERSERIAL.getQName(), MustSupportRefIssuerSerial.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefIssuerSerial.class, true);
        }
    }

    public static void enableMustSupportRefKeyIdentifier(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFKEYIDENTIFIER.getQName(), MustSupportRefKeyIdentifier.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefKeyIdentifier.class, true);
        }
    }

    public static boolean isRequireDerivedKeys(WSDLComponent wSDLComponent) {
        return SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)wSDLComponent, RequireDerivedKeys.class);
    }

    public static void enableRequireDerivedKeys(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.REQUIREDERIVEDKEYS.getQName(), RequireDerivedKeys.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireDerivedKeys.class, true);
        }
    }

    public static void enableRequireExternalUri(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.REQUIREEXTERNALURIREFERENCE.getQName(), RequireExternalUriReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireExternalUriReference.class, true);
        }
    }

    public static void enableRequireKeyIdentifierReference(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.REQUIREKEYIDENTIFIERREFERENCE.getQName(), RequireKeyIdentifierReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireKeyIdentifierReference.class, true);
        }
    }

    public static void enableRequireSecurityContextToken(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.SC10SECURITYCONTEXTTOKEN.getQName(), SC10SecurityContextToken.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, SC10SecurityContextToken.class, true);
        }
    }

    public static void enableRequireIssuerSerialReference(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.REQUIREISSUERSERIALREFERENCE.getQName(), RequireIssuerSerialReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireIssuerSerialReference.class, true);
        }
    }

    public static void enableRequireEmbeddedTokenReference(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.REQUIREEMBEDDEDTOKENREFERENCE.getQName(), RequireEmbeddedTokenReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireEmbeddedTokenReference.class, true);
        }
    }

    public static void enableRequireThumbprintReference(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.REQUIRETHUMBPRINTREFERENCE.getQName(), RequireThumbprintReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireThumbprintReference.class, true);
        }
    }

    public static void enableRequireExternalReference(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.REQUIREEXTERNALREFERENCE.getQName(), RequireExternalReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireExternalReference.class, true);
        }
    }

    public static void enableRequireInternalReference(WSDLComponent wSDLComponent, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement(wSDLComponent, TokensQName.REQUIREINTERNALREFERENCE.getQName(), RequireInternalReference.class, true);
        } else {
            PolicyModelHelper.removeElement(wSDLComponent, RequireInternalReference.class, true);
        }
    }

    public static void enableMustSupportRefEncryptedKey(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFENCRYPTEDKEY.getQName(), MustSupportRefEncryptedKey.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefEncryptedKey.class, true);
        }
    }

    public static void enableMustSupportRefThumbprint(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)wssElement, SecurityPolicyQName.MUSTSUPPORTREFTHUMBPRINT.getQName(), MustSupportRefThumbprint.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, MustSupportRefThumbprint.class, true);
        }
    }

    public static void enableRequireSignatureConfirmation(WssElement wssElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)wssElement, SecurityPolicyQName.REQUIRESIGNATURECONFIRMATION.getQName(), RequireSignatureConfirmation.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)wssElement, RequireSignatureConfirmation.class, true);
        }
    }

    public static void enableRequireClientEntropy(TrustElement trustElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)trustElement, SecurityPolicyQName.REQUIRECLIENTENTROPY.getQName(), RequireClientEntropy.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trustElement, RequireClientEntropy.class, true);
        }
    }

    public static void enableRequireServerEntropy(TrustElement trustElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)trustElement, SecurityPolicyQName.REQUIRESERVERENTROPY.getQName(), RequireServerEntropy.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trustElement, RequireServerEntropy.class, true);
        }
    }

    public static void enableMustSupportIssuedTokens(TrustElement trustElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)trustElement, SecurityPolicyQName.MUSTSUPPORTISSUEDTOKENS.getQName(), MustSupportIssuedTokens.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trustElement, MustSupportIssuedTokens.class, true);
        }
    }

    public static void enableMustSupportClientChallenge(TrustElement trustElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)trustElement, SecurityPolicyQName.MUSTSUPPORTCLIENTCHALLENGE.getQName(), MustSupportClientChallenge.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trustElement, MustSupportClientChallenge.class, true);
        }
    }

    public static void enableMustSupportServerChallenge(TrustElement trustElement, boolean bl) {
        if (bl) {
            PolicyModelHelper.createElement((WSDLComponent)trustElement, SecurityPolicyQName.MUSTSUPPORTSERVERCHALLENGE.getQName(), MustSupportServerChallenge.class, true);
        } else {
            PolicyModelHelper.removeElement((WSDLComponent)trustElement, MustSupportServerChallenge.class, true);
        }
    }

    public static Vector<Vector> getTargets(WSDLComponent wSDLComponent) {
        Vector vector;
        Object object;
        Object object22;
        Object object32;
        Object object4;
        Header header2;
        SignedParts signedParts;
        Vector<Vector> vector2 = new Vector<Vector>();
        Policy policy = null;
        policy = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        if (policy == null) {
            return vector2;
        }
        List list = Collections.emptyList();
        List list2 = Collections.emptyList();
        List list3 = Collections.emptyList();
        EncryptedParts encryptedParts = (EncryptedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, EncryptedParts.class);
        EncryptedElements encryptedElements = (EncryptedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, EncryptedElements.class);
        if (encryptedParts != null) {
            list = encryptedParts.getExtensibilityElements(Body.class);
            list2 = encryptedParts.getExtensibilityElements(Header.class);
        }
        if (encryptedElements != null) {
            list3 = encryptedElements.getExtensibilityElements(XPath.class);
        }
        if (list != null && !list.isEmpty()) {
            signedParts = new Vector();
            signedParts.add(0, (MessageBody)new MessageBody());
            signedParts.add(1, (Boolean)Boolean.FALSE);
            signedParts.add(2, Boolean.TRUE);
            signedParts.add(3, Boolean.FALSE);
            vector2.add((Vector)signedParts);
        }
        for (Header header2 : list2) {
            object4 = SecurityPolicyModelHelper.getListModelForHeader(header2);
            if (object4 == null) continue;
            object32 = new Vector();
            ((Vector)object32).add(0, object4);
            ((Vector)object32).add(1, Boolean.FALSE);
            ((Vector)object32).add(2, Boolean.TRUE);
            ((Vector)object32).add(3, Boolean.FALSE);
            vector2.add((Vector)object32);
        }
        for (Header header2 : list3) {
            object4 = SecurityPolicyModelHelper.getListModelForXPath((XPath)header2);
            if (object4 == null) continue;
            object32 = new Vector();
            ((Vector)object32).add(0, object4);
            ((Vector)object32).add(1, Boolean.FALSE);
            ((Vector)object32).add(2, Boolean.TRUE);
            ((Vector)object32).add(3, Boolean.FALSE);
            vector2.add((Vector)object32);
        }
        signedParts = (SignedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SignedParts.class);
        header2 = (SignedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SignedElements.class);
        if (signedParts != null) {
            list = signedParts.getExtensibilityElements(Body.class);
            list2 = signedParts.getExtensibilityElements(Header.class);
        }
        if (header2 != null) {
            list3 = header2.getExtensibilityElements(XPath.class);
        }
        if (list != null && !list.isEmpty()) {
            object4 = new MessageBody();
            object32 = SecurityPolicyModelHelper.targetExists(vector2, object4);
            if (object32 != null) {
                ((Vector)object32).set(1, Boolean.TRUE);
            } else {
                object22 = new Vector();
                ((Vector)object22).add(0, object4);
                ((Vector)object22).add(1, Boolean.TRUE);
                ((Vector)object22).add(2, Boolean.FALSE);
                ((Vector)object22).add(3, Boolean.FALSE);
                vector2.add((Vector)object22);
            }
        }
        for (Object object32 : list2) {
            object22 = SecurityPolicyModelHelper.getListModelForHeader((Header)object32);
            if (object22 == null) continue;
            object = SecurityPolicyModelHelper.targetExists(vector2, (TargetElement)object22);
            if (object != null) {
                ((Vector)object).set(1, Boolean.TRUE);
                continue;
            }
            vector = new Vector();
            vector.add(0, object22);
            vector.add(1, Boolean.TRUE);
            vector.add(2, Boolean.FALSE);
            vector.add(3, Boolean.FALSE);
            vector2.add(vector);
        }
        for (Object object32 : list3) {
            object22 = SecurityPolicyModelHelper.getListModelForXPath((XPath)object32);
            if (object22 == null) continue;
            object = SecurityPolicyModelHelper.targetExists(vector2, (TargetElement)object22);
            if (object != null) {
                ((Vector)object).set(1, Boolean.TRUE);
                continue;
            }
            vector = new Vector();
            vector.add(0, object22);
            vector.add(1, Boolean.TRUE);
            vector.add(2, Boolean.FALSE);
            vector.add(3, Boolean.FALSE);
            vector2.add(vector);
        }
        object4 = (RequiredElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, RequiredElements.class);
        if (object4 != null) {
            list3 = object4.getExtensibilityElements(XPath.class);
        }
        for (Object object22 : list3) {
            object = SecurityPolicyModelHelper.getListModelForXPath((XPath)object22);
            if (object == null) continue;
            vector = SecurityPolicyModelHelper.targetExists(vector2, (TargetElement)object);
            if (vector != null) {
                vector.set(3, Boolean.TRUE);
                continue;
            }
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(0, object);
            vector3.add(1, Boolean.FALSE);
            vector3.add(2, Boolean.FALSE);
            vector3.add(3, Boolean.TRUE);
            vector2.add(vector3);
        }
        return vector2;
    }

    public static Vector targetExists(Vector<Vector> vector, TargetElement targetElement) {
        for (Vector vector2 : vector) {
            TargetElement targetElement2 = (TargetElement)vector2.get(0);
            if (!targetElement2.equals(targetElement)) continue;
            return vector2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTargets(WSDLComponent wSDLComponent, Vector<Vector> vector) {
        if (wSDLComponent == null) {
            return;
        }
        WSDLModel wSDLModel = wSDLComponent.getModel();
        Policy policy = null;
        policy = wSDLComponent instanceof Policy ? (Policy)wSDLComponent : PolicyModelHelper.getPolicyForElement(wSDLComponent);
        EncryptedParts encryptedParts = (EncryptedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, EncryptedParts.class);
        SignedParts signedParts = (SignedParts)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SignedParts.class);
        EncryptedElements encryptedElements = (EncryptedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, EncryptedElements.class);
        SignedElements signedElements = (SignedElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, SignedElements.class);
        RequiredElements requiredElements = (RequiredElements)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, RequiredElements.class);
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            Object object = null;
            if (encryptedParts != null) {
                object = (WSDLComponent)encryptedParts.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)encryptedParts);
                encryptedParts = null;
            }
            if (signedParts != null) {
                object = (WSDLComponent)signedParts.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)signedParts);
                signedParts = null;
            }
            if (encryptedElements != null) {
                object = (WSDLComponent)encryptedElements.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)encryptedElements);
                encryptedElements = null;
            }
            if (signedElements != null) {
                object = (WSDLComponent)signedElements.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)signedElements);
                signedElements = null;
            }
            if (requiredElements != null) {
                object = (WSDLComponent)requiredElements.getParent();
                object.removeExtensibilityElement((ExtensibilityElement)requiredElements);
                requiredElements = null;
            }
            if (vector == null) {
                return;
            }
            object = policy == null ? PolicyModelHelper.createPolicy(wSDLComponent, true) : (!(wSDLComponent instanceof Policy) ? PolicyModelHelper.createTopExactlyOneAll(policy) : policy);
            boolean bl2 = true;
            for (Vector vector2 : vector) {
                TargetElement targetElement = (TargetElement)vector2.get(0);
                boolean bl3 = (Boolean)vector2.get(2);
                boolean bl4 = (Boolean)vector2.get(1);
                boolean bl5 = (Boolean)vector2.get(3);
                if (targetElement instanceof MessageHeader) {
                    if (bl3) {
                        if (encryptedParts == null) {
                            encryptedParts = (EncryptedParts)PolicyModelHelper.createElement(object, SecurityPolicyQName.ENCRYPTEDPARTS.getQName(), EncryptedParts.class, false);
                        }
                        SecurityPolicyModelHelper.addHeaderElementForListItem(targetElement.toString(), (WSDLComponent)encryptedParts, wSDLComponentFactory);
                    }
                    if (!bl4) continue;
                    if (signedParts == null) {
                        signedParts = (SignedParts)PolicyModelHelper.createElement(object, SecurityPolicyQName.SIGNEDPARTS.getQName(), SignedParts.class, false);
                    }
                    SecurityPolicyModelHelper.addHeaderElementForListItem(targetElement.toString(), (WSDLComponent)signedParts, wSDLComponentFactory);
                    continue;
                }
                if (targetElement instanceof MessageElement) {
                    bl2 = false;
                    if (bl3) {
                        if (encryptedElements == null) {
                            encryptedElements = (EncryptedElements)PolicyModelHelper.createElement(object, SecurityPolicyQName.ENCRYPTEDELEMENTS.getQName(), EncryptedElements.class, false);
                        }
                        SecurityPolicyModelHelper.addElementForListItem(targetElement.toString(), (WSDLComponent)encryptedElements, wSDLComponentFactory);
                    }
                    if (bl4) {
                        if (signedElements == null) {
                            signedElements = (SignedElements)PolicyModelHelper.createElement(object, SecurityPolicyQName.SIGNEDELEMENTS.getQName(), SignedElements.class, false);
                        }
                        SecurityPolicyModelHelper.addElementForListItem(targetElement.toString(), (WSDLComponent)signedElements, wSDLComponentFactory);
                    }
                    if (!bl5) continue;
                    if (requiredElements == null) {
                        requiredElements = (RequiredElements)PolicyModelHelper.createElement(object, SecurityPolicyQName.REQUIREDELEMENTS.getQName(), RequiredElements.class, false);
                    }
                    SecurityPolicyModelHelper.addElementForListItem(targetElement.toString(), (WSDLComponent)requiredElements, wSDLComponentFactory);
                    continue;
                }
                if (!(targetElement instanceof MessageBody)) continue;
                if (bl3) {
                    if (encryptedParts == null) {
                        encryptedParts = (EncryptedParts)PolicyModelHelper.createElement(object, SecurityPolicyQName.ENCRYPTEDPARTS.getQName(), EncryptedParts.class, false);
                    }
                    SecurityPolicyModelHelper.addBody((WSDLComponent)encryptedParts, wSDLComponentFactory);
                }
                if (!bl4) continue;
                if (signedParts == null) {
                    signedParts = (SignedParts)PolicyModelHelper.createElement(object, SecurityPolicyQName.SIGNEDPARTS.getQName(), SignedParts.class, false);
                }
                SecurityPolicyModelHelper.addBody((WSDLComponent)signedParts, wSDLComponentFactory);
            }
            if (wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
                Binding binding = (Binding)((WSDLComponent)wSDLComponent.getParent()).getParent();
                ProprietarySecurityPolicyModelHelper.setStreamingSecurity(binding, bl2);
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }

    public static MessageHeader getListModelForHeader(Header header) {
        String string = header.getName();
        if ("To".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_TO);
        }
        if ("From".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_FROM);
        }
        if ("FaultTo".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_FAULTTO);
        }
        if ("ReplyTo".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_REPLYTO);
        }
        if ("MessageID".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_MESSAGEID);
        }
        if ("RelatesTo".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_RELATESTO);
        }
        if ("Action".equals(string)) {
            return new MessageHeader(MessageHeader.ADDRESSING_ACTION);
        }
        if ("AckRequested".equals(string)) {
            return new MessageHeader(MessageHeader.RM_ACKREQUESTED);
        }
        if ("SequenceAcknowledgement".equals(string)) {
            return new MessageHeader(MessageHeader.RM_SEQUENCEACK);
        }
        if ("Sequence".equals(string)) {
            return new MessageHeader(MessageHeader.RM_SEQUENCE);
        }
        return null;
    }

    public static MessageElement getListModelForXPath(XPath xPath) {
        String string = xPath.getXPath();
        return new MessageElement(string);
    }

    public static ExtensibilityElement addHeaderElementForListItem(String string, WSDLComponent wSDLComponent, WSDLComponentFactory wSDLComponentFactory) {
        Header header = (Header)wSDLComponentFactory.create(wSDLComponent, SecurityPolicyQName.HEADER.getQName());
        if (MessageHeader.ADDRESSING_TO.equals(string)) {
            header.setName("To");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_FROM.equals(string)) {
            header.setName("From");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_FAULTTO.equals(string)) {
            header.setName("FaultTo");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_REPLYTO.equals(string)) {
            header.setName("ReplyTo");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_MESSAGEID.equals(string)) {
            header.setName("MessageID");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_RELATESTO.equals(string)) {
            header.setName("RelatesTo");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.ADDRESSING_ACTION.equals(string)) {
            header.setName("Action");
            header.setNamespace("http://www.w3.org/2005/08/addressing");
        }
        if (MessageHeader.RM_ACKREQUESTED.equals(string)) {
            header.setName("AckRequested");
            header.setNamespace("http://schemas.xmlsoap.org/ws/2005/02/rm");
        }
        if (MessageHeader.RM_SEQUENCEACK.equals(string)) {
            header.setName("SequenceAcknowledgement");
            header.setNamespace("http://schemas.xmlsoap.org/ws/2005/02/rm");
        }
        if (MessageHeader.RM_SEQUENCE.equals(string)) {
            header.setName("Sequence");
            header.setNamespace("http://schemas.xmlsoap.org/ws/2005/02/rm");
        }
        if (header != null) {
            wSDLComponent.addExtensibilityElement((ExtensibilityElement)header);
        }
        return header;
    }

    public static ExtensibilityElement addElementForListItem(String string, WSDLComponent wSDLComponent, WSDLComponentFactory wSDLComponentFactory) {
        XPath xPath = null;
        xPath = (XPath)wSDLComponentFactory.create(wSDLComponent, SecurityPolicyQName.XPATH.getQName());
        if (xPath != null) {
            wSDLComponent.addExtensibilityElement((ExtensibilityElement)xPath);
            xPath.setXPath(string);
        }
        return xPath;
    }

    public static ExtensibilityElement addBody(WSDLComponent wSDLComponent, WSDLComponentFactory wSDLComponentFactory) {
        Body body = null;
        body = (Body)wSDLComponentFactory.create(wSDLComponent, SecurityPolicyQName.BODY.getQName());
        wSDLComponent.addExtensibilityElement((ExtensibilityElement)body);
        return body;
    }

    public static String getSecurityBindingType(WSDLComponent wSDLComponent) {
        assert (wSDLComponent != null);
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        if (extensibilityElement instanceof SymmetricBinding) {
            return ComboConstants.SYMMETRIC;
        }
        if (extensibilityElement instanceof AsymmetricBinding) {
            return ComboConstants.ASYMMETRIC;
        }
        if (extensibilityElement instanceof TransportBinding) {
            return ComboConstants.TRANSPORT;
        }
        return ComboConstants.NOSECURITY;
    }

    public static ExtensibilityElement getSecurityBindingTypeElement(WSDLComponent wSDLComponent) {
        assert (wSDLComponent != null);
        Object object = wSDLComponent;
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation || wSDLComponent instanceof BindingInput || wSDLComponent instanceof BindingOutput || wSDLComponent instanceof BindingFault) {
            object = PolicyModelHelper.getPolicyForElement(wSDLComponent);
        } else if (wSDLComponent instanceof BootstrapPolicy) {
            object = PolicyModelHelper.getTopLevelElement(wSDLComponent, Policy.class);
        }
        Object object2 = PolicyModelHelper.getTopLevelElement(object, SymmetricBinding.class);
        if (object2 != null) {
            return object2;
        }
        object2 = (AsymmetricBinding)PolicyModelHelper.getTopLevelElement(object, AsymmetricBinding.class);
        if (object2 != null) {
            return object2;
        }
        object2 = (TransportBinding)PolicyModelHelper.getTopLevelElement(object, TransportBinding.class);
        if (object2 != null) {
            return object2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDLComponent setSecurityBindingType(WSDLComponent wSDLComponent, String string) {
        assert (wSDLComponent != null);
        WSDLModel wSDLModel = wSDLComponent.getModel();
        SymmetricBinding symmetricBinding = null;
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        All all = PolicyModelHelper.createPolicy(wSDLComponent, true);
        try {
            SymmetricBinding symmetricBinding2 = (SymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)all, SymmetricBinding.class);
            AsymmetricBinding asymmetricBinding = (AsymmetricBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)all, AsymmetricBinding.class);
            TransportBinding transportBinding = (TransportBinding)PolicyModelHelper.getTopLevelElement((WSDLComponent)all, TransportBinding.class);
            if (symmetricBinding2 != null) {
                ((WSDLComponent)symmetricBinding2.getParent()).removeExtensibilityElement((ExtensibilityElement)symmetricBinding2);
            }
            if (asymmetricBinding != null) {
                ((WSDLComponent)asymmetricBinding.getParent()).removeExtensibilityElement((ExtensibilityElement)asymmetricBinding);
            }
            if (transportBinding != null) {
                ((WSDLComponent)transportBinding.getParent()).removeExtensibilityElement((ExtensibilityElement)transportBinding);
            }
            if (ComboConstants.SYMMETRIC.equals(string)) {
                symmetricBinding = symmetricBinding2 = (SymmetricBinding)PolicyModelHelper.createElement((WSDLComponent)all, SecurityPolicyQName.SYMMETRICBINDING.getQName(), SymmetricBinding.class, false);
            }
            if (ComboConstants.ASYMMETRIC.equals(string)) {
                asymmetricBinding = (AsymmetricBinding)PolicyModelHelper.createElement((WSDLComponent)all, SecurityPolicyQName.ASYMMETRICBINDING.getQName(), AsymmetricBinding.class, false);
                symmetricBinding = asymmetricBinding;
            }
            if (ComboConstants.TRANSPORT.equals(string)) {
                transportBinding = (TransportBinding)PolicyModelHelper.createElement((WSDLComponent)all, SecurityPolicyQName.TRANSPORTBINDING.getQName(), TransportBinding.class, false);
                symmetricBinding = transportBinding;
            }
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
        return symmetricBinding;
    }

    public static void setDefaultTargets(WSDLComponent wSDLComponent, boolean bl, boolean bl2) {
        Vector<Vector> vector = new Vector<Vector>();
        Vector<Object> vector2 = new Vector<Object>();
        MessageBody messageBody = new MessageBody();
        vector2.add(0, messageBody);
        vector2.add(1, Boolean.TRUE);
        vector2.add(2, Boolean.TRUE);
        vector2.add(3, Boolean.FALSE);
        vector.add(vector2);
        if (bl) {
            MessageHeader messageHeader;
            for (String string : MessageHeader.ADDRESSING_HEADERS) {
                vector2 = new Vector();
                messageHeader = new MessageHeader(string);
                vector2.add(0, messageHeader);
                vector2.add(1, Boolean.TRUE);
                vector2.add(2, Boolean.FALSE);
                vector2.add(3, Boolean.FALSE);
                vector.add(vector2);
            }
            for (String string : MessageHeader.RM_HEADERS) {
                vector2 = new Vector();
                messageHeader = new MessageHeader(string);
                vector2.add(0, messageHeader);
                vector2.add(1, Boolean.TRUE);
                vector2.add(2, Boolean.FALSE);
                vector2.add(3, Boolean.FALSE);
                vector.add(vector2);
            }
        }
        SecurityPolicyModelHelper.setTargets(wSDLComponent, vector);
    }

    public static void removeTargets(WSDLComponent wSDLComponent) {
        SecurityPolicyModelHelper.setTargets(wSDLComponent, null);
    }

    public static String getComboItemForElement(WSDLComponent wSDLComponent) {
        String string = wSDLComponent.getClass().getSimpleName();
        String string2 = "COMBO_" + string.substring(0, string.length() - 4);
        return NbBundle.getMessage(ComboConstants.class, (String)string2);
    }

    public static String getMessageLayout(WSDLComponent wSDLComponent) {
        WSDLComponent wSDLComponent2 = SecurityPolicyModelHelper.getMessageLayoutElement(wSDLComponent);
        if (wSDLComponent2 != null) {
            if (wSDLComponent2 instanceof Strict) {
                return ComboConstants.STRICT;
            }
            if (wSDLComponent2 instanceof Lax) {
                return ComboConstants.LAX;
            }
            if (wSDLComponent2 instanceof LaxTsFirst) {
                return ComboConstants.LAXTSFIRST;
            }
            if (wSDLComponent2 instanceof LaxTsLast) {
                return ComboConstants.LAXTSLAST;
            }
        }
        return null;
    }

    public static WSDLComponent getMessageLayoutElement(WSDLComponent wSDLComponent) {
        List list;
        if (wSDLComponent instanceof Binding || wSDLComponent instanceof BindingOperation) {
            wSDLComponent = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        }
        if (wSDLComponent == null) {
            return null;
        }
        Policy policy = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent, Policy.class);
        Layout layout = (Layout)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, Layout.class);
        if ((policy = (Policy)PolicyModelHelper.getTopLevelElement((WSDLComponent)layout, Policy.class)) != null && (list = policy.getExtensibilityElements()) != null && !list.isEmpty()) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(0);
            return extensibilityElement;
        }
        return null;
    }

    public static boolean isIncludeTimestamp(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        if (extensibilityElement != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(extensibilityElement, IncludeTimestamp.class);
        }
        return false;
    }

    public static boolean isEncryptBeforeSigning(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        if (extensibilityElement != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(extensibilityElement, EncryptBeforeSigning.class);
        }
        return false;
    }

    public static boolean isEncryptSignature(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        if (extensibilityElement != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(extensibilityElement, EncryptSignature.class);
        }
        return false;
    }

    public static boolean isSignEntireHeadersAndBody(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        if (extensibilityElement != null) {
            return SecurityPolicyModelHelper.isAttributeEnabled(extensibilityElement, OnlySignEntireHeadersAndBody.class);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLayout(WSDLComponent wSDLComponent, String string) {
        WSDLModel wSDLModel = wSDLComponent.getModel();
        WSDLComponentFactory wSDLComponentFactory = wSDLModel.getFactory();
        boolean bl = wSDLModel.isIntransaction();
        if (!bl) {
            wSDLModel.startTransaction();
        }
        try {
            Policy policy2;
            QName qName = null;
            if (ComboConstants.STRICT.equals(string)) {
                qName = SecurityPolicyQName.STRICT.getQName();
            } else if (ComboConstants.LAX.equals(string)) {
                qName = SecurityPolicyQName.LAX.getQName();
            } else if (ComboConstants.LAXTSFIRST.equals(string)) {
                qName = SecurityPolicyQName.LAXTSFIRST.getQName();
            } else if (ComboConstants.LAXTSLAST.equals(string)) {
                qName = SecurityPolicyQName.LAXTSLAST.getQName();
            }
            Layout layout = (Layout)PolicyModelHelper.createElement(wSDLComponent, SecurityPolicyQName.LAYOUT.getQName(), Layout.class, true);
            List list = layout.getExtensibilityElements(Policy.class);
            if (list != null && !list.isEmpty()) {
                for (Policy policy2 : list) {
                    layout.removeExtensibilityElement((ExtensibilityElement)policy2);
                }
            }
            Policy policy3 = (Policy)PolicyModelHelper.createElement((WSDLComponent)layout, PolicyQName.POLICY.getQName(), Policy.class, false);
            policy2 = (ExtensibilityElement)wSDLComponentFactory.create((WSDLComponent)policy3, qName);
            policy3.addExtensibilityElement((ExtensibilityElement)policy2);
        }
        finally {
            if (!bl) {
                wSDLModel.endTransaction();
            }
        }
    }
}

