/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.rm.FlowControl;
import org.netbeans.modules.websvc.wsitmodelext.rm.InactivityTimeout;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMAssertion;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMQName;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

public class RMModelHelper {
    public static final String DEFAULT_TIMEOUT = "600000";
    public static final String DEFAULT_MAXRCVBUFFERSIZE = "32";

    public static RMAssertion getRMAssertion(Policy policy) {
        return (RMAssertion)PolicyModelHelper.getTopLevelElement((WSDLComponent)policy, RMAssertion.class);
    }

    public static boolean isRMEnabled(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Operation) {
            Operation operation = (Operation)wSDLComponent;
            Binding binding = (Binding)operation.getParent();
            return RMModelHelper.isRMEnabledB(binding);
        }
        if (wSDLComponent instanceof Binding) {
            return RMModelHelper.isRMEnabledB((Binding)wSDLComponent);
        }
        return false;
    }

    private static boolean isRMEnabledB(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        if (policy != null) {
            RMAssertion rMAssertion = RMModelHelper.getRMAssertion(policy);
            return rMAssertion != null;
        }
        return false;
    }

    public static void enableRM(Binding binding) {
        All all = PolicyModelHelper.createPolicy((WSDLComponent)binding, true);
        PolicyModelHelper.createElement((WSDLComponent)all, RMQName.RMASSERTION.getQName(), RMAssertion.class, false);
    }

    public static void disableRM(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        RMAssertion rMAssertion = RMModelHelper.getRMAssertion(policy);
        if (rMAssertion != null) {
            PolicyModelHelper.removeElement((WSDLComponent)rMAssertion.getParent(), RMAssertion.class, false);
            PolicyModelHelper.removeElement((WSDLComponent)rMAssertion.getParent(), FlowControl.class, false);
        }
        PolicyModelHelper.cleanPolicies((WSDLComponent)binding);
    }

    public static String getInactivityTimeout(Binding binding) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        RMAssertion rMAssertion = RMModelHelper.getRMAssertion(policy);
        return RMModelHelper.getInactivityTimeout(rMAssertion);
    }

    public static String getInactivityTimeout(RMAssertion rMAssertion) {
        InactivityTimeout inactivityTimeout;
        String string = null;
        if (rMAssertion != null && (inactivityTimeout = rMAssertion.getInactivityTimeout()) != null) {
            string = inactivityTimeout.getMilliseconds();
        }
        return string;
    }

    public static void setInactivityTimeout(Binding binding, String string) {
        Policy policy = PolicyModelHelper.getPolicyForElement((WSDLComponent)binding);
        RMAssertion rMAssertion = RMModelHelper.getRMAssertion(policy);
        RMModelHelper.setInactivityTimeout(rMAssertion, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInactivityTimeout(RMAssertion rMAssertion, String string) {
        if (rMAssertion != null) {
            WSDLModel wSDLModel = rMAssertion.getModel();
            boolean bl = wSDLModel.isIntransaction();
            if (!bl) {
                wSDLModel.startTransaction();
            }
            try {
                InactivityTimeout inactivityTimeout = rMAssertion.getInactivityTimeout();
                if (inactivityTimeout == null) {
                    if (string != null) {
                        WSDLComponentFactory wSDLComponentFactory = rMAssertion.getModel().getFactory();
                        InactivityTimeout inactivityTimeout2 = (InactivityTimeout)wSDLComponentFactory.create((WSDLComponent)rMAssertion, RMQName.INACTIVITYTIMEOUT.getQName());
                        inactivityTimeout2.setMilliseconds(string);
                        rMAssertion.addExtensibilityElement((ExtensibilityElement)inactivityTimeout2);
                    }
                } else if (string == null) {
                    rMAssertion.removeInactivityTimeout(inactivityTimeout);
                } else {
                    inactivityTimeout.setMilliseconds(string);
                }
            }
            finally {
                if (!bl) {
                    wSDLModel.endTransaction();
                }
            }
        }
    }
}

