/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.HttpsToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.TransportToken;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TransportSecurity
extends JPanel {
    private boolean inSync = false;
    private WSDLComponent comp;
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox requireCertificateChBox;

    public TransportSecurity(WSDLComponent wSDLComponent) {
        this.initComponents();
        this.comp = wSDLComponent;
        this.inSync = true;
        this.layoutCombo.removeAllItems();
        this.layoutCombo.addItem(ComboConstants.STRICT);
        this.layoutCombo.addItem(ComboConstants.LAX);
        this.layoutCombo.addItem(ComboConstants.LAXTSFIRST);
        this.layoutCombo.addItem(ComboConstants.LAXTSLAST);
        this.algoSuiteCombo.removeAllItems();
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDES);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESRSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256RSA15);
        this.inSync = false;
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, TransportToken.class);
        HttpsToken httpsToken = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        if (httpsToken instanceof HttpsToken) {
            this.setChBox(this.requireCertificateChBox, SecurityTokensModelHelper.isRequireClientCertificate(httpsToken));
        }
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)extensibilityElement));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout(this.comp));
        this.inSync = false;
    }

    public void setValue(JComponent jComponent) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        if (jComponent.equals(this.requireCertificateChBox)) {
            WSDLComponent wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, TransportToken.class);
            HttpsToken httpsToken = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
            SecurityTokensModelHelper.setRequireClientCertificate(httpsToken, this.requireCertificateChBox.isSelected());
        }
        if (jComponent.equals(this.layoutCombo)) {
            SecurityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement, (String)this.layoutCombo.getSelectedItem());
        }
        if (jComponent.equals(this.algoSuiteCombo)) {
            AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement, (String)this.algoSuiteCombo.getSelectedItem());
        }
    }

    private void setCombo(JComboBox jComboBox, String string) {
        if (string == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void initComponents() {
        this.requireCertificateChBox = new JCheckBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        Mnemonics.setLocalizedText((AbstractButton)this.requireCertificateChBox, (String)NbBundle.getMessage(TransportSecurity.class, (String)"LBL_RequireClientCertificate"));
        this.requireCertificateChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.requireCertificateChBox.setMargin(new Insets(0, 0, 0, 0));
        this.requireCertificateChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransportSecurity.this.requireCertificateChBoxActionPerformed(actionEvent);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(TransportSecurity.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransportSecurity.this.algoSuiteComboActionPerformed(actionEvent);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(TransportSecurity.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransportSecurity.this.layoutComboActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.layoutLabel).add((Component)this.algoSuiteLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.layoutCombo, -2, -1, -2).add((Component)this.algoSuiteCombo, -2, -1, -2))).add((Component)this.requireCertificateChBox)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.requireCertificateChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo}, 2);
    }

    private void layoutComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.algoSuiteCombo);
    }

    private void requireCertificateChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.requireCertificateChBox);
    }
}

