/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.InitiatorToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RecipientToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SenderVouches
extends JPanel {
    private boolean inSync = false;
    private WSDLComponent comp;
    private SecurityProfile secProfile = null;
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JCheckBox derivedKeysChBox;
    private JCheckBox encryptOrderChBox;
    private JCheckBox encryptSignatureChBox;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqDerivedKeys;
    private JComboBox samlVersionCombo;
    private JLabel samlVersionLabel;
    private JCheckBox secConvChBox;

    public SenderVouches(WSDLComponent wSDLComponent, SecurityProfile securityProfile) {
        this.initComponents();
        this.comp = wSDLComponent;
        this.secProfile = securityProfile;
        this.inSync = true;
        this.layoutCombo.removeAllItems();
        this.layoutCombo.addItem(ComboConstants.STRICT);
        this.layoutCombo.addItem(ComboConstants.LAX);
        this.layoutCombo.addItem(ComboConstants.LAXTSFIRST);
        this.layoutCombo.addItem(ComboConstants.LAXTSLAST);
        this.samlVersionCombo.removeAllItems();
        this.samlVersionCombo.addItem(ComboConstants.SAML_V1010);
        this.samlVersionCombo.addItem(ComboConstants.SAML_V1011);
        this.samlVersionCombo.addItem(ComboConstants.SAML_V1110);
        this.samlVersionCombo.addItem(ComboConstants.SAML_V1111);
        this.samlVersionCombo.addItem(ComboConstants.SAML_V2011);
        this.algoSuiteCombo.removeAllItems();
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDES);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESRSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256RSA15);
        this.inSync = false;
        this.sync();
    }

    private void sync() {
        Policy policy;
        this.inSync = true;
        ExtensibilityElement extensibilityElement = null;
        WSDLComponent wSDLComponent = null;
        ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement2, ProtectionToken.class);
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        boolean bl = wSDLComponent3 instanceof SecureConversationToken;
        if (bl) {
            wSDLComponent = SecurityTokensModelHelper.getTokenElement(wSDLComponent3, BootstrapPolicy.class);
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
            this.setChBox(this.secConvChBox, true);
            this.setChBox(this.derivedKeysChBox, SecurityPolicyModelHelper.isRequireDerivedKeys(wSDLComponent3));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(wSDLComponent));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(wSDLComponent));
        } else {
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            this.setChBox(this.secConvChBox, false);
            this.setChBox(this.derivedKeysChBox, false);
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(this.comp));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(this.comp));
        }
        String string = null;
        WSDLComponent wSDLComponent4 = null;
        if (bl) {
            policy = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent, Policy.class);
            wSDLComponent4 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)policy, 1);
        } else {
            wSDLComponent4 = SecurityTokensModelHelper.getSupportingToken(this.comp, 1);
        }
        policy = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent4);
        string = SecurityTokensModelHelper.getTokenProfileVersion((WSDLComponent)policy);
        this.setCombo(this.samlVersionCombo, string);
        wSDLComponent4 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, RecipientToken.class);
        policy = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent4);
        this.setChBox(this.reqDerivedKeys, SecurityPolicyModelHelper.isRequireDerivedKeys((WSDLComponent)policy));
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)extensibilityElement));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout((WSDLComponent)extensibilityElement));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent jComponent) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement extensibilityElement = null;
        WSDLComponent wSDLComponent = null;
        ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement2, ProtectionToken.class);
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        boolean bl = wSDLComponent3 instanceof SecureConversationToken;
        if (jComponent.equals(this.secConvChBox)) {
            ((SecureConversationFeature)((Object)this.secProfile)).enableSecureConversation(this.comp, this.secConvChBox.isSelected());
            this.sync();
        }
        if (bl) {
            wSDLComponent = SecurityTokensModelHelper.getTokenElement(wSDLComponent3, BootstrapPolicy.class);
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
            if (jComponent.equals(this.derivedKeysChBox)) {
                SecurityPolicyModelHelper.enableRequireDerivedKeys(wSDLComponent3, this.derivedKeysChBox.isSelected());
            }
        } else {
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        }
        if (jComponent.equals(this.encryptSignatureChBox)) {
            SecurityPolicyModelHelper.enableEncryptSignature((WSDLComponent)extensibilityElement, this.encryptSignatureChBox.isSelected());
            if (bl) {
                SecurityPolicyModelHelper.enableEncryptSignature((WSDLComponent)extensibilityElement2, this.encryptSignatureChBox.isSelected());
            }
        }
        if (jComponent.equals(this.encryptOrderChBox)) {
            SecurityPolicyModelHelper.enableEncryptBeforeSigning((WSDLComponent)extensibilityElement, this.encryptOrderChBox.isSelected());
            if (bl) {
                SecurityPolicyModelHelper.enableEncryptBeforeSigning((WSDLComponent)extensibilityElement2, this.encryptOrderChBox.isSelected());
            }
        }
        if (jComponent.equals(this.layoutCombo)) {
            SecurityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement, (String)this.layoutCombo.getSelectedItem());
            if (bl) {
                SecurityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement2, (String)this.layoutCombo.getSelectedItem());
            }
        }
        if (jComponent.equals(this.algoSuiteCombo)) {
            AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement, (String)this.algoSuiteCombo.getSelectedItem());
            if (bl) {
                AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement2, (String)this.algoSuiteCombo.getSelectedItem());
            }
        }
        if (jComponent.equals(this.reqDerivedKeys)) {
            WSDLComponent wSDLComponent4 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, RecipientToken.class);
            WSDLComponent wSDLComponent5 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent4);
            SecurityPolicyModelHelper.enableRequireDerivedKeys(wSDLComponent5, this.reqDerivedKeys.isSelected());
            wSDLComponent4 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, InitiatorToken.class);
            wSDLComponent5 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent4);
            SecurityPolicyModelHelper.enableRequireDerivedKeys(wSDLComponent5, this.reqDerivedKeys.isSelected());
            return;
        }
        if (jComponent.equals(this.samlVersionCombo)) {
            Policy policy;
            WSDLComponent wSDLComponent6 = null;
            if (bl) {
                policy = (Policy)PolicyModelHelper.getTopLevelElement(wSDLComponent, Policy.class);
                wSDLComponent6 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)policy, 1);
            } else {
                wSDLComponent6 = SecurityTokensModelHelper.getSupportingToken(this.comp, 1);
            }
            policy = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent6);
            SecurityTokensModelHelper.setTokenProfileVersion((WSDLComponent)policy, (String)this.samlVersionCombo.getSelectedItem());
        }
        this.enableDisable();
    }

    private void enableDisable() {
        boolean bl = this.secConvChBox.isSelected();
        this.derivedKeysChBox.setEnabled(bl);
    }

    private void setCombo(JComboBox jComboBox, String string) {
        if (string == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void initComponents() {
        this.secConvChBox = new JCheckBox();
        this.derivedKeysChBox = new JCheckBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.encryptSignatureChBox = new JCheckBox();
        this.reqDerivedKeys = new JCheckBox();
        this.encryptOrderChBox = new JCheckBox();
        this.samlVersionCombo = new JComboBox();
        this.samlVersionLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.secConvChBox, (String)NbBundle.getMessage(SenderVouches.class, (String)"LBL_SecConvLabel"));
        this.secConvChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.secConvChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SenderVouches.this.secConvChBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.derivedKeysChBox, (String)NbBundle.getMessage(SenderVouches.class, (String)"LBL_RequireDerivedKeysForSecConv"));
        this.derivedKeysChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.derivedKeysChBox.setMargin(new Insets(0, 0, 0, 0));
        this.derivedKeysChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SenderVouches.this.derivedKeysChBoxActionPerformed(actionEvent);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(SenderVouches.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SenderVouches.this.algoSuiteComboActionPerformed(actionEvent);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(SenderVouches.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SenderVouches.this.layoutComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptSignatureChBox, (String)NbBundle.getMessage(SenderVouches.class, (String)"LBL_EncryptSignatureLabel"));
        this.encryptSignatureChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptSignatureChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptSignatureChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SenderVouches.this.encryptSignatureChBox(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqDerivedKeys, (String)NbBundle.getMessage(SenderVouches.class, (String)"LBL_RequireDerivedKeys"));
        this.reqDerivedKeys.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqDerivedKeys.setMargin(new Insets(0, 0, 0, 0));
        this.reqDerivedKeys.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SenderVouches.this.reqDerivedKeysActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptOrderChBox, (String)NbBundle.getMessage(SenderVouches.class, (String)"LBL_EncryptOrderLabel"));
        this.encryptOrderChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptOrderChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptOrderChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SenderVouches.this.encryptOrderChBoxActionPerformed(actionEvent);
            }
        });
        this.samlVersionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SenderVouches.this.samlVersionComboActionPerformed(actionEvent);
            }
        });
        this.samlVersionLabel.setLabelFor(this.samlVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.samlVersionLabel, (String)NbBundle.getMessage(SenderVouches.class, (String)"LBL_SamlVersion"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.reqDerivedKeys).add((Component)this.secConvChBox).add((Component)this.derivedKeysChBox).add((Component)this.encryptSignatureChBox).add((Component)this.encryptOrderChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.layoutLabel).add((Component)this.algoSuiteLabel).add((Component)this.samlVersionLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.samlVersionCombo, -2, -1, -2).add((Component)this.algoSuiteCombo, -2, -1, -2).add((Component)this.layoutCombo, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo, this.samlVersionCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.samlVersionLabel).add((Component)this.samlVersionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.reqDerivedKeys).addPreferredGap(0).add((Component)this.secConvChBox).addPreferredGap(0).add((Component)this.derivedKeysChBox).addPreferredGap(0).add((Component)this.encryptSignatureChBox).addPreferredGap(0).add((Component)this.encryptOrderChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo, this.samlVersionCombo}, 2);
    }

    private void samlVersionComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.samlVersionCombo);
    }

    private void encryptOrderChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.encryptOrderChBox);
    }

    private void reqDerivedKeysActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.reqDerivedKeys);
    }

    private void derivedKeysChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.derivedKeysChBox);
    }

    private void secConvChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.secConvChBox);
    }

    private void encryptSignatureChBox(ActionEvent actionEvent) {
        this.setValue(this.encryptSignatureChBox);
    }

    private void layoutComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.algoSuiteCombo);
    }
}

