/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.HttpsToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.TransportToken;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SAMLAuthorizationOverSSL
extends JPanel
implements ComboConstants {
    private boolean inSync = false;
    private WSDLComponent comp;
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqClientCertChBox;
    private JCheckBox reqSigConfChBox;
    private JComboBox samlVersionCombo;
    private JLabel samlVersionLabel;
    private JComboBox wssVersionCombo;
    private JLabel wssVersionLabel;

    public SAMLAuthorizationOverSSL(WSDLComponent wSDLComponent) {
        this.initComponents();
        this.comp = wSDLComponent;
        this.inSync = true;
        this.samlVersionCombo.removeAllItems();
        this.samlVersionCombo.addItem(ComboConstants.SAML_V1010);
        this.samlVersionCombo.addItem(ComboConstants.SAML_V1011);
        this.samlVersionCombo.addItem(ComboConstants.SAML_V1110);
        this.samlVersionCombo.addItem(ComboConstants.SAML_V1111);
        this.samlVersionCombo.addItem(ComboConstants.SAML_V2011);
        this.wssVersionCombo.removeAllItems();
        this.wssVersionCombo.addItem(ComboConstants.WSS10);
        this.wssVersionCombo.addItem(ComboConstants.WSS11);
        this.layoutCombo.removeAllItems();
        this.layoutCombo.addItem(ComboConstants.STRICT);
        this.layoutCombo.addItem(ComboConstants.LAX);
        this.layoutCombo.addItem(ComboConstants.LAXTSFIRST);
        this.layoutCombo.addItem(ComboConstants.LAXTSLAST);
        this.algoSuiteCombo.removeAllItems();
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDES);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESRSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256RSA15);
        this.inSync = false;
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        if (this.comp instanceof Binding) {
            WSDLComponent wSDLComponent = SecurityTokensModelHelper.getSupportingToken(this.comp, 1);
            WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
            String string = SecurityTokensModelHelper.getTokenProfileVersion(wSDLComponent2);
            this.setCombo(this.samlVersionCombo, string);
        }
        this.setCombo(this.wssVersionCombo, SecurityPolicyModelHelper.isWss11(this.comp));
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)extensibilityElement));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout(this.comp));
        this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation(this.comp));
        this.enableDisable();
        this.inSync = false;
    }

    private void enableDisable() {
        boolean bl = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
        this.reqSigConfChBox.setEnabled(bl);
    }

    public void setValue(JComponent jComponent) {
        HttpsToken httpsToken;
        WSDLComponent wSDLComponent;
        if (this.inSync) {
            return;
        }
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        if (jComponent.equals(this.reqClientCertChBox)) {
            wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, TransportToken.class);
            httpsToken = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
            SecurityTokensModelHelper.setRequireClientCertificate(httpsToken, this.reqClientCertChBox.isSelected());
        }
        if (jComponent.equals(this.reqSigConfChBox)) {
            SecurityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
        }
        if (jComponent.equals(this.layoutCombo)) {
            SecurityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement, (String)this.layoutCombo.getSelectedItem());
        }
        if (jComponent.equals(this.algoSuiteCombo)) {
            AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement, (String)this.algoSuiteCombo.getSelectedItem());
        }
        if (jComponent.equals(this.wssVersionCombo)) {
            boolean bl = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
            httpsToken = SecurityPolicyModelHelper.enableWss(this.comp, bl);
            if (bl) {
                SecurityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
            }
            SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier((WssElement)httpsToken, true);
        }
        if (jComponent.equals(this.samlVersionCombo) && this.comp instanceof Binding) {
            wSDLComponent = SecurityTokensModelHelper.getSupportingToken(this.comp, 1);
            httpsToken = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
            SecurityTokensModelHelper.setTokenProfileVersion((WSDLComponent)httpsToken, (String)this.samlVersionCombo.getSelectedItem());
        }
        this.enableDisable();
    }

    private void setCombo(JComboBox jComboBox, String string) {
        if (string == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    private void setCombo(JComboBox jComboBox, boolean bl) {
        jComboBox.setSelectedIndex(bl ? 1 : 0);
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void initComponents() {
        this.samlVersionLabel = new JLabel();
        this.samlVersionCombo = new JComboBox();
        this.reqSigConfChBox = new JCheckBox();
        this.reqClientCertChBox = new JCheckBox();
        this.wssVersionLabel = new JLabel();
        this.wssVersionCombo = new JComboBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.samlVersionLabel.setLabelFor(this.samlVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.samlVersionLabel, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_SamlVersion"));
        this.samlVersionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAMLAuthorizationOverSSL.this.samlVersionComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqSigConfChBox, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_RequireSigConfirmation"));
        this.reqSigConfChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqSigConfChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqSigConfChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAMLAuthorizationOverSSL.this.reqSigConfChBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqClientCertChBox, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_RequireClientCertificate"));
        this.reqClientCertChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqClientCertChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqClientCertChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAMLAuthorizationOverSSL.this.reqClientCertChBoxActionPerformed(actionEvent);
            }
        });
        this.wssVersionLabel.setLabelFor(this.wssVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.wssVersionLabel, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_WSSVersionLabel"));
        this.wssVersionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAMLAuthorizationOverSSL.this.wssVersionComboActionPerformed(actionEvent);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAMLAuthorizationOverSSL.this.algoSuiteComboActionPerformed(actionEvent);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAMLAuthorizationOverSSL.this.layoutComboActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.reqClientCertChBox).add((Component)this.reqSigConfChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.samlVersionLabel).add((Component)this.wssVersionLabel).add((Component)this.algoSuiteLabel).add((Component)this.layoutLabel)).add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.samlVersionCombo, -2, -1, -2).add(1, (Component)this.wssVersionCombo, -2, -1, -2).add(1, (Component)this.algoSuiteCombo, -2, -1, -2).add(1, (Component)this.layoutCombo, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo, this.samlVersionCombo, this.wssVersionCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.samlVersionLabel).add((Component)this.samlVersionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.wssVersionLabel).add((Component)this.wssVersionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.reqClientCertChBox).addPreferredGap(0).add((Component)this.reqSigConfChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo, this.samlVersionCombo, this.wssVersionCombo}, 2);
    }

    private void reqSigConfChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.reqSigConfChBox);
    }

    private void reqClientCertChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.reqClientCertChBox);
    }

    private void wssVersionComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.wssVersionCombo);
    }

    private void samlVersionComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.samlVersionCombo);
    }

    private void layoutComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.algoSuiteCombo);
    }
}

