/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EndorsingCertificate
extends JPanel {
    private boolean inSync = false;
    private WSDLComponent comp;
    private SecurityProfile secProfile = null;
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JCheckBox derivedKeysChBox;
    private JCheckBox encryptOrderChBox;
    private JCheckBox encryptSignatureChBox;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqSigConfChBox;
    private JCheckBox secConvChBox;

    public EndorsingCertificate(WSDLComponent wSDLComponent, SecurityProfile securityProfile) {
        this.initComponents();
        this.comp = wSDLComponent;
        this.secProfile = securityProfile;
        this.inSync = true;
        this.layoutCombo.removeAllItems();
        this.layoutCombo.addItem(ComboConstants.STRICT);
        this.layoutCombo.addItem(ComboConstants.LAX);
        this.layoutCombo.addItem(ComboConstants.LAXTSFIRST);
        this.layoutCombo.addItem(ComboConstants.LAXTSLAST);
        this.algoSuiteCombo.removeAllItems();
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDES);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESRSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC256SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC192SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.BASIC128SHA256RSA15);
        this.algoSuiteCombo.addItem(ComboConstants.TRIPLEDESSHA256RSA15);
        this.inSync = false;
        this.sync();
    }

    private void sync() {
        this.inSync = true;
        ExtensibilityElement extensibilityElement = null;
        ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement2, ProtectionToken.class);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        boolean bl = wSDLComponent2 instanceof SecureConversationToken;
        this.setChBox(this.secConvChBox, bl);
        if (bl) {
            WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenElement(wSDLComponent2, BootstrapPolicy.class);
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent3);
            Policy policy = (Policy)extensibilityElement.getParent();
            this.setChBox(this.derivedKeysChBox, SecurityPolicyModelHelper.isRequireDerivedKeys(wSDLComponent2));
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation((WSDLComponent)policy));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(wSDLComponent3));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(wSDLComponent3));
        } else {
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            this.setChBox(this.derivedKeysChBox, false);
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation(this.comp));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(this.comp));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(this.comp));
        }
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)extensibilityElement));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout((WSDLComponent)extensibilityElement));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent jComponent) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement extensibilityElement = null;
        ExtensibilityElement extensibilityElement2 = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent wSDLComponent = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement2, ProtectionToken.class);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent);
        boolean bl = wSDLComponent2 instanceof SecureConversationToken;
        if (jComponent.equals(this.secConvChBox)) {
            ((SecureConversationFeature)((Object)this.secProfile)).enableSecureConversation(this.comp, this.secConvChBox.isSelected());
            this.sync();
        }
        if (bl) {
            WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenElement(wSDLComponent2, BootstrapPolicy.class);
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent3);
            Policy policy = (Policy)extensibilityElement.getParent();
            if (jComponent.equals(this.reqSigConfChBox)) {
                SecurityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11((WSDLComponent)policy), this.reqSigConfChBox.isSelected());
            }
            if (jComponent.equals(this.derivedKeysChBox)) {
                SecurityPolicyModelHelper.enableRequireDerivedKeys(wSDLComponent2, this.derivedKeysChBox.isSelected());
            }
        } else {
            extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            if (jComponent.equals(this.reqSigConfChBox)) {
                SecurityPolicyModelHelper.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
            }
        }
        if (jComponent.equals(this.encryptSignatureChBox)) {
            SecurityPolicyModelHelper.enableEncryptSignature((WSDLComponent)extensibilityElement, this.encryptSignatureChBox.isSelected());
            if (bl) {
                SecurityPolicyModelHelper.enableEncryptSignature((WSDLComponent)extensibilityElement2, this.encryptSignatureChBox.isSelected());
            }
        }
        if (jComponent.equals(this.encryptOrderChBox)) {
            SecurityPolicyModelHelper.enableEncryptBeforeSigning((WSDLComponent)extensibilityElement, this.encryptOrderChBox.isSelected());
            if (bl) {
                SecurityPolicyModelHelper.enableEncryptBeforeSigning((WSDLComponent)extensibilityElement2, this.encryptOrderChBox.isSelected());
            }
        }
        if (jComponent.equals(this.layoutCombo)) {
            SecurityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement, (String)this.layoutCombo.getSelectedItem());
            if (bl) {
                SecurityPolicyModelHelper.setLayout((WSDLComponent)extensibilityElement2, (String)this.layoutCombo.getSelectedItem());
            }
        }
        if (jComponent.equals(this.algoSuiteCombo)) {
            AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement, (String)this.algoSuiteCombo.getSelectedItem());
            if (bl) {
                AlgoSuiteModelHelper.setAlgorithmSuite((WSDLComponent)extensibilityElement2, (String)this.algoSuiteCombo.getSelectedItem());
            }
        }
        this.enableDisable();
    }

    private void enableDisable() {
        boolean bl = this.secConvChBox.isSelected();
        this.derivedKeysChBox.setEnabled(bl);
    }

    private void setCombo(JComboBox jComboBox, String string) {
        if (string == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void initComponents() {
        this.secConvChBox = new JCheckBox();
        this.reqSigConfChBox = new JCheckBox();
        this.derivedKeysChBox = new JCheckBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.encryptSignatureChBox = new JCheckBox();
        this.encryptOrderChBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.secConvChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_SecConvLabel"));
        this.secConvChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.secConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.secConvChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EndorsingCertificate.this.secConvChBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqSigConfChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_RequireSigConfirmation"));
        this.reqSigConfChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqSigConfChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqSigConfChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EndorsingCertificate.this.reqSigConfChBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.derivedKeysChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_RequireDerivedKeysForSecConv"));
        this.derivedKeysChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.derivedKeysChBox.setMargin(new Insets(0, 0, 0, 0));
        this.derivedKeysChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EndorsingCertificate.this.derivedKeysChBoxActionPerformed(actionEvent);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EndorsingCertificate.this.algoSuiteComboActionPerformed(actionEvent);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EndorsingCertificate.this.layoutComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptSignatureChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_EncryptSignatureLabel"));
        this.encryptSignatureChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptSignatureChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptSignatureChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EndorsingCertificate.this.encryptSignatureChBox(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptOrderChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_EncryptOrderLabel"));
        this.encryptOrderChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.encryptOrderChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptOrderChBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EndorsingCertificate.this.encryptOrderChBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.reqSigConfChBox).add((Component)this.secConvChBox).add((Component)this.derivedKeysChBox).add((Component)this.encryptSignatureChBox).add((Component)this.encryptOrderChBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.layoutLabel).add((Component)this.algoSuiteLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.layoutCombo, -2, -1, -2).add((Component)this.algoSuiteCombo, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.algoSuiteLabel).add((Component)this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.layoutLabel).add((Component)this.layoutCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.secConvChBox).addPreferredGap(0).add((Component)this.derivedKeysChBox).addPreferredGap(0).add((Component)this.reqSigConfChBox).addPreferredGap(0).add((Component)this.encryptSignatureChBox).addPreferredGap(0).add((Component)this.encryptOrderChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.algoSuiteCombo, this.layoutCombo}, 2);
    }

    private void encryptOrderChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.encryptOrderChBox);
    }

    private void reqSigConfChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.reqSigConfChBox);
    }

    private void derivedKeysChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.derivedKeysChBox);
    }

    private void secConvChBoxActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.secConvChBox);
    }

    private void encryptSignatureChBox(ActionEvent actionEvent) {
        this.setValue(this.encryptSignatureChBox);
    }

    private void layoutComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent actionEvent) {
        this.setValue(this.algoSuiteCombo);
    }
}

