/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TxModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class OperationPanel
extends SectionInnerPanel {
    private WSDLModel model;
    private Node node;
    private BindingOperation operation;
    private boolean inSync = false;
    private Project project;
    private JComboBox txCombo;
    private JLabel txLbl;

    public OperationPanel(SectionView sectionView, Node node, Project project, BindingOperation bindingOperation) {
        super(sectionView);
        this.model = bindingOperation.getModel();
        this.node = node;
        this.project = project;
        this.operation = bindingOperation;
        this.initComponents();
        this.txCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.txLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addImmediateModifier(this.txCombo);
        this.inSync = true;
        this.txCombo.removeAllItems();
        this.txCombo.addItem(ComboConstants.TX_NOTSUPPORTED);
        this.txCombo.addItem(ComboConstants.TX_MANDATORY);
        this.txCombo.addItem(ComboConstants.TX_REQUIRED);
        this.txCombo.addItem(ComboConstants.TX_REQUIRESNEW);
        this.txCombo.addItem(ComboConstants.TX_SUPPORTED);
        this.inSync = false;
        this.sync();
        this.model.addComponentListener(new ComponentListener(){

            public void valueChanged(ComponentEvent componentEvent) {
                OperationPanel.this.sync();
            }

            public void childrenAdded(ComponentEvent componentEvent) {
                OperationPanel.this.sync();
            }

            public void childrenDeleted(ComponentEvent componentEvent) {
                OperationPanel.this.sync();
            }
        });
    }

    private void sync() {
        this.inSync = true;
        String string = TxModelHelper.getTx(this.operation, this.node);
        this.txCombo.setSelectedItem(string);
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent jComponent, Object object) {
        String string;
        if (this.inSync) {
            return;
        }
        if (jComponent.equals(this.txCombo) && (string = (String)this.txCombo.getSelectedItem()) != null && !string.equals(TxModelHelper.getTx(this.operation, this.node))) {
            TxModelHelper.setTx(this.operation, this.node, string);
        }
        this.enableDisable();
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        SectionView sectionView = this.getSectionView();
        this.enableDisable();
        if (sectionView != null) {
            sectionView.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return new JButton();
    }

    private void enableDisable() {
        boolean bl = Util.isTomcat(this.project);
        boolean bl2 = Util.isWebProject(this.project);
        boolean bl3 = !bl && bl2;
        this.txCombo.setEnabled(bl3);
        this.txLbl.setEnabled(bl3);
    }

    private void initComponents() {
        this.txLbl = new JLabel();
        this.txCombo = new JComboBox();
        this.txLbl.setLabelFor(this.txCombo);
        Mnemonics.setLocalizedText((JLabel)this.txLbl, (String)NbBundle.getMessage(OperationPanel.class, (String)"LBL_Section_Operation_Tx"));
        this.txCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Not Supported", "Required", "Requires New", "Mandatory", "Supported"}));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.txLbl).addPreferredGap(0).add((Component)this.txCombo, -2, -1, -2).addContainerGap(156, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.txLbl).add((Component)this.txCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.txLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OperationPanel.class, (String)"LBL_OperationPanel_Tx_ACSD"));
        this.txCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OperationPanel.class, (String)"LBL_OperationPanel_TxCombo_ACSN"));
        this.txCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OperationPanel.class, (String)"LBL_OperationPanel_TxCombo_ACSD"));
    }
}

