/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TargetsPanel;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputPanel<T extends WSDLComponent>
extends SectionInnerPanel {
    private WSDLModel model;
    private T input;
    private BindingOperation operation;
    private Binding binding;
    private UndoManager undoManager;
    private boolean inSync = false;
    private boolean signed = false;
    private boolean endorsing = false;
    private WSDLComponent tokenElement = null;
    private JCheckBox endorsingChBox;
    private JCheckBox signedChBox;
    private JButton targetsButton;
    private JComboBox tokenCombo;
    private JLabel tokenComboLabel;

    public InputPanel(SectionView sectionView, T t, UndoManager undoManager) {
        super(sectionView);
        this.model = t.getModel();
        this.input = t;
        this.operation = (BindingOperation)t.getParent();
        this.binding = (Binding)((WSDLComponent)t.getParent()).getParent();
        this.undoManager = undoManager;
        this.initComponents();
        this.tokenComboLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.tokenCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.signedChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.endorsingChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.addImmediateModifier(this.tokenCombo);
        this.addImmediateModifier(this.signedChBox);
        this.addImmediateModifier(this.endorsingChBox);
        this.inSync = true;
        this.tokenCombo.removeAllItems();
        this.tokenCombo.addItem("       ");
        this.tokenCombo.addItem(ComboConstants.USERNAME);
        this.tokenCombo.addItem(ComboConstants.X509);
        this.tokenCombo.addItem(ComboConstants.SAML);
        this.tokenCombo.addItem(ComboConstants.ISSUED);
        this.inSync = false;
        this.sync();
        this.model.addComponentListener(new ComponentListener(){

            public void valueChanged(ComponentEvent componentEvent) {
                InputPanel.this.sync();
            }

            public void childrenAdded(ComponentEvent componentEvent) {
                InputPanel.this.sync();
            }

            public void childrenDeleted(ComponentEvent componentEvent) {
                InputPanel.this.sync();
            }
        });
    }

    private void sync() {
        this.inSync = true;
        WSDLComponent wSDLComponent = SecurityTokensModelHelper.getSupportingToken(this.input, 0);
        if (wSDLComponent != null) {
            this.tokenElement = wSDLComponent;
            this.signed = false;
            this.endorsing = false;
        }
        if ((wSDLComponent = SecurityTokensModelHelper.getSupportingToken(this.input, 1)) != null) {
            this.tokenElement = wSDLComponent;
            this.signed = true;
            this.endorsing = false;
        }
        if ((wSDLComponent = SecurityTokensModelHelper.getSupportingToken(this.input, 2)) != null) {
            this.tokenElement = wSDLComponent;
            this.signed = false;
            this.endorsing = true;
        }
        if ((wSDLComponent = SecurityTokensModelHelper.getSupportingToken(this.input, 3)) != null) {
            this.tokenElement = wSDLComponent;
            this.signed = true;
            this.endorsing = true;
        }
        this.signedChBox.setSelected(this.signed);
        this.endorsingChBox.setSelected(this.endorsing);
        this.tokenCombo.setSelectedItem(SecurityTokensModelHelper.getTokenType(this.tokenElement));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent jComponent, Object object) {
        if (!this.inSync) {
            String string;
            if (jComponent.equals(this.tokenCombo)) {
                string = (String)this.tokenCombo.getSelectedItem();
                if (string != null) {
                    SecurityTokensModelHelper.removeSupportingTokens(this.input);
                    this.tokenElement = ComboConstants.USERNAME.equals(string) ? SecurityTokensModelHelper.setSupportingTokens(this.input, string, this.getSuppType(this.signed, false)) : SecurityTokensModelHelper.setSupportingTokens(this.input, string, this.getSuppType(this.signed, this.endorsing));
                }
                this.enableDisable();
            }
            if (jComponent.equals(this.signedChBox)) {
                string = (String)this.tokenCombo.getSelectedItem();
                this.signed = this.signedChBox.isSelected();
                SecurityTokensModelHelper.removeSupportingTokens(this.input);
                this.tokenElement = SecurityTokensModelHelper.setSupportingTokens(this.input, string, this.getSuppType(this.signed, this.endorsing));
                this.enableDisable();
            }
            if (jComponent.equals(this.endorsingChBox)) {
                string = (String)this.tokenCombo.getSelectedItem();
                this.endorsing = this.endorsingChBox.isSelected();
                SecurityTokensModelHelper.removeSupportingTokens(this.input);
                this.tokenElement = SecurityTokensModelHelper.setSupportingTokens(this.input, string, this.getSuppType(this.signed, this.endorsing));
                this.enableDisable();
            }
        }
    }

    private int getSuppType(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return 3;
        }
        if (bl) {
            return 1;
        }
        if (bl2) {
            return 2;
        }
        return 0;
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        SectionView sectionView = this.getSectionView();
        this.enableDisable();
        if (sectionView != null) {
            sectionView.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return new JButton();
    }

    private void enableDisable() {
        boolean bl = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.binding);
        boolean bl2 = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.operation);
        String string = null;
        if (bl) {
            string = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
        }
        if (bl2) {
            string = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.operation);
        }
        boolean bl3 = ProfilesModelHelper.isSCEnabled((WSDLComponent)this.binding);
        boolean bl4 = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)this.binding, 1) != null;
        boolean bl5 = ComboConstants.USERNAME.equals(this.tokenCombo.getSelectedItem());
        boolean bl6 = bl || bl2;
        boolean bl7 = ProfilesModelHelper.isSSLProfile(string);
        this.tokenCombo.setEnabled(bl6 && !bl3 && !bl4);
        this.tokenComboLabel.setEnabled(bl6 && !bl3 && !bl4);
        this.targetsButton.setEnabled(bl6 && !bl7);
        boolean bl8 = !"       ".equals((String)this.tokenCombo.getSelectedItem());
        this.signedChBox.setEnabled(bl6 && bl8 && !bl3 && !bl4);
        this.endorsingChBox.setEnabled(bl6 && bl8 && !bl3 && !bl4 && !bl5);
    }

    private void initComponents() {
        this.tokenComboLabel = new JLabel();
        this.tokenCombo = new JComboBox();
        this.targetsButton = new JButton();
        this.signedChBox = new JCheckBox();
        this.endorsingChBox = new JCheckBox();
        this.tokenComboLabel.setLabelFor(this.tokenCombo);
        Mnemonics.setLocalizedText((JLabel)this.tokenComboLabel, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_tokenComboLabel"));
        this.tokenCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"X509", "Username"}));
        Mnemonics.setLocalizedText((AbstractButton)this.targetsButton, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_SignEncrypt"));
        this.targetsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InputPanel.this.targetsButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.signedChBox, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_Token_Signed"));
        Mnemonics.setLocalizedText((AbstractButton)this.endorsingChBox, (String)NbBundle.getMessage(InputPanel.class, (String)"LBL_Token_Endorsing"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tokenComboLabel).addPreferredGap(0).add((Component)this.tokenCombo, 0, 306, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.endorsingChBox).add((Component)this.signedChBox)).add(216, 216, 216)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.targetsButton).addContainerGap(327, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tokenComboLabel).add((Component)this.tokenCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.signedChBox).addPreferredGap(0).add((Component)this.endorsingChBox).addPreferredGap(0).add((Component)this.targetsButton).addContainerGap()));
        this.tokenComboLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_AuthTokenCombo_ACSD"));
        this.tokenCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_AuthTokenCombo_ACSN"));
        this.tokenCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_AuthTokenCombo_ACSD"));
        this.targetsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_MsgParts_ACSD"));
        this.signedChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_Signed_ACSD"));
        this.endorsingChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InputPanel.class, (String)"LBL_InputPanel_Endorsing_ACSD"));
    }

    private void targetsButtonActionPerformed(ActionEvent actionEvent) {
        UndoCounter undoCounter = new UndoCounter();
        this.model.addUndoableEditListener((UndoableEditListener)undoCounter);
        TargetsPanel targetsPanel = new TargetsPanel((WSDLComponent)this.input);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)targetsPanel, NbBundle.getMessage(InputPanel.class, (String)"LBL_Targets_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!this.undoManager.canUndo()) continue;
                this.undoManager.undo();
            }
        } else {
            SecurityPolicyModelHelper.setTargets(this.input, targetsPanel.getTargetsModel());
        }
        this.model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }
}

