/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.client.PanelEnabler;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.DynamicCredsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.subpanels.StaticCredsPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServicePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.KeystorePanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TruststorePanel;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.X509Token;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class CallbackPanel
extends SectionInnerPanel {
    private Node node;
    private Binding binding;
    private boolean inSync = false;
    private Project project;
    private SectionView view;
    private JaxWsModel jaxwsmodel;
    private WSDLModel serviceModel;
    private String profile;
    private DefaultFormatterFactory tstampff = null;
    private JFormattedTextField cbTimestampField;
    private JLabel cbTimestampLbl;
    private JPanel credPanel;
    private JComboBox credTypeCombo;
    private JLabel credTypeLabel;
    private JCheckBox devDefaultsChBox;
    private JSeparator jSeparator1;
    private JButton keyStoreButton;
    private JButton samlBrowseButton;
    private JTextField samlHandlerField;
    private JLabel samlHandlerLabel;
    private JButton trustStoreButton;

    public CallbackPanel(SectionView sectionView, Node node, Binding binding, JaxWsModel jaxWsModel, WSDLModel wSDLModel) {
        super(sectionView);
        this.view = sectionView;
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        this.serviceModel = wSDLModel;
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        this.tstampff = new DefaultFormatterFactory();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMaximumIntegerDigits(8);
        numberFormat.setMaximumFractionDigits(0);
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setCommitsOnValidEdit(true);
        numberFormatter.setMinimum(Integer.valueOf(0));
        numberFormatter.setMaximum(Integer.valueOf(99999999));
        this.tstampff.setDefaultFormatter(numberFormatter);
        this.initComponents();
        this.samlHandlerField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.samlHandlerLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.devDefaultsChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.cbTimestampLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.cbTimestampField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.cbTimestampField.setFocusLostBehavior(1);
        this.inSync = true;
        this.credTypeCombo.removeAllItems();
        this.credTypeCombo.addItem(ComboConstants.STATIC);
        this.credTypeCombo.addItem(ComboConstants.DYNAMIC);
        this.inSync = false;
        this.addImmediateModifier(this.samlHandlerField);
        this.addImmediateModifier(this.credTypeCombo);
        this.addImmediateModifier(this.devDefaultsChBox);
        this.addImmediateModifier(this.cbTimestampField);
        this.sync();
    }

    public void sync() {
        String string;
        this.inSync = true;
        Binding binding = PolicyModelHelper.getBinding(this.serviceModel, this.binding.getName());
        this.profile = ProfilesModelHelper.getWSITSecurityProfile((WSDLComponent)binding);
        boolean bl = ProfilesModelHelper.isClientDefaultSetupSupported(this.profile);
        boolean bl2 = false;
        if (bl) {
            bl2 = ProfilesModelHelper.isClientDefaultSetupUsed(this.profile, this.binding, (WSDLComponent)binding, this.project);
        }
        this.setChBox(this.devDefaultsChBox, bl2);
        String string2 = ProprietarySecurityPolicyModelHelper.getCallbackHandler(this.binding, "samlHandler");
        if (string2 != null) {
            this.setCallbackHandler(string2);
        }
        if ((string = ProprietarySecurityPolicyModelHelper.getCallbackHandler(this.binding, "usernameHandler")) != null && string.length() > 0) {
            this.setCredType(ComboConstants.DYNAMIC, bl2);
            this.credTypeCombo.setSelectedItem(ComboConstants.DYNAMIC);
        } else {
            this.setCredType(ComboConstants.STATIC, bl2);
            this.credTypeCombo.setSelectedItem(ComboConstants.STATIC);
        }
        String string3 = ProprietarySecurityPolicyModelHelper.getHandlerTimestampTimeout(this.binding);
        if (string3 == null) {
            this.cbTimestampField.setText("300");
        } else {
            this.cbTimestampField.setText(string3);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private JPanel getPanel(String string, boolean bl) {
        boolean bl2 = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        if (ComboConstants.DYNAMIC.equals(string)) {
            return new DynamicCredsPanel(this.binding, this.project, !bl2 && !bl);
        }
        return new StaticCredsPanel(this.binding, !bl2 && !bl);
    }

    private void setCredType(String string, boolean bl) {
        Object object;
        this.remove(this.credPanel);
        this.credPanel = this.getPanel(string, bl);
        boolean bl2 = true;
        if (this.view != null) {
            object = this.view.getActivePanel();
            bl2 = object == null ? false : object.isActive();
        }
        object = bl2 ? SectionVisualTheme.getSectionActiveBackgroundColor() : SectionVisualTheme.getDocumentBackgroundColor();
        this.credPanel.setBackground((Color)object);
        this.refreshLayout();
    }

    public void setValue(JComponent jComponent, Object object) {
        String string;
        if (this.inSync) {
            return;
        }
        if (jComponent.equals(this.credTypeCombo)) {
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "usernameHandler", null, null, true);
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "passwordHandler", null, null, true);
            this.setCredType((String)this.credTypeCombo.getSelectedItem(), this.devDefaultsChBox.isSelected());
        }
        if (jComponent.equals(this.samlHandlerField)) {
            String string2 = this.getCallbackHandler();
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "samlHandler", string2, null, true);
            return;
        }
        if (jComponent.equals(this.cbTimestampField)) {
            string = ((Integer)this.cbTimestampField.getValue()).toString();
            if (string == null || string.length() == 0 || "300".equals(string.toString())) {
                ProprietarySecurityPolicyModelHelper.setHandlerTimestampTimeout(this.binding, null, true);
            } else {
                ProprietarySecurityPolicyModelHelper.setHandlerTimestampTimeout(this.binding, string, true);
            }
        }
        if (jComponent.equals(this.devDefaultsChBox)) {
            if (this.devDefaultsChBox.isSelected()) {
                Util.fillDefaults(this.project, true, true);
                string = PolicyModelHelper.getBinding(this.serviceModel, this.binding.getName());
                ProfilesModelHelper.setClientDefaults(this.profile, this.binding, (WSDLComponent)string, this.project);
                this.sync();
                this.refreshLayout();
                ((PanelEnabler)((Object)this.credPanel)).enablePanel(false);
                this.credPanel.revalidate();
                this.credPanel.repaint();
            } else {
                ((PanelEnabler)((Object)this.credPanel)).enablePanel(true);
            }
        }
        this.enableDisable();
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        this.enableDisable();
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    private void enableDisable() {
        boolean bl = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        boolean bl2 = true;
        boolean bl3 = true;
        if (!bl) {
            Component[] componentArray;
            this.devDefaultsChBox.setEnabled(true);
            boolean bl4 = this.devDefaultsChBox.isSelected();
            boolean bl5 = true;
            boolean bl6 = true;
            if (ComboConstants.PROF_USERNAME.equals(this.profile)) {
                bl6 = false;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(this.profile)) {
                bl5 = false;
            }
            this.keyStoreButton.setEnabled(bl6 && !bl4);
            this.trustStoreButton.setEnabled(bl5 && !bl4);
            if (ComboConstants.PROF_USERNAME.equals(this.profile) || ComboConstants.PROF_STSISSUED.equals(this.profile) || ComboConstants.PROF_STSISSUEDENDORSE.equals(this.profile) || ComboConstants.PROF_STSISSUEDCERT.equals(this.profile) || ComboConstants.PROF_MSGAUTHSSL.equals(this.profile)) {
                bl2 = false;
            }
            if (ComboConstants.PROF_SAMLSSL.equals(this.profile) || ComboConstants.PROF_SAMLHOLDER.equals(this.profile) || ComboConstants.PROF_SAMLSENDER.equals(this.profile)) {
                bl3 = false;
            }
            this.credTypeLabel.setEnabled(bl3 && !bl4);
            this.credTypeCombo.setEnabled(bl3 && !bl4);
            this.credPanel.setEnabled(bl3 && !bl4);
            for (Component component : componentArray = this.credPanel.getComponents()) {
                component.setEnabled(bl3 && !bl4);
            }
            this.samlBrowseButton.setEnabled(bl2 && !bl4);
            this.samlHandlerField.setEnabled(bl2 && !bl4);
            this.samlHandlerLabel.setEnabled(bl2 && !bl4);
            this.cbTimestampField.setEnabled(!bl4);
            this.cbTimestampLbl.setEnabled(!bl4);
        } else {
            Component[] componentArray;
            this.credPanel.setEnabled(false);
            for (Component component : componentArray = this.credPanel.getComponents()) {
                component.setEnabled(false);
            }
            this.credTypeCombo.setEnabled(false);
            this.credTypeLabel.setEnabled(false);
            this.devDefaultsChBox.setEnabled(false);
            this.jSeparator1.setEnabled(false);
            this.keyStoreButton.setEnabled(false);
            this.samlBrowseButton.setEnabled(false);
            this.samlHandlerField.setEnabled(false);
            this.samlHandlerLabel.setEnabled(false);
            this.trustStoreButton.setEnabled(false);
        }
        this.refreshLayout();
    }

    public static boolean isStoreConfigRequired(String string, boolean bl, Binding binding) {
        Collection collection;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(binding);
        Collection collection2 = binding.getBindingOperations();
        for (BindingOperation bindingOperation : collection2) {
            object2 = bindingOperation.getBindingInput();
            if (object2 != null) {
                arrayList.add(object2);
            }
            if ((object = bindingOperation.getBindingOutput()) != null) {
                arrayList.add(object);
            }
            collection = bindingOperation.getBindingFaults();
            for (BindingFault bindingFault : collection) {
                if (bindingFault == null) continue;
                arrayList.add(bindingFault);
            }
        }
        for (WSDLComponent wSDLComponent : arrayList) {
            object2 = SecurityTokensModelHelper.getSupportingTokens(wSDLComponent);
            if (object2 == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                collection = (WSDLComponent)object.next();
                WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenTypeElement((WSDLComponent)collection);
                if (!(wSDLComponent2 instanceof X509Token)) continue;
                return true;
            }
        }
        if (ComboConstants.PROF_TRANSPORT.equals(string) || ComboConstants.PROF_SAMLSSL.equals(string)) {
            return false;
        }
        if (!bl) {
            if (ComboConstants.PROF_USERNAME.equals(string)) {
                return false;
            }
            if (ComboConstants.PROF_MSGAUTHSSL.equals(string)) {
                // empty if block
            }
        } else if (ComboConstants.PROF_MSGAUTHSSL.equals(string)) {
            return false;
        }
        return true;
    }

    private void setCallbackHandler(String string) {
        this.samlHandlerField.setText(string);
    }

    private String getCallbackHandler() {
        return this.samlHandlerField.getText();
    }

    private void refreshLayout() {
        GroupLayout groupLayout = (GroupLayout)this.getLayout();
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.keyStoreButton).addPreferredGap(0).add((Component)this.trustStoreButton)).add((Component)this.devDefaultsChBox)).add(284, 284, 284)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(24, 24, 24).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.credTypeLabel).addPreferredGap(0).add((Component)this.credTypeCombo, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.credPanel, -2, -1, -2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.samlHandlerLabel).add((Component)this.cbTimestampLbl)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.samlHandlerField, -2, 209, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.samlBrowseButton)).add((Component)this.cbTimestampField, -2, 78, -2)))).add((Component)this.jSeparator1, -1, 475, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.devDefaultsChBox).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keyStoreButton).add((Component)this.trustStoreButton)).addPreferredGap(1).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.credTypeLabel).add((Component)this.credTypeCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.credPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.samlHandlerLabel).add((Component)this.samlBrowseButton).add((Component)this.samlHandlerField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbTimestampLbl).add((Component)this.cbTimestampField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void initComponents() {
        this.samlHandlerLabel = new JLabel();
        this.samlHandlerField = new JTextField();
        this.samlBrowseButton = new JButton();
        this.credTypeCombo = new JComboBox();
        this.credTypeLabel = new JLabel();
        this.credPanel = new JPanel();
        this.keyStoreButton = new JButton();
        this.trustStoreButton = new JButton();
        this.devDefaultsChBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.cbTimestampLbl = new JLabel();
        this.cbTimestampField = new JFormattedTextField();
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                CallbackPanel.this.formFocusGained(focusEvent);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                CallbackPanel.this.formAncestorAdded(ancestorEvent);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.samlHandlerLabel.setLabelFor(this.samlHandlerField);
        Mnemonics.setLocalizedText((JLabel)this.samlHandlerLabel, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.samlBrowseButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton"));
        this.samlBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.samlBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.credTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Static", "Dynamic"}));
        this.credTypeLabel.setLabelFor(this.credTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.credTypeLabel, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel"));
        GroupLayout groupLayout = new GroupLayout((Container)this.credPanel);
        this.credPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 424, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 64, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.keyStoreButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore"));
        this.keyStoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.keyStoreButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.trustStoreButton, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore"));
        this.trustStoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallbackPanel.this.trustStoreButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.devDefaultsChBox, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults"));
        this.devDefaultsChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.cbTimestampLbl, (String)NbBundle.getMessage(CallbackPanel.class, (String)"LBL_CallbackPanel_Timestamp"));
        this.cbTimestampField.setFormatterFactory(this.tstampff);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(12, 12, 12).add((Component)this.keyStoreButton).addPreferredGap(0).add((Component)this.trustStoreButton)).add((Component)this.devDefaultsChBox)).add(284, 284, 284)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(24, 24, 24).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.credTypeLabel).addPreferredGap(0).add((Component)this.credTypeCombo, -2, -1, -2)).add((GroupLayout.Group)groupLayout2.createParallelGroup(2, false).add(1, (Component)this.credPanel, -2, -1, -2).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.samlHandlerLabel).add((Component)this.cbTimestampLbl)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.samlHandlerField, -2, 209, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.samlBrowseButton)).add((Component)this.cbTimestampField, -2, 78, -2)))).add((Component)this.jSeparator1, -1, 475, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.devDefaultsChBox).addPreferredGap(1).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.keyStoreButton).add((Component)this.trustStoreButton)).addPreferredGap(1).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.credTypeLabel).add((Component)this.credTypeCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.credPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.samlHandlerLabel).add((Component)this.samlBrowseButton).add((Component)this.samlHandlerField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.cbTimestampLbl).add((Component)this.cbTimestampField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.samlHandlerLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSN"));
        this.samlHandlerLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_SamlLabel_ACSD"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSN"));
        this.samlBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_AuthPanel_SCHBrowseButton_ACSD"));
        this.credTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSN"));
        this.credTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStorePanel_AuthTypeLabel_ACSD"));
        this.keyStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSN"));
        this.keyStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_KeyStore_ACSD"));
        this.trustStoreButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSN"));
        this.trustStoreButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_Truststore_ACSD"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSN"));
        this.devDefaultsChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallbackPanel.class, (String)"LBL_DevDefaults_ACSD"));
    }

    private void trustStoreButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.isJsr109Supported();
        TruststorePanel truststorePanel = new TruststorePanel((WSDLComponent)this.binding, this.project, bl, this.profile, true);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)truststorePanel, NbBundle.getMessage(ServicePanel.class, (String)"LBL_Truststore_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            truststorePanel.storeState();
        }
    }

    private void keyStoreButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.isJsr109Supported();
        KeystorePanel keystorePanel = new KeystorePanel((WSDLComponent)this.binding, this.project, bl, true);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)keystorePanel, NbBundle.getMessage(ServicePanel.class, (String)"LBL_Keystore_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            keystorePanel.storeState();
        }
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent ancestorEvent) {
        this.enableDisable();
    }

    private boolean isJsr109Supported() {
        J2eePlatform j2eePlatform = this.getJ2eePlatform();
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("jsr109");
        }
        return false;
    }

    private J2eePlatform getJ2eePlatform() {
        String string;
        J2eeModuleProvider j2eeModuleProvider;
        if (this.project != null && (j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class)) != null && (string = j2eeModuleProvider.getServerInstanceID()) != null && string.length() > 0) {
            return Deployment.getDefault().getJ2eePlatform(string);
        }
        return null;
    }

    private void samlBrowseButtonActionPerformed(ActionEvent actionEvent) {
        block1: {
            Set<String> set;
            Iterator<String> iterator;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "javax.security.auth.callback.CallbackHandler");
            classDialog.show();
            if (classDialog.okButtonPressed() && (iterator = (set = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String string = iterator.next();
                this.setCallbackHandler(string);
                ProprietarySecurityPolicyModelHelper.setCallbackHandler(this.binding, "samlHandler", string, null, true);
            }
        }
    }
}

