/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.design;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.wsitconf.api.DesignerListenerProvider;
import org.netbeans.modules.websvc.wsitconf.design.ProgressPanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RMConfiguration
implements WSConfiguration {
    private Service service;
    private DataObject implementationFile;
    private Project project;
    private ArrayList<PropertyChangeListener> listeners = new ArrayList();
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();
    private Binding binding;
    private ComponentListener cl;
    private boolean clAdded = false;
    private PropertyChangeListener configCreationListener = null;

    public RMConfiguration(final Service service, final FileObject fileObject) {
        try {
            this.service = service;
            this.implementationFile = DataObject.find((FileObject)fileObject);
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
            this.binding = WSITModelSupport.getBinding(service, fileObject, this.project, false, this.createdFiles);
            this.cl = new ComponentListener(){

                private void update() {
                    boolean bl = RMModelHelper.isRMEnabled((WSDLComponent)RMConfiguration.this.binding);
                    for (PropertyChangeListener propertyChangeListener : RMConfiguration.this.listeners) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(RMConfiguration.this, "value", null, bl);
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                }

                public void valueChanged(ComponentEvent componentEvent) {
                    this.update();
                }

                public void childrenAdded(ComponentEvent componentEvent) {
                    this.update();
                }

                public void childrenDeleted(ComponentEvent componentEvent) {
                    this.update();
                }
            };
            if (this.binding != null) {
                this.addCListener(this.binding);
            } else {
                this.configCreationListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        RMConfiguration.this.binding = WSITModelSupport.getBinding(service, fileObject, RMConfiguration.this.project, false, RMConfiguration.this.createdFiles);
                        RMConfiguration.this.addCListener(RMConfiguration.this.binding);
                        RMConfiguration.this.cl.valueChanged(null);
                    }
                };
                DesignerListenerProvider.registerListener(this.configCreationListener);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }

    private synchronized void addCListener(Binding binding) {
        if (!this.clAdded && binding != null) {
            binding.getModel().addComponentListener(this.cl);
            this.clAdded = true;
        }
    }

    public Component getComponent() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(RMConfiguration.class, (String)"DesignConfigPanel.rmCB.text");
    }

    public Image getIcon() {
        return Utilities.loadImage((String)"org/netbeans/modules/websvc/wsitconf/resources/designer-rm.gif");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RMConfiguration.class, (String)"DesignConfigPanel.rmCB.text");
    }

    public boolean isSet() {
        if (this.binding != null) {
            return RMModelHelper.isRMEnabled((WSDLComponent)this.binding);
        }
        return false;
    }

    public void set() {
        final ProgressPanel progressPanel = new ProgressPanel(NbBundle.getMessage(RMConfiguration.class, (String)"LBL_Wait"));
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null);
        final JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                progressPanel.open(jComponent);
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RMConfiguration.this.binding = WSITModelSupport.getBinding(RMConfiguration.this.service, RMConfiguration.this.implementationFile.getPrimaryFile(), RMConfiguration.this.project, true, RMConfiguration.this.createdFiles);
                    if (RMConfiguration.this.binding == null) {
                        return;
                    }
                    RMConfiguration.this.binding.getModel().addComponentListener(RMConfiguration.this.cl);
                    if (!RMModelHelper.isRMEnabled((WSDLComponent)RMConfiguration.this.binding)) {
                        RMModelHelper.enableRM(RMConfiguration.this.binding);
                        WSITModelSupport.save((WSDLComponent)RMConfiguration.this.binding);
                    }
                }
                finally {
                    progressHandle.finish();
                    progressPanel.close();
                }
            }
        });
    }

    public void unset() {
        final ProgressPanel progressPanel = new ProgressPanel(NbBundle.getMessage(RMConfiguration.class, (String)"LBL_Wait"));
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null);
        final JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                progressPanel.open(jComponent);
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (RMConfiguration.this.binding == null) {
                        return;
                    }
                    if (RMModelHelper.isRMEnabled((WSDLComponent)RMConfiguration.this.binding)) {
                        RMModelHelper.disableRM(RMConfiguration.this.binding);
                        WSITModelSupport.save((WSDLComponent)RMConfiguration.this.binding);
                    }
                }
                finally {
                    progressHandle.finish();
                    progressPanel.close();
                }
            }
        });
    }

    public void registerListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void unregisterListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    protected void finalize() {
        if (this.binding != null) {
            this.binding.getModel().removeComponentListener(this.cl);
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

