/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.api;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.wsitconf.WSITEditor;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServiceTopComponent;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSITConfigProvider {
    private static final Logger logger = Logger.getLogger(WSITEditor.class.getName());
    private static WSITConfigProvider instance;

    private WSITConfigProvider() {
    }

    public static synchronized WSITConfigProvider getDefault() {
        if (instance == null) {
            instance = new WSITConfigProvider();
        }
        return instance;
    }

    public final JComponent getWSITServiceConfig(WSDLModel wSDLModel, UndoManager undoManager, Collection<Binding> collection, Node node) {
        ServiceTopComponent serviceTopComponent = new ServiceTopComponent(wSDLModel, undoManager, collection, node);
        return serviceTopComponent;
    }

    public final JComponent getWSITClientConfig(org.netbeans.modules.xml.wsdl.model.Service service, WSDLModel wSDLModel, WSDLModel wSDLModel2, Node node) {
        ClientTopComponent clientTopComponent = new ClientTopComponent(service, wSDLModel, wSDLModel2, node);
        return clientTopComponent;
    }

    public final boolean isWsitSecurityEnabled(Node node, JaxWsModel jaxWsModel) {
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        Project project = null;
        if (jaxWsModel != null) {
            project = FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile());
        }
        if (project != null && Util.isWsitSupported(project)) {
            try {
                WSDLModel wSDLModel = WSITModelSupport.getModel(node, jaxWsModel, null, false, null);
                if (wSDLModel != null) {
                    if (client != null) {
                        JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)project.getProjectDirectory());
                        if (jAXWSClientSupport != null) {
                            WSDLModel wSDLModel2 = WSITModelSupport.getServiceModelForClient(jAXWSClientSupport, client);
                            Collection collection = wSDLModel2.getDefinitions().getBindings();
                            for (Binding binding : collection) {
                                if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)binding)) continue;
                                return true;
                            }
                        }
                    } else if (service != null) {
                        Collection collection = wSDLModel.getDefinitions().getBindings();
                        for (Binding binding : collection) {
                            if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)binding)) continue;
                            return true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, null, exception);
            }
        }
        return false;
    }

    public final boolean isWsitEnabled(Node node, JaxWsModel jaxWsModel) {
        Project project = null;
        if (jaxWsModel != null) {
            project = FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile());
        }
        if (project != null && Util.isWsitSupported(project)) {
            try {
                WSDLModel wSDLModel = WSITModelSupport.getModel(node, jaxWsModel, null, false, null);
                if (wSDLModel != null) {
                    return true;
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, null, exception);
            }
        }
        return false;
    }
}

