/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class EjbJarLogicalViewProvider
implements LogicalViewProvider {
    private static final RequestProcessor BROKEN_LINKS_RP = new RequestProcessor("EjbJarLogicalViewProvider.BROKEN_LINKS_RP");
    private final EjbJarProject project;
    private final AntProjectHelper helper;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final SubprojectProvider spp;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "javac.test.classpath"};

    public EjbJarLogicalViewProvider(EjbJarProject ejbJarProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, SubprojectProvider subprojectProvider, ReferenceHelper referenceHelper) {
        this.project = ejbJarProject;
        assert (ejbJarProject != null);
        this.updateHelper = updateHelper;
        assert (updateHelper != null);
        this.helper = updateHelper.getAntProjectHelper();
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.spp = subprojectProvider;
        assert (subprojectProvider != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new WebLogicalViewRootNode();
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node2 = PackageView.findPath((Node)nodeArray[i], (Object)object);
                if (node2 == null) continue;
                return node2;
            }
            return this.findNodeInConfigFiles(node, fileObject);
        }
        return null;
    }

    private Node findNodeInConfigFiles(Node node, FileObject fileObject) {
        String string;
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            string = dataObject.getName();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string = fileObject.getName();
        }
        dataObject = node.getChildren().findChild("configurationFiles");
        if (dataObject == null) {
            return null;
        }
        return NodeOp.findChild((Node)dataObject, (String)string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void testBroken() {
        this.changeSupport.fireChange();
    }

    private static Lookup createLookup(Project project) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, dataFolder});
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper, (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    private String[] getBreakableProperties() {
        SourceRoots sourceRoots = this.project.getSourceRoots();
        String[] stringArray = sourceRoots.getRootProperties();
        sourceRoots = this.project.getTestSourceRoots();
        String[] stringArray2 = sourceRoots.getRootProperties();
        String[] stringArray3 = new String[BREAKABLE_PROPERTIES.length + stringArray.length + stringArray2.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, stringArray3, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(stringArray, 0, stringArray3, BREAKABLE_PROPERTIES.length, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, BREAKABLE_PROPERTIES.length + stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static class Actions {
        private Actions() {
        }

        public static Action createAction(String string, String string2, boolean bl) {
            return new ActionImpl(string, string2, (Lookup)(bl ? Utilities.actionsGlobalContext() : null));
        }

        private static class ActionImpl
        extends AbstractAction
        implements ContextAwareAction {
            Lookup context;
            String name;
            String command;

            public ActionImpl(String string, String string2, Lookup lookup) {
                super(string2);
                this.context = lookup;
                this.command = string;
                this.name = string2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Project project = (Project)this.context.lookup(Project.class);
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                actionProvider.invokeAction(this.command, this.context);
            }

            public Action createContextAwareInstance(Lookup lookup) {
                return new ActionImpl(this.command, this.name, lookup);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WebLogicalViewRootNode
    extends AbstractNode
    implements Runnable,
    FileStatusListener,
    ChangeListener,
    PropertyChangeListener {
        private Action brokenLinksAction;
        private BrokenServerAction brokenServerAction;
        private boolean broken;
        private Set files;
        private Map fileSystemListeners;
        private RequestProcessor.Task task;
        private final Object privateLock;
        private boolean iconChange;
        private boolean nameChange;
        private ChangeListener sourcesListener;
        private Map groupsListeners;

        public WebLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)EjbJarLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-j2ee-ejbjarproject/Nodes"), EjbJarLogicalViewProvider.createLookup(EjbJarLogicalViewProvider.this.project));
            this.privateLock = new Object();
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbjarproject/ui/resources/ejbjarProjectIcon.gif");
            super.setName(ProjectUtils.getInformation((Project)EjbJarLogicalViewProvider.this.project).getDisplayName());
            if (EjbJarLogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.brokenServerAction = new BrokenServerAction();
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)EjbJarLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)j2eeModuleProvider));
            this.setProjectFiles(EjbJarLogicalViewProvider.this.project);
        }

        protected final void setProjectFiles(Project project) {
            Sources sources = ProjectUtils.getSources((Project)project);
            if (this.sourcesListener == null) {
                this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
                sources.addChangeListener(this.sourcesListener);
            }
            this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
        }

        private final void setGroups(Collection collection) {
            if (this.groupsListeners != null) {
                for (Object object : this.groupsListeners.keySet()) {
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.groupsListeners.get(object);
                    object.removePropertyChangeListener(propertyChangeListener);
                }
            }
            this.groupsListeners = new HashMap();
            HashSet hashSet = new HashSet();
            for (PropertyChangeListener propertyChangeListener : collection) {
                PropertyChangeListener propertyChangeListener2 = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyChangeListener);
                this.groupsListeners.put(propertyChangeListener, propertyChangeListener2);
                propertyChangeListener.addPropertyChangeListener(propertyChangeListener2);
                FileObject fileObject = propertyChangeListener.getRootFolder();
                if (EjbJarLogicalViewProvider.this.project.getProjectDirectory().equals(fileObject)) {
                    Enumeration enumeration = EjbJarLogicalViewProvider.this.project.getProjectDirectory().getChildren(false);
                    while (enumeration.hasMoreElements()) {
                        FileObject fileObject2 = (FileObject)enumeration.nextElement();
                        if (FileOwnerQuery.getOwner((FileObject)fileObject2) != EjbJarLogicalViewProvider.this.project) continue;
                        hashSet.add(fileObject2);
                    }
                    continue;
                }
                hashSet.add(fileObject);
            }
            this.setFiles(hashSet);
        }

        protected final void setFiles(Set set) {
            FileStatusListener fileStatusListener;
            Object object2;
            if (this.fileSystemListeners != null) {
                for (Object object2 : this.fileSystemListeners.keySet()) {
                    fileStatusListener = (FileStatusListener)this.fileSystemListeners.get(object2);
                    object2.removeFileStatusListener(fileStatusListener);
                }
            }
            this.fileSystemListeners = new HashMap();
            this.files = set;
            if (set == null) {
                return;
            }
            Iterator<Object> iterator = set.iterator();
            object2 = new HashSet();
            while (iterator.hasNext()) {
                fileStatusListener = (FileObject)iterator.next();
                try {
                    FileSystem fileSystem = fileStatusListener.getFileSystem();
                    if (object2.contains(fileSystem)) continue;
                    object2.add(fileSystem);
                    FileStatusListener fileStatusListener2 = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileSystem);
                    fileSystem.addFileStatusListener(fileStatusListener2);
                    this.fileSystemListeners.put(fileSystem, fileStatusListener2);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)fileStateInvalidException, (String)("Can not get " + fileStatusListener + " filesystem, ignoring...")));
                }
            }
        }

        public Image getIcon(int n) {
            Image image = this.getMyIcon(n);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fileObject = (FileObject)this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Logger.getLogger("global").log(Level.INFO, null, fileStateInvalidException);
                }
            }
            return image;
        }

        public Image getOpenedIcon(int n) {
            Image image = this.getMyOpenedIcon(n);
            if (this.files != null && this.files.iterator().hasNext()) {
                try {
                    FileObject fileObject = (FileObject)this.files.iterator().next();
                    image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Logger.getLogger("global").log(Level.INFO, null, fileStateInvalidException);
                }
            }
            return image;
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)EjbJarLogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(EjbJarLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            Object object = this.privateLock;
            synchronized (object) {
                bl2 = this.iconChange;
                bl = this.nameChange;
                this.iconChange = false;
                this.nameChange = false;
            }
            if (bl2) {
                this.fireIconChange();
                this.fireOpenedIconChange();
            }
            if (bl) {
                this.fireDisplayNameChange(null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create((Runnable)this);
            }
            Object object = this.privateLock;
            synchronized (object) {
                if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                    for (FileObject fileObject : this.files) {
                        if (!fileStatusEvent.hasChanged(fileObject)) continue;
                        this.iconChange |= fileStatusEvent.isIconChange();
                        this.nameChange |= fileStatusEvent.isNameChange();
                    }
                }
            }
            this.task.schedule(50);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setProjectFiles(EjbJarLogicalViewProvider.this.project);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setProjectFiles(EjbJarLogicalViewProvider.this.project);
        }

        public Image getMyIcon(int n) {
            Image image = super.getIcon(n);
            return this.broken || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0) : image;
        }

        public Image getMyOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return this.broken || this.brokenServerAction.isEnabled() ? Utilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0) : image;
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                // empty catch block
            }
            return this.broken || this.brokenServerAction.isEnabled() ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Action[] getActions(boolean bl) {
            if (bl) {
                return super.getActions(true);
            }
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)EjbJarLogicalViewProvider.this.project, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(WebLogicalViewRootNode.class);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(EjbJarLogicalViewProvider.class);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)EjbJarLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>(30);
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            if (j2eeModuleProvider != null && j2eeModuleProvider.hasVerifierSupport()) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)resourceBundle.getString("LBL_VerifyAction_Name"), null));
            }
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)resourceBundle.getString("LBL_JavadocAction_Name"), null));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)resourceBundle.getString("LBL_RedeployAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            this.addFromLayers(arrayList, "Projects/Profiler_Actions_temporary");
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            this.addFromLayers(arrayList, "Projects/Actions");
            arrayList.add(null);
            if (this.brokenLinksAction != null && this.brokenLinksAction.isEnabled()) {
                arrayList.add(this.brokenLinksAction);
            }
            if (this.brokenServerAction.isEnabled()) {
                arrayList.add(this.brokenServerAction);
            }
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private void addFromLayers(List<Action> list, String string) {
            Lookup lookup = Lookups.forPath((String)string);
            for (Object e : lookup.lookupAll(Object.class)) {
                if (e instanceof Action) {
                    list.add((Action)e);
                    continue;
                }
                if (!(e instanceof JSeparator)) continue;
                list.add(null);
            }
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private RequestProcessor.Task task = null;
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(EjbJarLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                EjbJarLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = EjbJarProjectProperties.getProperty("j2ee.platform", EjbJarLogicalViewProvider.this.helper, "nbproject/project.properties");
                String string2 = BrokenServerSupport.selectServer((String)string, (Object)J2eeModule.EJB);
                if (string2 != null) {
                    EjbJarProjectProperties.setServerInstance(EjbJarLogicalViewProvider.this.project, EjbJarLogicalViewProvider.this.helper, string2);
                }
                this.checkMissingServer();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("j2ee.server.instance".equals(propertyChangeEvent.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String string, String string2) {
            }

            public void instanceAdded(String string) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String string) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean bl = this.brokenServer;
                String string = EjbJarProjectProperties.getProperty("j2ee.server.instance", EjbJarLogicalViewProvider.this.helper, "nbproject/private/private.properties");
                this.brokenServer = BrokenServerSupport.isBroken((String)string);
                if (bl != this.brokenServer) {
                    WebLogicalViewRootNode.this.fireIconChange();
                    WebLogicalViewRootNode.this.fireOpenedIconChange();
                    WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private RequestProcessor.Task task = null;
            private PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(EjbJarLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(WebLogicalViewRootNode.this.broken);
                EjbJarLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                EjbJarLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)EjbJarLogicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BrokenReferencesSupport.showCustomizer((AntProjectHelper)EjbJarLogicalViewProvider.this.helper, (ReferenceHelper)EjbJarLogicalViewProvider.this.resolver, (String[])EjbJarLogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                this.run();
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.refsMayChanged();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.refsMayChanged();
            }

            public synchronized void run() {
                boolean bl = WebLogicalViewRootNode.this.broken;
                WebLogicalViewRootNode.this.broken = EjbJarLogicalViewProvider.this.hasBrokenLinks();
                if (bl != WebLogicalViewRootNode.this.broken) {
                    this.setEnabled(WebLogicalViewRootNode.this.broken);
                    WebLogicalViewRootNode.this.fireIconChange();
                    WebLogicalViewRootNode.this.fireOpenedIconChange();
                    WebLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                    new EjbJarProjectProperties(EjbJarLogicalViewProvider.this.project, EjbJarLogicalViewProvider.this.updateHelper, EjbJarLogicalViewProvider.this.evaluator, EjbJarLogicalViewProvider.this.resolver).save();
                }
            }

            public void refsMayChanged() {
                if (this.task == null) {
                    this.task = BROKEN_LINKS_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

