/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.semc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SemcApplicationUIDCustomizer
extends JPanel {
    boolean uidValid = true;
    private String uidString;
    private File sdkInstallation;
    private static final String[] MODEL_ITEMS = new String[]{NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_0"), NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_1"), NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_2"), NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_3"), NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_UID_4")};
    private static final int[] MODEL_VALUES = new int[]{0, 2, 7, 10, 14};
    private JLabel errorLabel;
    private JTextField idTextField;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel resultValueLabel;

    public SemcApplicationUIDCustomizer(String string, File file) {
        this.sdkInstallation = file;
        this.uidString = string;
        this.initComponents();
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(255, 0, 0);
        }
        this.errorLabel.setForeground(color);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(MODEL_ITEMS));
        if (string.length() > 0) {
            int n = Integer.parseInt(string.substring(0, 1), 16);
            for (int i = 0; i < MODEL_VALUES.length; ++i) {
                if (n != MODEL_VALUES[i]) continue;
                this.jComboBox1.setSelectedIndex(i);
                this.idTextField.setText(string.substring(1));
                break;
            }
        } else {
            this.jComboBox1.setSelectedIndex(4);
        }
        this.idTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                SemcApplicationUIDCustomizer.this.computeUID();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SemcApplicationUIDCustomizer.this.computeUID();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SemcApplicationUIDCustomizer.this.computeUID();
            }
        });
        this.computeUID();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.idTextField = new JTextField();
        this.errorLabel = new JLabel();
        this.resultValueLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_AppUID"));
        this.jLabel2.setText(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"LBL_ResultUID"));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SemcApplicationUIDCustomizer.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        this.idTextField.setColumns(7);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jComboBox1, -2, 203, -2).addPreferredGap(0).add((Component)this.idTextField, -2, 111, -2)).add((Component)this.resultValueLabel, -1, 321, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1, -2, 14, -2).add((Component)this.jComboBox1, -2, -1, -2).add((Component)this.idTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.resultValueLabel)).addPreferredGap(0, 20, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.jComboBox1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ACSN_jComboBox1"));
        this.jComboBox1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ACSD_jComboBox1"));
        this.idTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ACSN_idTextField"));
        this.idTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ACSD_idTextField"));
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        this.computeUID();
    }

    private void computeUID() {
        File file;
        int n;
        String string = this.idTextField.getText();
        int n2 = string.length();
        if (n2 != 7) {
            this.uidValid = false;
        } else {
            this.uidValid = true;
            for (n = 0; n < n2; ++n) {
                if (Character.digit(string.charAt(n), 16) != -1) continue;
                this.uidValid = false;
                break;
            }
        }
        n = MODEL_VALUES[this.jComboBox1.getSelectedIndex()];
        String string2 = (Integer.toHexString(n) + this.idTextField.getText()).toUpperCase();
        this.resultValueLabel.setText("0x" + string2);
        boolean bl = false;
        if (this.sdkInstallation != null && (file = new File(this.sdkInstallation, "\\epoc32\\release\\winscw\\udeb\\PProLauncher" + string2 + ".exe")).exists() && !string2.equals(this.uidString)) {
            this.uidValid = false;
            bl = true;
        }
        if (!this.uidValid) {
            if (!bl) {
                this.errorLabel.setText(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ERR_WrongRange"));
            } else {
                this.errorLabel.setText(NbBundle.getMessage(SemcApplicationUIDCustomizer.class, (String)"ERR_UIDAlreadyExists", (Object)string2));
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        } else {
            this.errorLabel.setText(" ");
            this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
        }
    }

    String getUID() {
        return (Integer.toHexString(MODEL_VALUES[this.jComboBox1.getSelectedIndex()]) + this.idTextField.getText()).toUpperCase();
    }
}

