/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ParamModel;
import org.netbeans.modules.websvc.design.view.widget.TableModel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersTableModel
implements TableModel<ParamModel> {
    private transient MethodModel method;

    public ParametersTableModel(MethodModel methodModel) {
        this.method = methodModel;
    }

    @Override
    public int getRowCount() {
        return this.method.getParams().size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return NbBundle.getMessage(ParametersTableModel.class, (String)"LBL_Parameter_Name");
            }
            case 1: {
                return NbBundle.getMessage(ParametersTableModel.class, (String)"LBL_Parameter_Type");
            }
        }
        throw new IllegalArgumentException("");
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getValueAt(int n, int n2) {
        if (n >= 0 && n < this.getRowCount()) {
            switch (n2) {
                case 0: {
                    return this.getUserObject(n).getName();
                }
                case 1: {
                    return this.getUserObject(n).getParamType();
                }
            }
            throw new IllegalArgumentException("");
        }
        return null;
    }

    @Override
    public void setValueAt(String string, int n, int n2) {
        if (n >= 0 && n < this.getRowCount()) {
            switch (n2) {
                case 0: {
                    this.getUserObject(n).setName(string);
                    break;
                }
                case 1: {
                    throw new IllegalArgumentException("");
                }
                default: {
                    throw new IllegalArgumentException("");
                }
            }
        }
    }

    @Override
    public ParamModel getUserObject(int n) {
        return this.method.getParams().get(n);
    }
}

