/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.update.RevertModificationsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class RevertModifications
implements PropertyChangeListener {
    private RevertModificationsPanel panel;
    private JButton okButton;
    private JButton cancelButton;
    private RevertType[] types;

    public RevertModifications(RepositoryFile repositoryFile) {
        this(repositoryFile, null);
    }

    public RevertModifications(RepositoryFile repositoryFile, String string) {
        OneCommitRevertType oneCommitRevertType = new OneCommitRevertType(repositoryFile, this.getPanel().oneCommitRadioButton);
        LocalRevertType localRevertType = new LocalRevertType(this.getPanel().localChangesRadioButton);
        this.types = new RevertType[]{localRevertType, oneCommitRevertType, new MoreCommitsRevertType(repositoryFile, this.getPanel().moreCommitsRadioButton)};
        this.okButton = new JButton(NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertForm_Action_Revert"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertForm_Action_Revert"));
        this.cancelButton = new JButton(NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertForm_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertForm_Action_Cancel"));
        if (string != null) {
            this.panel.oneCommitRadioButton.setSelected(true);
            this.panel.oneRevisionTextField.setText(string);
            oneCommitRevertType.actionPerformed(null);
        } else {
            this.panel.localChangesRadioButton.setSelected(true);
            localRevertType.actionPerformed(null);
        }
    }

    private RevertModificationsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new RevertModificationsPanel();
        }
        return this.panel;
    }

    public RevisionInterval getRevisionInterval() {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isSelected()) continue;
            return this.types[i].getRevisionInterval();
        }
        return null;
    }

    public boolean revertNewFiles() {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].isSelected()) continue;
            return this.types[i].revertNewFiles();
        }
        return false;
    }

    public boolean showDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertDialog"));
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertDialog"));
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean bl = dialogDescriptor.getValue() == this.okButton;
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valid") && this.okButton != null) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.okButton.setEnabled(bl);
        }
    }

    protected void setMoreCommitsFieldsEnabled(boolean bl) {
        this.getPanel().startRevisionTextField.setEnabled(bl);
        this.getPanel().endRevisionTextField.setEnabled(bl);
        this.getPanel().startSearchButton.setEnabled(bl);
        this.getPanel().endSearchButton.setEnabled(bl);
    }

    protected void setOneCommitFieldsEnabled(boolean bl) {
        this.getPanel().oneRevisionSearchButton.setEnabled(bl);
        this.getPanel().oneRevisionTextField.setEnabled(bl);
    }

    private class MoreCommitsRevertType
    extends RevertType {
        private RepositoryPaths endPath;
        private RepositoryPaths startPath;

        MoreCommitsRevertType(RepositoryFile repositoryFile, JRadioButton jRadioButton) {
            super(jRadioButton);
            this.startPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().startRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().startSearchButton);
            this.startPath.addPropertyChangeListener(RevertModifications.this);
            this.endPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().endRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().endSearchButton);
            this.endPath.addPropertyChangeListener(RevertModifications.this);
        }

        RevisionInterval getRevisionInterval() {
            SVNRevision sVNRevision = this.getRevision(this.startPath);
            SVNRevision sVNRevision2 = this.getRevision(this.endPath);
            if (sVNRevision == null || sVNRevision2 == null) {
                return null;
            }
            return this.getResortedRevisionInterval(sVNRevision, sVNRevision2);
        }

        void validateUserInput() {
            if (!this.validateRevision(this.getRevision(this.startPath))) {
                return;
            }
            if (!this.validateRevision(this.getRevision(this.endPath))) {
                return;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RevertModifications.this.setMoreCommitsFieldsEnabled(true);
            RevertModifications.this.setOneCommitFieldsEnabled(false);
            this.validateUserInput();
        }

        private RevisionInterval getResortedRevisionInterval(SVNRevision sVNRevision, SVNRevision sVNRevision2) {
            Long l;
            Long l2;
            RevisionInterval revisionInterval = sVNRevision.equals((Object)SVNRevision.HEAD) && sVNRevision.equals((Object)SVNRevision.HEAD) ? new RevisionInterval(sVNRevision, sVNRevision2) : (sVNRevision.equals((Object)SVNRevision.HEAD) ? new RevisionInterval(sVNRevision2, sVNRevision) : (sVNRevision2.equals((Object)SVNRevision.HEAD) ? new RevisionInterval(sVNRevision, sVNRevision2) : ((l2 = Long.valueOf(Long.parseLong(sVNRevision.toString()))).compareTo(l = Long.valueOf(Long.parseLong(sVNRevision2.toString()))) < 0 ? new RevisionInterval(sVNRevision, sVNRevision2) : new RevisionInterval(sVNRevision2, sVNRevision))));
            return revisionInterval;
        }
    }

    private class OneCommitRevertType
    extends RevertType {
        private RepositoryPaths oneRevisionPath;

        OneCommitRevertType(RepositoryFile repositoryFile, JRadioButton jRadioButton) {
            super(jRadioButton);
            this.oneRevisionPath = new RepositoryPaths(repositoryFile, null, null, ((RevertModifications)RevertModifications.this).getPanel().oneRevisionTextField, ((RevertModifications)RevertModifications.this).getPanel().oneRevisionSearchButton);
            this.oneRevisionPath.addPropertyChangeListener(RevertModifications.this);
        }

        RevisionInterval getRevisionInterval() {
            SVNRevision sVNRevision = this.getRevision(this.oneRevisionPath);
            RevisionInterval revisionInterval = new RevisionInterval(sVNRevision);
            return revisionInterval;
        }

        void validateUserInput() {
            this.validateRevision(this.getRevision(this.oneRevisionPath));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RevertModifications.this.setOneCommitFieldsEnabled(true);
            RevertModifications.this.setMoreCommitsFieldsEnabled(false);
            this.validateUserInput();
        }
    }

    private class LocalRevertType
    extends RevertType {
        LocalRevertType(JRadioButton jRadioButton) {
            super(jRadioButton);
        }

        RevisionInterval getRevisionInterval() {
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RevertModifications.this.setOneCommitFieldsEnabled(false);
            RevertModifications.this.setMoreCommitsFieldsEnabled(false);
        }
    }

    private abstract class RevertType
    implements ActionListener,
    DocumentListener {
        private JRadioButton button;

        RevertType(JRadioButton jRadioButton) {
            this.button = jRadioButton;
            jRadioButton.addActionListener(this);
        }

        boolean isSelected() {
            return this.button.isSelected();
        }

        boolean revertNewFiles() {
            return ((RevertModifications)RevertModifications.this).panel.revertNewFilesCheckBox.isSelected();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.validateUserInput();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.validateUserInput();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.validateUserInput();
        }

        void validateUserInput() {
        }

        RevisionInterval getRevisionInterval() {
            return null;
        }

        protected SVNRevision getRevision(RepositoryPaths repositoryPaths) {
            try {
                return repositoryPaths.getRepositoryFiles()[0].getRevision();
            }
            catch (NumberFormatException numberFormatException) {
                Subversion.LOG.log(Level.INFO, null, numberFormatException);
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, null, malformedURLException);
            }
            return null;
        }

        protected boolean validateRevision(SVNRevision sVNRevision) {
            boolean bl = sVNRevision == null || sVNRevision.equals((Object)SVNRevision.HEAD) || sVNRevision.getKind() == 1;
            RevertModifications.this.okButton.setEnabled(bl);
            return bl;
        }
    }

    public static class RevisionInterval {
        SVNRevision startRevision;
        SVNRevision endRevision;

        public RevisionInterval(SVNRevision sVNRevision) {
            this.startRevision = sVNRevision;
            this.endRevision = sVNRevision;
        }

        public RevisionInterval(SVNRevision sVNRevision, SVNRevision sVNRevision2) {
            this.startRevision = sVNRevision;
            this.endRevision = sVNRevision2;
        }
    }
}

