/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUpdateInfo {
    private static final String KNOWN_ACTIONS = "ADUCG ";
    public static int ACTION_TYPE_FILE = 1;
    public static int ACTION_TYPE_PROPERTY = 2;
    public static int ACTION_ADDED = 4;
    public static int ACTION_DELETED = 8;
    public static int ACTION_UPDATED = 16;
    public static int ACTION_CONFLICTED = 32;
    public static int ACTION_MERGED = 64;
    public static int ACTION_CONFLICTED_RESOLVED = 128;
    public static int ACTION_LOCK_BROKEN = 256;
    private final File file;
    private final int action;
    private static final Pattern pattern = Pattern.compile("^([ADUCG ])([ADUCG ])([B ])  (.+)$");

    FileUpdateInfo(File file, int n) {
        this.file = file;
        this.action = n;
    }

    public File getFile() {
        return this.file;
    }

    public int getAction() {
        return this.action;
    }

    public static FileUpdateInfo[] createFromLogMsg(String string) {
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        String string5 = matcher.group(4);
        if (KNOWN_ACTIONS.indexOf(string2) < 0 || KNOWN_ACTIONS.indexOf(string3) < 0) {
            return null;
        }
        FileUpdateInfo[] fileUpdateInfoArray = new FileUpdateInfo[2];
        int n = FileUpdateInfo.parseAction(string2.charAt(0)) | (string4.equals("B") ? ACTION_LOCK_BROKEN : 0);
        int n2 = FileUpdateInfo.parseAction(string3.charAt(0));
        fileUpdateInfoArray[0] = n != 0 ? new FileUpdateInfo(new File(string5), n | ACTION_TYPE_FILE) : null;
        fileUpdateInfoArray[1] = n2 != 0 ? new FileUpdateInfo(new File(string5), n2 | ACTION_TYPE_PROPERTY) : null;
        return fileUpdateInfoArray;
    }

    private static int parseAction(char c) {
        switch (c) {
            case 'A': {
                return ACTION_ADDED;
            }
            case 'D': {
                return ACTION_DELETED;
            }
            case 'U': {
                return ACTION_UPDATED;
            }
            case 'C': {
                return ACTION_CONFLICTED;
            }
            case 'G': {
                return ACTION_MERGED;
            }
        }
        return 0;
    }
}

