/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.lookup.Lookups;
import org.tigris.subversion.svnclientadapter.SVNClientException;

class DiffNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PROPERTY = "property";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_LOCATION = "location";
    private final Setup setup;
    private String htmlDisplayName;
    private int displayStatuses;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    public DiffNode(Setup setup, int n) {
        super(Children.LEAF, Lookups.singleton((Object)setup));
        this.setup = setup;
        this.displayStatuses = n;
        this.setName(setup.getBaseFile().getName());
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    private void refreshHtmlDisplayName() {
        FileInformation fileInformation = this.setup.getInfo();
        int n = fileInformation.getStatus();
        if (n == 128) {
            n = 64;
        }
        this.htmlDisplayName = Subversion.getInstance().getAnnotator().annotateNameHtml(this.setup.getBaseFile().getName(), fileInformation, null);
        this.fireDisplayNameChange(this.htmlDisplayName, this.htmlDisplayName);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return null;
        }
        return new Action[0];
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty());
        set.put((Node.Property)new LocationProperty());
        set.put((Node.Property)new StatusProperty());
        if (this.setup.getPropertyName() != null) {
            set.put((Node.Property)new PropertyNameProperty());
        }
        sheet.put(set);
        this.setSheet(sheet);
    }

    private class StatusProperty
    extends DiffNodeProperty {
        public StatusProperty() {
            super(DiffNode.COLUMN_NAME_STATUS, String.class, DiffNode.COLUMN_NAME_STATUS, DiffNode.COLUMN_NAME_STATUS);
            String string = null;
            try {
                string = SvnUtils.getRelativePath(DiffNode.this.setup.getBaseFile());
            }
            catch (SVNClientException sVNClientException) {
                string = "";
            }
            String string2 = Integer.toString(SvnUtils.getComparableStatus(DiffNode.this.setup.getInfo().getStatus()));
            this.setValue("sortkey", zeros[string2.length()] + string2 + "\t" + string + "\t" + DiffNode.this.getName().toUpperCase());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            FileInformation fileInformation = DiffNode.this.setup.getInfo();
            fileInformation.getEntry(DiffNode.this.setup.getBaseFile());
            return fileInformation.getStatusText(DiffNode.this.displayStatuses);
        }
    }

    private class LocationProperty
    extends DiffNodeProperty {
        private String location;

        public LocationProperty() {
            super(DiffNode.COLUMN_NAME_LOCATION, String.class, DiffNode.COLUMN_NAME_LOCATION, DiffNode.COLUMN_NAME_LOCATION);
            try {
                this.location = SvnUtils.getRelativePath(DiffNode.this.setup.getBaseFile());
            }
            catch (SVNClientException sVNClientException) {
                this.location = "";
            }
            this.setValue("sortkey", this.location + "\t" + DiffNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.location;
        }
    }

    private class PropertyNameProperty
    extends DiffNodeProperty {
        public PropertyNameProperty() {
            super(DiffNode.COLUMN_NAME_PROPERTY, String.class, DiffNode.COLUMN_NAME_PROPERTY, DiffNode.COLUMN_NAME_PROPERTY);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.setup.getPropertyName();
        }
    }

    private class NameProperty
    extends DiffNodeProperty {
        public NameProperty() {
            super(DiffNode.COLUMN_NAME_NAME, String.class, DiffNode.COLUMN_NAME_NAME, DiffNode.COLUMN_NAME_NAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return DiffNode.this.getName();
        }
    }

    private abstract class DiffNodeProperty
    extends PropertySupport.ReadOnly {
        protected DiffNodeProperty(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.INFO, null, exception);
                return exception.getLocalizedMessage();
            }
        }
    }
}

