/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.spi.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StorageSupport {
    private static final Logger LOG = Logger.getLogger(StorageSupport.class.getName());
    private static final String EMACS_CTRL = "Ctrl+";
    private static final String EMACS_ALT = "Alt+";
    private static final String EMACS_SHIFT = "Shift+";
    private static final String EMACS_META = "Meta+";

    private StorageSupport() {
    }

    public static String getLocalizingBundleMessage(FileObject fileObject, String string, String string2) {
        return Utils.getLocalizedName(fileObject, string, string2, false);
    }

    public static String keyStrokesToString(Collection<? extends KeyStroke> collection, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends KeyStroke> iterator = collection.iterator();
        while (iterator.hasNext()) {
            KeyStroke keyStroke = iterator.next();
            if (bl) {
                stringBuilder.append(Utilities.keyToString((KeyStroke)keyStroke));
                if (!iterator.hasNext()) continue;
                stringBuilder.append('$');
                continue;
            }
            stringBuilder.append(StorageSupport.keyStrokeToHumanReadableString(keyStroke));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public static KeyStroke[] stringToKeyStrokes(String string, boolean bl) {
        assert (string != null) : "The parameter key must not be null";
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        String string2 = bl ? "$" : " ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = bl ? Utilities.stringToKey((String)string3) : StorageSupport.humanReadableStringToKeyStroke(string3);
            if (keyStroke != null) {
                arrayList.add(keyStroke);
                continue;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Invalid keystroke string: '" + string3 + "'");
            }
            return null;
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static KeyStroke humanReadableStringToKeyStroke(String string) {
        KeyStroke keyStroke;
        int n = 0;
        if (string.startsWith(EMACS_CTRL)) {
            n |= 0x80;
            string = string.substring(EMACS_CTRL.length());
        }
        if (string.startsWith(EMACS_ALT)) {
            n |= 0x200;
            string = string.substring(EMACS_ALT.length());
        }
        if (string.startsWith(EMACS_SHIFT)) {
            n |= 0x40;
            string = string.substring(EMACS_SHIFT.length());
        }
        if (string.startsWith(EMACS_META)) {
            n |= 0x100;
            string = string.substring(EMACS_META.length());
        }
        if ((keyStroke = Utilities.stringToKey((String)string)) != null) {
            return KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n);
        }
        return null;
    }

    private static String keyStrokeToHumanReadableString(KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x80) > 0) {
            stringBuilder.append(EMACS_CTRL);
        }
        if ((n & 0x200) > 0) {
            stringBuilder.append(EMACS_ALT);
        }
        if ((n & 0x40) > 0) {
            stringBuilder.append(EMACS_SHIFT);
        }
        if ((n & 0x100) > 0) {
            stringBuilder.append(EMACS_META);
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            stringBuilder.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return stringBuilder.toString();
    }
}

