/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.fontscolors;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.fontscolors.FontColorSettingsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeFCS
extends FontColorSettings {
    private static final Logger LOG = Logger.getLogger(CompositeFCS.class.getName());
    private static final String DEFAULT = "default";
    private static final int DEFAULT_FONT_SIZE = UIManager.get("customFontSize") != null ? ((Integer)UIManager.get("customFontSize")).intValue() : UIManager.getFont("TextField.font").getSize();
    private static final AttributeSet HARDCODED_DEFAULT_COLORING = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.NameAttribute, "default", StyleConstants.Foreground, Color.black, StyleConstants.Background, Color.white, StyleConstants.FontFamily, "Monospaced", StyleConstants.FontSize, DEFAULT_FONT_SIZE < 12 ? 12 : DEFAULT_FONT_SIZE});
    private static final AttributeSet NULL = new SimpleAttributeSet();
    private final FontColorSettingsImpl[] allFcsi;
    final String profile;
    private final Map<String, AttributeSet> tokensCache = new HashMap<String, AttributeSet>();

    public CompositeFCS(MimePath mimePath, String string) {
        Object object;
        int n;
        assert (mimePath != null) : "The parameter allPaths should not be null";
        assert (string != null) : "The parameter profile should not be null";
        while (mimePath.size() > 1 && (n = FontColorSettingsImpl.get(MimePath.parse((String)(object = mimePath.getMimeType(mimePath.size() - 1)))).getColorings(string).isEmpty()) != 0) {
            mimePath = mimePath.getPrefix(mimePath.size() - 1);
        }
        object = CompositeFCS.computeInheritedMimePaths(mimePath);
        assert (((MimePath[])object).length > 0) : "allPaths should always contain at least MimePath.EMPTY";
        this.allFcsi = new FontColorSettingsImpl[((MimePath[])object).length];
        for (n = 0; n < ((MimePath[])object).length; ++n) {
            this.allFcsi[n] = FontColorSettingsImpl.get(object[n]);
        }
        this.profile = string;
    }

    public AttributeSet getFontColors(String string) {
        assert (string != null) : "The parameter highlightName must not be null.";
        if (string.equals(DEFAULT)) {
            return this.getTokenFontColors(DEFAULT);
        }
        AttributeSet attributeSet = null;
        Map<String, AttributeSet> map = EditorSettings.getDefault().getHighlightings(this.profile);
        if (map != null) {
            attributeSet = map.get(string);
        }
        return attributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeSet getTokenFontColors(String string) {
        assert (string != null) : "The parameter tokenName must not be null.";
        Map<String, AttributeSet> map = this.tokensCache;
        synchronized (map) {
            AttributeSet attributeSet = this.tokensCache.get(string);
            if (attributeSet == null) {
                attributeSet = this.findColoringForToken(string);
                this.tokensCache.put(string, attributeSet);
            }
            return attributeSet == NULL ? null : attributeSet;
        }
    }

    public boolean isDerivedFromMimePath(MimePath mimePath) {
        for (FontColorSettingsImpl fontColorSettingsImpl : this.allFcsi) {
            if (fontColorSettingsImpl.getMimePath() != mimePath) continue;
            return true;
        }
        return false;
    }

    private AttributeSet findColoringForToken(String string) {
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        String string2 = string;
        for (FontColorSettingsImpl fontColorSettingsImpl : this.allFcsi) {
            string2 = this.processLayer(fontColorSettingsImpl, string2, arrayList);
        }
        if (string.equals(DEFAULT)) {
            arrayList.add(HARDCODED_DEFAULT_COLORING);
        }
        if (arrayList.size() > 0) {
            return AttributesUtilities.createImmutable((AttributeSet[])arrayList.toArray(new AttributeSet[arrayList.size()]));
        }
        return NULL;
    }

    private String processLayer(FontColorSettingsImpl fontColorSettingsImpl, String string, ArrayList<AttributeSet> arrayList) {
        AttributeSet attributeSet = fontColorSettingsImpl.getColorings(this.profile).get(string);
        if (attributeSet == null) {
            attributeSet = fontColorSettingsImpl.getDefaultColorings(this.profile).get(string);
        }
        if (attributeSet != null) {
            arrayList.add(attributeSet);
            String string2 = (String)attributeSet.getAttribute(StyleConstants.NameAttribute);
            String string3 = (String)attributeSet.getAttribute(EditorStyleConstants.Default);
            if (string3 != null && !string3.equals(DEFAULT)) {
                if (!string3.equals(string2)) {
                    string3 = this.processLayer(fontColorSettingsImpl, string3, arrayList);
                }
            } else {
                string3 = string2;
            }
            string = string3;
        }
        return string;
    }

    private void dumpAttribs(AttributeSet attributeSet, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attribs for base mime path '");
        stringBuilder.append(this.allFcsi[0].getMimePath().getPath());
        stringBuilder.append("' and ");
        if (bl) {
            stringBuilder.append("token '");
        } else {
            stringBuilder.append("highlight '");
        }
        stringBuilder.append(string);
        stringBuilder.append("' = {");
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            stringBuilder.append("'" + obj + "' = '" + object + "'");
            if (!enumeration.hasMoreElements()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("} CompoundFCS.this = ");
        stringBuilder.append(((Object)((Object)this)).toString());
        System.out.println(stringBuilder.toString());
    }

    private static MimePath[] computeInheritedMimePaths(MimePath mimePath) {
        Object object;
        Object object2;
        Object object3 = null;
        try {
            object2 = MimePath.class.getDeclaredMethod("getInheritedPaths", String.class, String.class);
            ((Method)object2).setAccessible(true);
            object3 = object = (List)((Method)object2).invoke((Object)mimePath, new Object[]{null, null});
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Can't call org.netbeans.api.editor.mimelookup.MimePath.getInheritedPaths method.", exception);
        }
        if (object3 != null) {
            object2 = new ArrayList(object3.size());
            object = object3.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                ((ArrayList)object2).add(MimePath.parse((String)string));
            }
            return ((ArrayList)object2).toArray(new MimePath[((ArrayList)object2).size()]);
        }
        return new MimePath[]{mimePath, MimePath.EMPTY};
    }
}

