/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfpath.platform.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsfpath.platform.InstallerRegistry;
import org.netbeans.modules.gsfpath.spi.platform.CustomPlatformInstall;
import org.netbeans.modules.gsfpath.spi.platform.GeneralPlatformInstall;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class SelectorPanel
extends JPanel
implements ItemListener {
    private Map<ButtonModel, GeneralPlatformInstall> installersByButtonModels = new IdentityHashMap<ButtonModel, GeneralPlatformInstall>();
    private ButtonGroup group;
    private Panel firer;

    public SelectorPanel(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(SelectorPanel.class, (String)"TXT_SelectPlatformTypeTitle"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SelectorPanel.class, (String)"AD_SelectPlatformType"));
    }

    private void postInitComponents() {
        InstallerRegistry installerRegistry = InstallerRegistry.getDefault();
        List<GeneralPlatformInstall> list = installerRegistry.getAllInstallers();
        this.group = new ButtonGroup();
        JLabel jLabel = new JLabel(NbBundle.getMessage(SelectorPanel.class, (String)"TXT_SelectPlatform"));
        jLabel.setDisplayedMnemonic(NbBundle.getMessage(SelectorPanel.class, (String)"AD_SelectPlatform").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        ((GridBagLayout)this.getLayout()).setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Iterator<GeneralPlatformInstall> iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            GeneralPlatformInstall generalPlatformInstall = iterator.next();
            JRadioButton jRadioButton = new JRadioButton(generalPlatformInstall.getDisplayName());
            if (n == 0) {
                jLabel.setLabelFor(jRadioButton);
            }
            jRadioButton.addItemListener(this);
            this.installersByButtonModels.put(jRadioButton.getModel(), generalPlatformInstall);
            this.group.add(jRadioButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(6, 18, iterator.hasNext() ? 0 : 12, 12);
            ((GridBagLayout)this.getLayout()).setConstraints(jRadioButton, gridBagConstraints);
            this.add(jRadioButton);
            ++n;
        }
        JPanel jPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        ((GridBagLayout)this.getLayout()).setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
    }

    private void readSettings() {
        if (this.group.getSelection() == null) {
            Enumeration<AbstractButton> enumeration = this.group.getElements();
            assert (enumeration.hasMoreElements());
            ((JRadioButton)enumeration.nextElement()).setSelected(true);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.firer.cs.fireChange();
    }

    boolean selectInstaller(GeneralPlatformInstall generalPlatformInstall) {
        assert (generalPlatformInstall != null);
        for (Map.Entry<ButtonModel, GeneralPlatformInstall> entry : this.installersByButtonModels.entrySet()) {
            if (!entry.getValue().equals(generalPlatformInstall)) continue;
            ButtonModel buttonModel = entry.getKey();
            buttonModel.setSelected(true);
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Panel
    implements WizardDescriptor.Panel<WizardDescriptor> {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private SelectorPanel component;

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void readSettings(WizardDescriptor wizardDescriptor) {
            this.getComponent().readSettings();
        }

        public void storeSettings(WizardDescriptor wizardDescriptor) {
        }

        public HelpCtx getHelp() {
            return new HelpCtx(SelectorPanel.class);
        }

        public boolean isValid() {
            return this.component != null;
        }

        public SelectorPanel getComponent() {
            if (this.component == null) {
                this.component = new SelectorPanel(this);
            }
            return this.component;
        }

        public GeneralPlatformInstall getInstaller() {
            SelectorPanel selectorPanel = this.getComponent();
            ButtonModel buttonModel = selectorPanel.group.getSelection();
            if (buttonModel != null) {
                return (GeneralPlatformInstall)selectorPanel.installersByButtonModels.get(buttonModel);
            }
            return null;
        }

        public WizardDescriptor.InstantiatingIterator getInstallerIterator() {
            GeneralPlatformInstall generalPlatformInstall = this.getInstaller();
            if (generalPlatformInstall instanceof CustomPlatformInstall) {
                return ((CustomPlatformInstall)generalPlatformInstall).createIterator();
            }
            return null;
        }
    }
}

