/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfpath.platform;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class PlatformSettings {
    private static final PlatformSettings INSTANCE = new PlatformSettings();
    private static final String PROP_PLATFORMS_FOLDER = "platformsFolder";
    private static final String APPLE_JAVAVM_FRAMEWORK_PATH = "/System/Library/Frameworks/JavaVM.framework/Versions/";

    public String displayName() {
        return NbBundle.getMessage(PlatformSettings.class, (String)"TXT_PlatformSettings");
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(PlatformSettings.class);
    }

    public File getPlatformsFolder() {
        String string = PlatformSettings.getPreferences().get(PROP_PLATFORMS_FOLDER, null);
        if (string == null) {
            File file;
            if (Utilities.isMac()) {
                file = new File(APPLE_JAVAVM_FRAMEWORK_PATH);
            } else {
                File file2;
                file = new File(System.getProperty("user.home"));
                while ((file2 = file.getParentFile()) != null) {
                    file = file2;
                }
            }
            return file;
        }
        return new File(string);
    }

    public void setPlatformsFolder(File file) {
        PlatformSettings.getPreferences().put(PROP_PLATFORMS_FOLDER, file.getAbsolutePath());
    }

    public static synchronized PlatformSettings getDefault() {
        return INSTANCE;
    }
}

