/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfpath.api.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.netbeans.modules.gsfpath.api.platform.JavaPlatform;
import org.netbeans.modules.gsfpath.api.platform.Profile;
import org.netbeans.modules.gsfpath.api.platform.Specification;
import org.netbeans.modules.gsfpath.platform.FallbackDefaultJavaPlatform;
import org.netbeans.modules.gsfpath.platform.JavaPlatformProvider;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaPlatformManager {
    public static final String PROP_INSTALLED_PLATFORMS = "installedPlatforms";
    private static JavaPlatformManager instance = null;
    private Lookup.Result<JavaPlatformProvider> providers;
    private Collection<? extends JavaPlatformProvider> lastProviders = Collections.emptySet();
    private boolean providersValid = false;
    private PropertyChangeListener pListener;
    private Collection<JavaPlatform> cachedPlatforms;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static synchronized JavaPlatformManager getDefault() {
        if (instance == null) {
            instance = new JavaPlatformManager();
        }
        return instance;
    }

    public JavaPlatform getDefaultPlatform() {
        for (JavaPlatformProvider javaPlatformProvider : this.getProviders()) {
            JavaPlatform javaPlatform = javaPlatformProvider.getDefaultPlatform();
            if (javaPlatform == null) continue;
            return javaPlatform;
        }
        return new FallbackDefaultJavaPlatform();
    }

    public synchronized JavaPlatform[] getInstalledPlatforms() {
        if (this.cachedPlatforms == null) {
            this.cachedPlatforms = new HashSet<JavaPlatform>();
            for (JavaPlatformProvider javaPlatformProvider : this.getProviders()) {
                this.cachedPlatforms.addAll(Arrays.asList(javaPlatformProvider.getInstalledPlatforms()));
            }
        }
        return this.cachedPlatforms.toArray(new JavaPlatform[this.cachedPlatforms.size()]);
    }

    public JavaPlatform[] getPlatforms(String string, Specification specification) {
        ArrayList<JavaPlatform> arrayList = new ArrayList<JavaPlatform>();
        for (JavaPlatform javaPlatform : this.getInstalledPlatforms()) {
            Specification specification2;
            String string2 = string == null ? null : javaPlatform.getDisplayName();
            Specification specification3 = specification2 = specification == null ? null : javaPlatform.getSpecification();
            if (string != null && !string2.equalsIgnoreCase(string) || specification != null && !JavaPlatformManager.compatible(specification2, specification)) continue;
            arrayList.add(javaPlatform);
        }
        return arrayList.toArray(new JavaPlatform[arrayList.size()]);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (propertyChangeListener != null) : "Listener can not be null";
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        assert (propertyChangeListener != null) : "Listener can not be null";
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(String string) {
        this.pcs.firePropertyChange(string, null, null);
    }

    private static boolean compatible(Specification specification, Specification specification2) {
        String string = specification2.getName();
        SpecificationVersion specificationVersion = specification2.getVersion();
        return !(string != null && !string.equalsIgnoreCase(specification.getName()) || specificationVersion != null && !specificationVersion.equals((Object)specification.getVersion()) || !JavaPlatformManager.compatibleProfiles(specification.getProfiles(), specification2.getProfiles()));
    }

    private static boolean compatibleProfiles(Profile[] profileArray, Profile[] profileArray2) {
        if (profileArray2 == null) {
            return true;
        }
        if (profileArray == null) {
            return false;
        }
        HashSet<Profile> hashSet = new HashSet<Profile>();
        for (Profile profile : profileArray2) {
            boolean bl = false;
            for (Profile profile2 : profileArray) {
                if (!JavaPlatformManager.compatibleProfile(profile2, profile)) continue;
                bl = true;
                hashSet.add(profile2);
            }
            if (bl) continue;
            return false;
        }
        return hashSet.size() == profileArray.length;
    }

    private static boolean compatibleProfile(Profile profile, Profile profile2) {
        String string = profile2.getName();
        SpecificationVersion specificationVersion = profile2.getVersion();
        return !(string != null && !string.equals(profile.getName()) || specificationVersion != null && !specificationVersion.equals((Object)profile.getVersion()));
    }

    private synchronized Collection<? extends JavaPlatformProvider> getProviders() {
        if (!this.providersValid) {
            if (this.providers == null) {
                this.providers = Lookup.getDefault().lookupResult(JavaPlatformProvider.class);
                this.providers.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent lookupEvent) {
                        JavaPlatformManager.this.resetCache(true);
                        JavaPlatformManager.this.firePropertyChange(JavaPlatformManager.PROP_INSTALLED_PLATFORMS);
                    }
                });
            }
            if (this.pListener == null) {
                this.pListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        JavaPlatformManager.this.resetCache(false);
                        JavaPlatformManager.this.firePropertyChange(JavaPlatformManager.PROP_INSTALLED_PLATFORMS);
                    }
                };
            }
            Collection collection = this.providers.allInstances();
            HashSet hashSet = new HashSet(collection);
            hashSet.removeAll(this.lastProviders);
            HashSet<? extends JavaPlatformProvider> hashSet2 = new HashSet<JavaPlatformProvider>(this.lastProviders);
            hashSet2.removeAll(collection);
            for (JavaPlatformProvider javaPlatformProvider : hashSet2) {
                javaPlatformProvider.removePropertyChangeListener(this.pListener);
            }
            for (JavaPlatformProvider javaPlatformProvider : hashSet) {
                javaPlatformProvider.addPropertyChangeListener(this.pListener);
            }
            this.lastProviders = collection;
            this.providersValid = true;
        }
        return this.lastProviders;
    }

    private synchronized void resetCache(boolean bl) {
        this.cachedPlatforms = null;
        this.providersValid &= !bl;
    }
}

