/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.column.ColumnMetadata;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ArrayLib;
import prefuse.util.collections.DefaultLiteralComparator;

public class DataLib {
    public static Object[] toArray(Iterator tuples, String field) {
        Object[] array = new Object[100];
        int i = 0;
        while (tuples.hasNext()) {
            if (i >= array.length) {
                array = ArrayLib.resize(array, 3 * array.length / 2);
            }
            array[i] = ((Tuple)tuples.next()).get(field);
            ++i;
        }
        return ArrayLib.trim(array, i);
    }

    public static double[] toDoubleArray(Iterator tuples, String field) {
        double[] array = new double[100];
        int i = 0;
        while (tuples.hasNext()) {
            if (i >= array.length) {
                array = ArrayLib.resize(array, 3 * array.length / 2);
            }
            array[i] = ((Tuple)tuples.next()).getDouble(field);
            ++i;
        }
        return ArrayLib.trim(array, i);
    }

    public static Object[] ordinalArray(Iterator tuples, String field) {
        return DataLib.ordinalArray(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Object[] ordinalArray(Iterator tuples, String field, Comparator cmp) {
        HashSet<Object> set = new HashSet<Object>();
        while (tuples.hasNext()) {
            set.add(((Tuple)tuples.next()).get(field));
        }
        Object[] o = set.toArray();
        Arrays.sort(o, cmp);
        return o;
    }

    public static Object[] ordinalArray(TupleSet tuples, String field) {
        return DataLib.ordinalArray(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Object[] ordinalArray(TupleSet tuples, String field, Comparator cmp) {
        if (tuples instanceof Table) {
            ColumnMetadata md = ((Table)tuples).getMetadata(field);
            return md.getOrdinalArray();
        }
        return DataLib.ordinalArray(tuples.tuples(), field, cmp);
    }

    public static Map ordinalMap(Iterator tuples, String field) {
        return DataLib.ordinalMap(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Map ordinalMap(Iterator tuples, String field, Comparator cmp) {
        Object[] o = DataLib.ordinalArray(tuples, field, cmp);
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (int i = 0; i < o.length; ++i) {
            map.put(o[i], new Integer(i));
        }
        return map;
    }

    public static Map ordinalMap(TupleSet tuples, String field) {
        return DataLib.ordinalMap(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Map ordinalMap(TupleSet tuples, String field, Comparator cmp) {
        if (tuples instanceof Table) {
            ColumnMetadata md = ((Table)tuples).getMetadata(field);
            return md.getOrdinalMap();
        }
        return DataLib.ordinalMap(tuples.tuples(), field, cmp);
    }

    public static int count(Iterator tuples, String field) {
        int i = 0;
        while (tuples.hasNext()) {
            ++i;
            tuples.next();
        }
        return i;
    }

    public static int uniqueCount(Iterator tuples, String field) {
        HashSet<Object> set = new HashSet<Object>();
        while (tuples.hasNext()) {
            set.add(((Tuple)tuples.next()).get(field));
        }
        return set.size();
    }

    public static Tuple min(Iterator tuples, String field) {
        return DataLib.min(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple min(Iterator tuples, String field, Comparator cmp) {
        Tuple t = null;
        Object min = null;
        if (tuples.hasNext()) {
            t = (Tuple)tuples.next();
            min = t.get(field);
        }
        while (tuples.hasNext()) {
            Tuple tmp = (Tuple)tuples.next();
            Object obj = tmp.get(field);
            if (cmp.compare(obj, min) >= 0) continue;
            t = tmp;
            min = obj;
        }
        return t;
    }

    public static Tuple min(TupleSet tuples, String field, Comparator cmp) {
        if (tuples instanceof Table) {
            Table table = (Table)tuples;
            ColumnMetadata md = table.getMetadata(field);
            return table.getTuple(md.getMinimumRow());
        }
        return DataLib.min(tuples.tuples(), field, cmp);
    }

    public static Tuple min(TupleSet tuples, String field) {
        return DataLib.min(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple max(Iterator tuples, String field) {
        return DataLib.max(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple max(Iterator tuples, String field, Comparator cmp) {
        Tuple t = null;
        Object min = null;
        if (tuples.hasNext()) {
            t = (Tuple)tuples.next();
            min = t.get(field);
        }
        while (tuples.hasNext()) {
            Tuple tmp = (Tuple)tuples.next();
            Object obj = tmp.get(field);
            if (cmp.compare(obj, min) <= 0) continue;
            t = tmp;
            min = obj;
        }
        return t;
    }

    public static Tuple max(TupleSet tuples, String field, Comparator cmp) {
        if (tuples instanceof Table) {
            Table table = (Table)tuples;
            ColumnMetadata md = table.getMetadata(field);
            return table.getTuple(md.getMaximumRow());
        }
        return DataLib.max(tuples.tuples(), field, cmp);
    }

    public static Tuple max(TupleSet tuples, String field) {
        return DataLib.max(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple median(Iterator tuples, String field) {
        return DataLib.median(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static Tuple median(Iterator tuples, String field, Comparator cmp) {
        Object[] t = new Tuple[100];
        int i = 0;
        while (tuples.hasNext()) {
            if (i >= t.length) {
                t = ArrayLib.resize(t, 3 * t.length / 2);
            }
            t[i] = (Tuple)tuples.next();
            ++i;
        }
        ArrayLib.trim(t, i);
        Object[] v = new Object[t.length];
        int[] idx = new int[t.length];
        for (i = 0; i < t.length; ++i) {
            idx[i] = i;
            v[i] = ((Tuple)t[i]).get(field);
        }
        ArrayLib.sort(v, idx, cmp);
        return (Tuple)t[idx[idx.length / 2]];
    }

    public static Tuple median(TupleSet tuples, String field, Comparator cmp) {
        if (tuples instanceof Table) {
            Table table = (Table)tuples;
            ColumnMetadata md = table.getMetadata(field);
            return table.getTuple(md.getMedianRow());
        }
        return DataLib.median(tuples.tuples(), field, cmp);
    }

    public static Tuple median(TupleSet tuples, String field) {
        return DataLib.median(tuples, field, (Comparator)DefaultLiteralComparator.getInstance());
    }

    public static double mean(Iterator tuples, String field) {
        try {
            int count = 0;
            double sum = 0.0;
            while (tuples.hasNext()) {
                sum += ((Tuple)tuples.next()).getDouble(field);
                ++count;
            }
            return sum / (double)count;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static double deviation(Iterator tuples, String field) {
        return DataLib.deviation(tuples, field, DataLib.mean(tuples, field));
    }

    public static double deviation(Iterator tuples, String field, double mean) {
        try {
            int count = 0;
            double sumsq = 0.0;
            while (tuples.hasNext()) {
                double x = ((Tuple)tuples.next()).getDouble(field) - mean;
                sumsq += x * x;
                ++count;
            }
            return Math.sqrt(sumsq / (double)count);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static double sum(Iterator tuples, String field) {
        try {
            double sum = 0.0;
            while (tuples.hasNext()) {
                sum += ((Tuple)tuples.next()).getDouble(field);
            }
            return sum;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static Class inferType(TupleSet tuples, String field) {
        if (tuples instanceof Table) {
            return ((Table)tuples).getColumnType(field);
        }
        Class type = null;
        Class type2 = null;
        Iterator iter = tuples.tuples();
        while (iter.hasNext()) {
            Tuple t = (Tuple)iter.next();
            if (type == null) {
                type = t.getColumnType(field);
                continue;
            }
            type2 = t.getColumnType(field);
            if (type.equals(type2)) continue;
            if (type2.isAssignableFrom(type)) {
                type = type2;
                continue;
            }
            if (type.isAssignableFrom(type2)) continue;
            throw new IllegalArgumentException("The data field [" + field + "] does not have " + "a consistent type across provided Tuples");
        }
        return type;
    }
}

